<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.security"></cv:cvMessages>
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
	<cv:cvMessages bundle="localization.usersJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.commcell"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-md-12">
		<span>
		<h1 class="float-left" data-ng-if="!isMsp && !(isReseller && isNotOwnCompany)" data-ng-bind="subscriptionData.name"></h1>
		<div class="float-left" data-ng-if="isMsp || (isReseller && isNotOwnCompany)"><cv-changename obj='subscriptionData' service-method='changeOrganizationName.do' callback="changeCompanyNameCallback"></cv-changename></div>
		</span>
		<cv-entity-pane entities="counts"/>
		<span>
			<cv-capability-links data-ng-if="subscriptionDetailsLoaded" cv-permitted-options="permittedOptions"></cv-capability-links>
		</span>
	</div>
</div>
<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
<div class="alert alert-sign-detail text-center" data-ng-if="subscriptionData && subscriptionData.isCompanyDeactivated">
	<div class="row">
		<div class="col-xs-12">
			<span class="alert-detail-icon k-icon k-i-warning"></span>
			<span data-ng-bind-html="deactivatedBanner"></span>
			<a href ="" data-ng-click="deactivateCompany('edit')" data-ng-if="!isTenantAdmin || (isReseller && isNotOwnCompany)">
				<cv:msg bundle="subscriptions" key="info.clickToEditLink" /> <i class="ion-chevron-right"></i>
			</a>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="subscriptionsDetails-label_general-subscriptions" data-title='<cv:msg key="label.general" bundle="subscriptions"/>' loader="subscriptionData.name">
			<ul class="list-style-secondary">
				<li class="group company-detail-list">
					<span class="pageDetailColumn"><cv:msg key="label.creationTime" bundle="subscriptions" /></span>
					<span class="pageDetailColumn"><div class="time crop" val="{{organizationInfo.orgCreationDateTime}}"></div></span>
				</li>
				<li class="group" data-ng-if="!companyAliasEditMode">
					<span class="pageDetail-three-columns-first"> <cv:msg bundle="subscriptions" key="label.companyAlias" /></span>
					<span class="pageDetail-three-columns-second" data-ng-bind="subscriptionData.companyAlias"></span>
					<a data-ng-if="isMsp || (isReseller && isNotOwnCompany)" class="pageDetail-three-columns-third" href=""  data-ng-click="editCompanyAlias()"><cv:msg key="action.edit" bundle="profiles"/></a>
				</li>
				<li class="group" data-ng-if="companyAliasEditMode && (isMsp || (isReseller && isNotOwnCompany))">
					<span class="pageDetailColumn"><cv:msg key="label.companyAlias" bundle="subscriptions" /></span>
					<span class="pageDetailColumn">
						<input class="half-width" type="text" data-ng-model = "subscriptionData.companyAlias"></input>
						<a class="horizontal-link-button" data-ng-click="fSaveCompanyAlias()"><i class="glyphicon glyphicon-ok"></i></a>
						<a data-ng-click="fDonotSaveCompanyAlias()"><i class="glyphicon glyphicon-remove"></i></a>
					</span>
				</li>
	  			<li class="group" >
					<span class="pageDetail-three-columns-first"><cv:msg key="label.associatedSMTP" bundle="subscriptions"/></span>
					<span class="pageDetail-three-columns-second">{{subscriptionData.emailDomainNames ? subscriptionData.emailDomainNames : '<cv:msg key="label.notSet" bundle="subscriptions"/>'}} </span>
					<a class="pageDetail-three-columns-third" href="" data-ng-click="editSmtp(subscriptionData.emailDomainNames)"><cv:msg key="action.editModal" bundle="profiles"/></a>
	  			</li>
	  			<li class="group" data-ng-if="showAuthCode && subscriptionData.id !== undefined" ><cv-generate-auth-code subscription-id="subscriptionId" subscription-data="subscriptionData" serverMessage="serverMessage"></cv-generate-auth-code></li>
	  			<div data-ng-if="showUserCentric">
		  			<li class = "group" data-ng-if = "isAdmin || isTenantAdmin">
						<span class="pageDetailColumn"><cv:msg key="label.enableUserCentric" bundle="subscriptions" /> </span>
						<span class="pageDetailColumn pull-right">
							<toggle-control class="{{userCentric}}" status="userCentric" data-ng-click="enableDisableUserCentricOption()" title="Enable/Disable <cv:msg key='label.enableUserCentric' bundle='subscriptions' />"></toggle-control>
						</span>
					</li>
				</div>
				<li class = "group" data-ng-if = "isAdmin || isTenantAdmin">
					<span class="pageDetailColumn"><cv:msg key="label.useUpn" bundle="subscriptions" /> </span>
					<span class="pageDetailColumn pull-right">
						<toggle-control class="{{useUPN}}" status="useUPN" data-ng-click="enableDisableUPNOption()" title="Enable/Disable <cv:msg key='label.useUpn' bundle='subscriptions' />"></toggle-control>
					</span>
				</li>
				<!-- TFA -->
				<li class="group" data-ng-if="(isAdmin || isTenantAdmin) && showTFA && subscriptionData">
					<cv-tfa-directive data-cv-id="companyTFADirective" source-page="subscriptionsDetails" subscription-data="subscriptionData"></cv-tfa-directive>
				</li>
				<!--Reseller-->
				<li class = "group">
					<span class="pageDetailColumn"><cv:msg key="label.enableReseller" bundle="subscriptions"/></span>
					<!-- Enable toggle to only MSPs only when canCreateCompanies is not set-->
					<span class="pageDetailColumn pull-right">
						<toggle-control  data-ng-class="!isMsp ? subscriptionData.canCreateCompanies ? 'enabled-activity disabled' : 'disabled-activity disabled' :  subscriptionData.canCreateCompanies ? 'enabled-activity disabled' : 'disabled-activity'" status="canCreateCompaniesStatus" data-ng-click="(!subscriptionData.canCreateCompanies && isMsp) && enableResellerModel()" data-ng-attr-title="{{ !isMsp ? ('label.cannotChangeReseller' | cvLoc) : subscriptionData.canCreateCompanies ? ('label.cannotDisableReseller' | cvLoc):('label.enableReseller' | cvLoc)}}"></toggle-control>
					</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.showDLP" bundle="subscriptions" /> </span>
					<span class="pageDetailColumn pull-right">
						<toggle-control class="dlpShowToggle" status="dlpShowToggle" data-ng-click="showHideDLP()" title="<cv:msg key="label.enableDisable" bundle="messages"/>"></toggle-control>
					</span>
				</li>
				<li class="group" data-ng-if = "isAdmin || isTenantAdmin">
					<span class="pageDetailColumn"><cv-help-text help-label="label.enableAutoDiscover" help-text="label.autoDiscoverHelpText" bundle='subscriptions'/></span>
					<span class="pageDetailColumn pull-right">
						<toggle-control status="autoDiscoverToggle" data-ng-click="enableDisableAutoDiscover()" title="<cv:msg key='label.enableAutoDiscover' bundle='subscriptions'/>"></toggle-control>
					</span>
				</li>
				<li class="group" data-ng-if="!bEditInfrastructureType">
					<span class="pageDetail-three-columns-first">
					<cv-help-text help-label="label.infrastructureType" help-text="label.infrastructureType.helpText"/></span>
					<span class="pageDetail-three-columns-second" data-ng-bind="sInfraStructureTypeLabel"></span>
					<a class="pageDetail-three-columns-third" data-ng-if="isMsp || (isReseller && isNotOwnCompany)" data-ng-click="fChangeInfraStructureType(true)"><cv:msg key="action.edit" bundle="profiles"/></a>
				</li>
				<li class="group no-horizontal-padding" data-ng-if="bEditInfrastructureType && (isMsp || (isReseller && isNotOwnCompany))">
					<span class="pageDetailColumn margin-top-10-important"><cv-help-text help-label="label.infrastructureType" help-text="label.infrastructureType.helpText"/></span>
					<span class="pageDetailColumn form-group">
						<select data-ng-model="subscriptionData.selectedInfraStructuretype" class="half-width">
							<option data-ng-repeat="oInfraStructureObject in aInfraStructureList" value="{{oInfraStructureObject.id}}" data-ng-disabled="oInfraStructureObject.disable">{{oInfraStructureObject.name}}</option>
						</select>
						<a class="horizontal-link-button" data-ng-click="fSaveInfraStructureType()"><i class="glyphicon glyphicon-ok"></i></a>
						<a data-ng-click="fDonotSaveInfrastructureChanges()"><i class="glyphicon glyphicon-remove"></i></a>
					</span>
				</li>
				<!-- Supported Solution Customization -->
				<li class="group no-horizontal-padding margin-top-10-important" data-ng-if="!bEditSupportedSolutions && (isMsp || (isReseller && isNotOwnCompany))">
					<span class="pageDetail-three-columns-first "><cv-help-text help-label="label.supportedSolutions" help-text="label.supportedSolutions.helpText"/></span>
					<span class="pageDetail-three-columns-second">
						<cv-fancy-tooltip id = "supportedSolutionsToolTip" cv-objects="fancyToolTipObject" cv-display-width="200"></cv-fancy-tooltip>
					</span>
					<a class="pageDetail-three-columns-third" data-ng-if="isMsp || (isReseller && isNotOwnCompany)" data-ng-click="editSupportedSolutions()"><cv:msg key="action.edit" bundle="profiles"/></a>
				</li>
				<li class="group no-horizontal-padding margin-top-10-important" data-ng-if="bEditSupportedSolutions && (isMsp || (isReseller && isNotOwnCompany))">
					<span class="pageDetailColumn"><cv-help-text help-label="label.supportedSolutions" help-text="label.supportedSolutions.helpText"/></span>
					<span class="pageDetailColumn inline-editor">
						<div class="inline-editor-input">
								<isteven-multi-select id="subscriptionsDetails_isteven-multi-select_#5064" input-model="supportedSolutionsInputArray" output-model="supportedSolutionsOutputArray" output-properties="bitPosition selected text" button-label="text" item-label="text" tick-property="selected"  directive-id="supportedsolutionsId" search-property="text" helper-elements="all none reset filter" max-labels="1" on-close="updateSupportedSolution(supportedSolutionsOutputArray)" on-item-click="itemClick(data)"></isteven-multi-select>
						</div>
						<span class="inline-editor-buttons">
								<a class="horizontal-link-button" data-ng-click="updateSupportedSolution(supportedSolutionsOutputArray)"><i class="glyphicon glyphicon-ok"></i></a>
								<a data-ng-click="updateSupportedSolution(supportedSolutionsOutputArray)"><i class="glyphicon glyphicon-remove"></i></a>
						</span>
					</span>
				</li>
				<cv-automatic-laptop-ownership data-ng-if="subscriptionData.name" source-page = "subscriptionsDetails" subscription-data = "subscriptionData"> </cv-automatic-laptop-ownership>
				<li class="group" ng-if="${ !cvConfig.isMultiCommcellAssociationHidden() } && isGlobalIDPRouterCommcell">
					<span class="pageDetail-three-columns-first"><cv:msg key="header.associations" bundle="commcell" /></span>
					<span class="pageDetail-three-columns-second"><fold-array empty-message='<cv:msg key="label.selectDefaultCompany" bundle="subscriptions" />' array="subscriptionData.associatedCommcells" offset="1" display-name="commCellName" is-link="true"></fold-array></span>
					<a ng-if="isMsp" class="pageDetail-three-columns-third" ng-click="showAssociatedCommcells()"><cv:msg key="action.editModal" bundle="profiles"/></a>
				</li>
				<li class="group" ng-if="subscriptionDetailsLoaded">
					<span class="pageDetailColumn"><cv:msg key="label.jobStartTime" bundle="profiles" /></span>
                	<span class="pageDetailColumn">
                		<cv-job-start-time on-save="jobStartTimeProps.onStartTimeChange(isEnabled, jobStartTime)" on-reset="jobStartTimeProps.onStartTimeChange()" job-start-time="jobStartTimeProps.jobStartTimeObj"></cv-job-start-time>
                	</span>
				</li>
			</ul>
		</cv-tile-component>
		<cv-security-component
		 	entity-type="securityAssociations.entityType"
		 	associations="securityAssociations.securityObject"
		 	associations-loaded="securityAssociations.loadSecurityAssociations"
		 	generic-entity="securityAssociations.genericEntity"
		></cv-security-component>
		<cv-tile-component data-ac-id="subscriptionsDetails-label_contacts-subscriptions" data-title='<cv:msg key="label.contacts" bundle="subscriptions"/>' loader="subscriptionData.name">
			<ul class="list-style-secondary" ng-if="organizationInfo.primaryContacts">
				<li class="group company-detail-list">
					<span class="pageDetailColumn"><cv:msg key="label.fullName" bundle="subscriptions" /></span>
					<span class="pageDetailColumn"><cv-fancy-tooltip cv-objects="subscriptionMapData" cv-display-width="300000"></cv-fancy-tooltip></span>
				</li>
				<li class="group" data-ng-if="false">
					<span class="pageDetailColumn"><cv:msg key="label.primaryContact" bundle="subscriptions" /></span>
					<span class="pageDetailColumn">{{primaryContact.name[0]}}</span>
				</li>
			</ul>
			<p ng-if="!organizationInfo.primaryContacts" class="info-place-holder"><cv:msg key="error.noContactsConfigured" bundle="profiles" /></p>
			<div class="page-details-box-links">
				<a href="" data-ng-click="modifyUserForCompany()"><cv:msg key="action.edit" bundle="profiles" />
				</a>
			</div>
		</cv-tile-component>
		<cv-tile-component data-ac-id="subscriptionsDetails-label_senders-subscriptions" data-title='<cv:msg key="label.senders" bundle="subscriptions"/>' min-height="true" loader="senderInfo">
			<ul class="list-style-secondary" data-ng-if='senderInfo.availableSender===true'>
				<li class="group comapny-detail-list">
					<span class="pageDetailColumn"><cv:msg key="label.senderName" bundle="subscriptions"/></span>
					<span class="pageDetailColumn">{{senderInfo.senderName}}</span>
				</li>
				<li class="group company-detail-list">
					<span class="pageDetailColumn"><cv:msg key="label.senderEmail" bundle="subscriptions"/></span>
					<span class="pageDetailColumn">{{senderInfo.senderSmtp}}</span>
				</li>
			</ul>
			<span data-ng-if='senderInfo.availableSender===false'>
				<p class="info-place-holder"><cv:msg key="label.noConfigured" bundle="subscriptions"/></p>
			</span>
			<div class="page-details-box-links" data-ng-if="showSenderEdit" >
				<a href="" data-ng-click="modifySendersForCompany()"><cv:msg key="action.edit" bundle="profiles" />
				</a>
			</div>
		</cv-tile-component>
		<div data-ng-if="subscriptionData.id !== undefined">
			<cv-encrytion-setting-component subscription-data="subscriptionData" generic-entity='genericEntity' ></cv-encrytion-setting-component>
		</div>
	</div>
	<div class="col-md-6">
		<cv-tile-component ng-if="showExternalAuthenticationTile" data-ac-id="subscriptionsDetails-label_externalAuthentication-security" data-title='<cv:msg key="label.externalAuthentication" bundle="security"/>' loader="externalAuthentication">
			<ul class="list-style__row group">
				<li class="group" data-ng-hide="externalAuthentication.isConfigured">
					<span class="info-place-holder"><cv:msg key="label.noConfigured" bundle="subscriptions"/>&#46;</span>
					<!-- showing the link in the same line if it is just a configure message -->
				</li>
				<li class="group" data-ng-hide="externalAuthentication.isConfigured == undefined">
					<a data-ng-href="{{ externalAuthentication.redirectLink }}" data-ng-click="authenticationAction(externalAuthentication)" data-ng-bind-html="externalAuthentication.actionMessage "></a>
				</li>
			</ul>
			<div class="page-details-box-links" data-ng-hide="externalAuthentication.isConfigured">
				<a class="float-right" data-ng-hide="externalAuthentication.isConfigured == false" data-ng-href="{{ externalAuthentication.redirectLink }}" data-ng-click="authenticationAction(externalAuthentication)" data-ng-bind-html="externalAuthentication.actionMessage"></a>
			</div>
		</cv-tile-component>
		<cv-domain-tile domain-info="domainInfo" subscription-id="subscriptionId"></cv-domain-tile>
		<cv-tile-component data-ac-id="subscriptionsDetails-label_profiles-profiles" data-title='<cv:msg key="label.profiles" bundle="profiles"/>' loader="subscriptionData.name" min-height="true">
			<ul class="list-style__row group plan-verbose-grid" data-ng-if="planGridOptions && planList.length" >
				<cv-grid cv-grid-options="planGridOptions"></cv-grid>
			</ul>
			<span data-ng-if="planList.length==0">
				<p class="info-place-holder"><cv:msg key="error.noPlansAssociatedToCompany" bundle="profiles"/></p>
			</span>
			<div class="page-details-box-links" data-ng-if="bShowEditPlan === true">
				<a href="" data-ng-click="modifyPlanForCompany(isNotOwnCompany)"><cv:msg key="action.edit" bundle="profiles" />
				</a>
			</div>
		</cv-tile-component>
		<cv-tile-component data-ac-id="subscriptionsDetails-pageHeader_navcustomization-settings" data-ng-if="isAdmin && (!isTenantAdmin || (isReseller && isNotOwnCompany))" data-title='<cv:msg key="pageHeader.navcustomization" bundle="settings" />' loader="subscriptionData.name" min-height="true" data-ng-if="isAdmin">
			<ul class="list-style__row group">
				<li>
					<a href="#navigationPreferences?subscriptionId={{subscriptionId}}&subscriptionName={{subscriptionData.name}}"><cv:msg key="label.navCustomization" bundle="subscriptions" /></a>
				</li>
			</ul>
		</cv-tile-component>
		<div data-ng-if ="isAdmin && subscriptionData && (subscriptionData.allowUsersToEnablePrivacy || subscriptionData.isPrivacyFeatureEnabledAtCommcell)">
		      <div data-ng-disabled="!isTenantAdmin || (isReseller && isNotOwnCompany) || !subscriptionData.isPrivacyFeatureEnabledAtCommcell || isTenantOperator"> 
				<cv-privacy-setting-component  subscription-data="subscriptionData" generic-entity='genericEntity' source-page = "subscriptionsDetails"></cv-privacy-setting-component>
			 </div>
	 	</div>
	 	
		<div data-ng-if ="isAdmin && subscriptionDataLoaded && (subscriptionData.isPasskeyFeatureEnabledAtCommcell || subscriptionData.advancedPrivacySettings.authType === 'USE_PASSKEY')">
			 <cv-passkey-setting-component  subscription-data="subscriptionData" generic-entity='genericEntity' source-page = "subscriptionsDetails"></cv-privacy-setting-component>			  
	 	</div>
	 	
	 	<cv-tile-component id="operatorsTile" data-ng-if="showOperators" data-ac-id="subscriptionsDetails-label_operators-subscriptions" data-title='<cv:msg key="label.operators" bundle="subscriptions" />' loader="subscriptionData.name" help-text="<cv:msg key="label.operatorHelpText" bundle="subscriptions" />" min-height="true">
			<span data-ng-if='operators.length==0'>
				<p class="info-place-holder"><cv:msg key="label.noOperatorsAssigned" bundle="subscriptions" /></p>
			</span>
			<div data-ng-if='operatorsList.length > 0'>
				<ul class="list-style-secondary" >
					<li class="group">
						<span class="pageDetailColumn userGroupColumn detailsName"><b><cv:msg key="label.userOrGroupName" bundle="users" /></b></span>
						<span class="pageDetailColumn">
							<b ><cv:msg key="label.Role" bundle="users" /></b>
						</span>
					</li>
				</ul>
				<ul class="list-style-secondary list-overflow-scroll">
					<li class="group" title="{{user.entityType}}" data-ng-repeat="operator in operatorsList track by $index">
						<div data-ng-if="(isMsp || isReseller)">
							<span class="pageDetailColumn {{operator.cssName}} userGroupColumn ellipsis-parent ellipsis-content" ><a data-ng-bind="operator.userOrGroupName" title="{{operator.userOrGroupName}}" data-ng-href={{operator.detailsPageLink}}></a></span>
						</div>
						<div data-ng-if="!(isMsp || isReseller)">
							<span class="pageDetailColumn {{operator.cssName}} userGroupColumn ellipsis-parent ellipsis-content" data-ng-bind="operator.userOrGroupName" title="{{operator.userOrGroupName}}"></span>
						</div>
						<span class="pageDetailColumn ellipsis-parent ellipsis-content" data-ng-bind="operator.roleName" title="{{operator.roleName}}"></span>
					</li>
				</ul>
			</div>
			<!-- Show edit option only if you are MSP or Tenant Admin-->
			<div class="page-details-box-links" data-ng-if="isMsp || isTenantAdmin" >
				<a href="" data-ng-click="modifyOperatorsForCompany()"><cv:msg key="action.edit" bundle="profiles" />
				</a>
			</div>
		</cv-tile-component>
		<div data-ng-if="showManageIdleClient && subscriptionDataLoaded">
			<cv-manage-idle-clients auto-retire-devices="subscriptionData.autoRetireDevices" level="COMPANY" entity-id="subscriptionData.id" entity-name="subscriptionData.name"></cv-manage-idle-clients>
		</div>		
		<div data-ng-if = "subscriptionData.globalFiltersInfo">
			<cv-global-exceptions-component id = "subscriptionData.id" data = "subscriptionData" source-page = "subscriptionsDetails"> </cv-global-exceptions-component>
		</div>
		<cv-entity-tags-tile data-ng-if="entityObject" entity="entityObject" has-edit-permissions="userHasEditTagsPermission"></cv-entity-tags-tile>
	</div>
</div>
