<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.blrJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.blrJs">
	<div  data-ng-controller="selectVAIOVM">
		<div class="setup-title">
			<h1><cv:msg key="label.selectDestination" bundle="blrJs" /></h1>
		</div>
		<div class="setup-content bootstrap-wrapper">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<form name="selectVmForm" novalidate cv-submit="select()" autocomplete="off" class="selectVmForm">
				<div class="panel">
					<div class="panel-body">
						<div class="form-group">
							<cv-vm-destinations
								selected-content='selectionStore'
								server-id="{{clientId}}"
								selectable-type="CLUSTER"
								single-selection-mode="true"
								hide-grouping="true"
								vendor="VMW">
							</cv-vm-destinations>
						</div>
						<div class="form-group">
							<div data-ng-if="uninstallSelected==false" class="col-xs-12 col-md-12">
								<label for="vibUrl" class="col-xs-12 col-md-2"><cv:msg key="label.vibUrl" bundle="blrJs" /></label>
								<div class="col-xs-12 col-md-10">
									<input type="text" id="vibUrl" name="vibUrl" required data-ng-model="vaioModal.vibUrl" />
									<span class="help-block" data-ng-show="selectVmForm.vibUrl.$error.required && cv.selectVmForm.needsAttention(selectVmForm.vibUrl)">
											<fmt:message key="error.vibUrl" /></span>
								</div>
							</div>
							<div data-ng-if="uninstallSelected==true">
								<input type="checkbox" id="detachVMs" name="detachVMs" data-ng-model="vaioModal.detachVMs"><label for="detachVMs"><cv:msg key="label.detachVMs" bundle="blrJs" /></label>
							</div>
						</div>
					</div>
				</div>
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
				  		<button id="selectVAIOVM_button_#4173" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
				  		<button id="selectVAIOVM_button_#6168" type="submit" class="btn btn-primary" ><fmt:message key="OK" /></button> 
				  	</fmt:bundle>
				</div>
			</form>
		</div>
	</div>
</fmt:bundle>