<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.restore">
	<div  data-ng-controller="selectRestoreDestinationVmController">
		<div class="setup-title">
			<h1>{{destinationHeader}}</h1>
		</div>
		<div class="setup-content">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<form name="selectVmForm" novalidate cv-submit="select()" autocomplete="off" class="selectVmForm">
				<cv-vm-destinations
					selected-content='selectionStore'
					tree-data='treeDataSelection'
					server-id="{{server.clientId}}"
					selectable-type="VM"
					single-selection-mode="true"
					hide-grouping="true"
					server-name="{{server.serverName}}"
					username="{{server.username}}"
					password="{{server.password}}"
					vendor="{{server.type}}"
					ctrl="ctrl"
					browse-type="currentBrowseType">
				</cv-vm-destinations>
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
				  		<button id="selectRestoreDestinationVmModal_button_#9492" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
				  		<button id="selectRestoreDestinationVmModal_button_#1590" type="submit" class="btn btn-primary" ><fmt:message key="OK" /></button> 
				  	</fmt:bundle>
				</div>
			</form>
		</div>
	</div>
</fmt:bundle>