<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.blrJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
<cv:cvEnum name="BlockReplication.BlockReplicationStatus"></cv:cvEnum>
<cv:cvEnum name="BlockReplication.BlockReplicationBootStatus"></cv:cvEnum>
<cv:cvEnum name="BlockReplication.BLRRecoveryType"></cv:cvEnum>
<cv:cvEnum name="BlockReplication.BlrRestorePointType"></cv:cvEnum>
<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
		<h1>{{bootTypeLabel}}</h1>
</div>
<fmt:bundle basename="localization.blrJs">
<div class="setup-content bootstrap-wrapper">
<span class="{{serverMessage.type}} serverMessage"
		data-ng-bind="serverMessage.message"></span>
	<form name="scheduleBootForm" novalidate autocomplete="off" id="scheduleBootForm" data-cv-submit="saveBootSchedule(this)" class="form-horizontal">
		<div class="panel">
			<div class="panel-body">
				<div class="form-group" ng-if="bootModalData.errMsg"><div class="col-md-9 col-lg-9 col-md-offset-3 col-lg-offset-3"  style="text-align:center;" ><span class="help-block">{{bootModalData.errMsg}}</span></div></div>
				<div class="form-group">
				     <label class="col-xs-12 col-md-5 col-lg-5" for="newVMName"><cv:msg key="label.vmName" bundle="blrJs"/></label>
				     <div class="col-xs-12 col-md-7 col-lg-7">
				            <input type="text" data-ng-maxlength="50" id="newVMName" name="newVMName" data-ng-model="bootModalData.newVMName" required ng-class="{'has-error': cv.scheduleBootForm.needsAttention(scheduleBootForm.newVMName)}"/>
				     </div>
				     <div class="col-md-7 col-lg-7 col-md-offset-5 col-lg-offset-5">
								<span class="help-block" ng-show="scheduleBootForm.newVMName.$error.required && cv.scheduleBootForm.needsAttention(scheduleBootForm.newVMName)">
									<fmt:message key="error.vmname"/>
								</span>
								<span class="help-block" ng-show="scheduleBootForm.newVMName.$error.maxlength && cv.scheduleBootForm.needsAttention(scheduleBootForm.newVMName)">
									<fmt:message key="error.vmname.length" />
								</span>
				 	</div>
				 </div>
				 <div class="form-group" data-ng-show="bootModalData.bootType==='test'">
					<label class="col-xs-12 col-md-5 col-lg-5" for="days"><cv:msg key="label.vmExpiryTime" bundle="blrJs"/></label>
					<div class="col-xs-12 col-md-3 col-lg-3">
						<input type="number" data-ng-model="bootModalData.days" min="0" max="30"  data-ng-maxlength="2"  id="days" name="days" required ng-class="{'has-error': cv.scheduleBootForm.needsAttention(scheduleBootForm.days)}"/> <label class="inline-label" for="days"><cv:msg key="label.days" bundle="blrJs"/></label>
					</div>
					<div class="col-xs-12 col-md-4 col-lg-4">
						<input type="number" data-ng-model="bootModalData.hours" min="0" max="23"  data-ng-maxlength="2"  id="hours" name="hours" required ng-class="{'has-error': cv.scheduleBootForm.needsAttention(scheduleBootForm.hours)}" /> <label class="inline-label" for="hours"><cv:msg key="label.hours" bundle="blrJs"/></label>
					</div>
					<div class="col-md-7 col-lg-7 col-md-offset-5 col-lg-offset-5">
						<span class="help-block" ng-show="scheduleBootForm.days.$invalid && cv.scheduleBootForm.needsAttention(scheduleBootForm.days)">
									<fmt:message key="error.expiryDays.invalid" />
						</span>
						<span class="help-block" ng-show="scheduleBootForm.hours.$invalid && cv.scheduleBootForm.needsAttention(scheduleBootForm.hours)">
									<fmt:message key="error.expiryHours.invalid" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="scheduleOption"><cv:msg key="label.scheduleOption" bundle="blrJs"/></label>
					<div class="col-md-7 col-lg-7">
						<select name="scheduleOption" id="scheduleOption" data-ng-model="bootModalData.selectedScheduleOption" data-ng-options="item.name for item in bootModalData.scheduleOptionsArr">
						</select>
					</div>
				</div>
				<div class="form-group" data-ng-if="bootModalData.selectedScheduleOption.value === 'bootFromRelativeTime'">
					<label class="col-xs-12 col-md-5 col-lg-5" for="to-picker">
						<cv-help-text help-label="label.relativeTime" help-text="label.info.relativeTime" ></cv-help-text>
					</label>
					<div class="col-md-7 col-lg-7" id="to-picker">
						<div uib-timepicker class="timeColumn" data-ng-model="bootModalData.picker.timePicker" minute-step="1" show-spinners="false"></div>
					</div>
				</div>
				<uib-accordion class="overflow-visible" close-others="true">
					<div uib-accordion-group is-open="bootModalData.schedulesTab" data-scroll-to-when-open>
						<uib-accordion-heading><cv:msg key="header.schedules" bundle="schedule" /><i class="pull-right glyphicon"
							data-ng-class="{'glyphicon-chevron-down': bootModalData.schedulesTab, 'glyphicon-chevron-right': !bootModalData.schedulesTab}"></i>
							<a data-ng-if="bootModalData.schedules.length == 0" class="pull-right accordion-heading-action-link margin-right-15" title="<cv:msg key="Add" bundle="messages" />" data-ng-click="addSchedule()">
							<cv:msg key="Add" bundle="messages" />
							</a>
						</uib-accordion-heading>
						<div data-ng-if="bootModalData.schedules.length == 0">
							<label class="inheritedSecurityAssociation "><cv:msg key="error.noScheduleAdded" bundle="schedule"/></label>
						</div>
						<div data-ng-if="bootModalData.schedules.length != 0">
							<div data-ng-repeat="schedule in bootModalData.schedules track by $index">
								<label>
									<a data-ng-click="editSchedule(schedule.schedulePattern)" data-ng-bind="schedule.schedulePattern.name"></a>
									<span class="delete-row"><a data-ng-click="deleteSchedulePattern($index)">&times;</a></span>
								</label>
							</div>
						</div>
					</div>
				</uib-accordion>
				<div data-ng-show="error.incompleteSchedules"><span class="help-block"><cv:msg key="error.incompleteSchedules" bundle="blrJs" /></span></div>
				<!-- commenting because backend has not finished implementing it yet
				<div class="form-group margin-0">
			        <label for="overwriteVM">
								<input name="overwriteVM" id="overwriteVM" type="checkbox" data-ng-model="bootModalData.overwriteVM" ">
								<label for="overwriteVM" class="overwriteLabel">
									<cv:msg key="label.overwriteVM" bundle="blrJs" />
								</label>
                     </label>
                 </div>
                 -->
				<cv-blr-network	hypervisor-id="row.destClientId" error-model="error" override-data="overrideData">
				</cv-blr-network>
			</div>
		</div>
		<div class="modal-footer">
			<fmt:bundle basename="localization.messages">
				<button id="scheduleBootModal_button_#5481" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button>
				<button id="scheduleBootModal_button_#0377"  type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" /></button>
			</fmt:bundle>
		</div>
		</div>
	</form>
</div>
</fmt:bundle>