<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<div data-ng-class="{'form-horizontal edit-users-grid-form bootstrap-wrapper' : mode === 'repGroup'}" id="replicationTargetForm">
	<div data-ng-class="{'col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2' : mode === 'repGroup' && !simplifiedRepGroup, 'col-xs-12' : simplifiedRepGroup}">
		<div class="{{serverMessage.type}}"
		data-ng-bind="serverMessage.message"></div>
		<cv-select-vms data-ng-if="showSelectVMs"
			vm-list="vmList"
			model="model"
			ctrl="ctrl"
			selection="{{!editMode ? 'multiple' : 'single'}}">
		</cv-select-vms>
		<!-- show only if at least one vm is selected while creating the group -->
		<div data-ng-if="mode!=='repGroup' || displayOptionDetails">
			<!-- General Options -->
			<div class="form-header cursor-pointer push-down"
				data-ng-init="settings.generalOpen = true"
				data-ng-click="settings.generalOpen = !settings.generalOpen"
				data-ng-show="mode!=='repTarget'">
				<cv:msg key="label.generalSettingsVMWare" bundle="restore" />
				<i class="pull-right"
					data-ng-class="{'ion-chevron-down': settings.generalOpen, 'ion-chevron-right': !settings.generalOpen}"></i>
			</div>
			<div data-uib-collapse="!settings.generalOpen">
			    <div data-ng-disabled="model.selectedVms[0].existedVm && mode !== 'repTarget'">
					<!-- display name -->
					<cv-display-name-azure
							restore-data="model.selectedVms[0]"
							mode="{{mode}}"
							ctrl="ctrl"
							is-multiple-mode="isMultipleMode"
							display-info="{{displayInfo}}"
							policy-app-type = "policyAppType">
					</cv-display-name-azure>
				</div>
				<div data-ng-disabled="model.selectedVms[0].existedVm && mode !== 'repTarget'">

					<!-- ESX Host -->
					<cv-vmware-esxhost
							hypervisor-id="destinationId"
							vm-options="model.selectedVms[0].vmOptions"
							ctrl="ctrl"
							data-ng-if="showDetails"
							mode="{{mode}}"
							edit-mode="editMode"
							policy-app-type = "policyAppType">
					</cv-vmware-esxhost>

					<!-- Datastore -->
					<cv-vmware-datastore
							hypervisor-id="destinationId"
							vm-options="model.selectedVms[0].vmOptions"
							ctrl="ctrl"
							data-ng-if="showDetails"
							edit-mode="editMode"
							policy-app-type = "policyAppType"
							mode="{{mode}}">
					</cv-vmware-datastore>

					<!-- resourcepool -->
					<cv-vmware-resource-pool
							hypervisor-id="destinationId"
							vm-options="model.selectedVms[0].vmOptions"
							ctrl="ctrl"
							data-ng-if="showDetails"
							edit-mode="editMode"
							policy-app-type = "policyAppType"
							mode="{{mode}}">
					</cv-vmware-resource-pool>
					<cv-vmware-folder
							hypervisor-id="destinationId"
							vm-options="model.selectedVms[0].vmOptions"
							ctrl="ctrl"
							mode="{{mode}}"
							data-ng-if="showDetails"
							edit-mode="editMode"
							policy-app-type = "policyAppType">
					</cv-vmware-folder>


				</div>
					<!-- network settings -->
					<cv-vmware-network-settings
							hypervisor-id="destinationId"
							source-hypervisor-id="sourceId"
							source-esx-host="model.selectedVms[0].vmHost"
							vm-options="model.selectedVms[0].vmOptions"
							mode="{{mode}}"
							ctrl="ctrl"
							edit-mode="editMode"
							policy-app-type = "policyAppType"
							data-ng-if="showDetails">
					</cv-vmware-network-settings>
					<!-- Ip Address settings -->
				<cv-vmware-ipaddress-settings
						data-ng-if="showIPSettings && showDetails"
						vm-options="model.selectedVms[0].vmOptions"
						ctrl="ctrl">
				</cv-vmware-ipaddress-settings>

				<cv-plain-accordion accordion-label="label.guestCredentials" data-ng-if="showGuestCredentials">
					<cv-credential-manager
						model="model.selectedVms[0].vmOptions.credentialsModel"
						input-name="model.selectedVms[0].vmOptions.credentialsModel.inputName"
						input-class="model.selectedVms[0].vmOptions.credentialsModel.inputClass"
						is-optional="true">
					</cv-credential-manager>
				</cv-plain-accordion>
			</div>
		</div>
	</div>
</div>
