<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<div data-ng-class="{'form-horizontal edit-users-grid-form' : mode === 'repGroup'}" id="replicationTargetForm">
	<div data-ng-class="{'col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2' : mode === 'repGroup'}">
		<div class="{{serverMessage.type}}"
		data-ng-bind="serverMessage.message"></div>
		<cv-select-vms data-ng-if="mode!=='repTarget'"
			vm-list="vmList"
			model="model"
			ctrl="ctrl"
			selection="{{!editMode ? 'multiple' : 'single'}}">
		</cv-select-vms>
		<!-- show only if at least one vm is selected while creating the group -->
		<div data-ng-if="mode!=='repGroup' || displayOptionDetails">
				<div>
					<!-- display name -->
					<cv-display-name-azure data-ng-if="mode ==='repGroup'"
							restore-data="model.selectedVms[0]"
							mode="{{mode}}"
							ctrl="ctrl"
							is-multiple-mode="isMultipleMode">
					</cv-display-name-azure>
					<!-- ESX Host -->
					<cv-openstack-availability-zones
							hypervisor-id="destinationId"
							vm-options="model.selectedVms[0].vmOptions"
							edit-mode="{{editMode}}"
							mode="{{mode}}"
							ctrl="ctrl">
					</cv-openstack-availability-zones>
						<div data-ng-if="(selectedAvailabilityZone || editMode) || mode ==='repGroup'">
								<!-- Additional Options -->
								<div class="form-header cursor-pointer push-down"
									data-ng-init="settings.additionalOptions = false"
									data-ng-click="settings.additionalOptions = !settings.additionalOptions"
									>
									<cv:msg key="label.additionalOptions" bundle="restore" />
									<i class="pull-right"
										data-ng-class="{'ion-chevron-down': settings.additionalOptions, 'ion-chevron-right': !settings.additionalOptions}"></i>
								</div>
								<div data-uib-collapse="!settings.additionalOptions">
									<!-- Volume type -->
									<div data-ng-if="displayOptions">
										<cv-datastore-openstack
											hypervisor-id="destinationId"
											source-hypervisor-id="sourceId"
											vm-options="model.selectedVms[0].vmOptions"
											mode="{{mode}}"
											ctrl="ctrl">
										</cv-datastore-openstack>
									</div>
									<!-- Flavor -->
									<div data-ng-if="displayOptions">
										<cv-flavor-openstack
											hypervisor-id="destinationId"
											source-hypervisor-id="sourceId"
											vm-options="model.selectedVms[0].vmOptions"
											mode="{{mode}}"
											ctrl="ctrl">
										</cv-flavor-openstack>
									</div>
									<!-- Security Group -->
									<div data-ng-if="displayOptions">
										<cv-security-group-openstack
											hypervisor-id="destinationId"
											source-hypervisor-id="sourceId"
											vm-options="model.selectedVms[0].vmOptions"
											mode="{{mode}}"
											ctrl="ctrl">
										</cv-security-group-openstack>
									</div>
									<!-- Key Pair -->
									<div data-ng-if="displayOptions">
										<cv-keypair-openstack
											hypervisor-id="destinationId"
											source-hypervisor-id="sourceId"
											vm-options="model.selectedVms[0].vmOptions"
											mode="{{mode}}"
											ctrl="ctrl">
										</cv-keypair-openstack>
									</div>
									<!-- Network Interface -->
									<div data-ng-if="displayOptions">
										<cv-network-interface-openstack
											hypervisor-id="destinationId"
											source-hypervisor-id="sourceId"
											vm-options="model.selectedVms[0].vmOptions"
											mode="{{mode}}"
											ctrl="ctrl">
										</cv-network-interface-openstack>
									</div>
								</div>
				          	</div>
      					</uib-accordion>
					</div>
			</div>
		</div>
	</div>
</div>
