<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.fs"></cv:cvMessages> //required to load fs.properties to show localized text correctly, for modal popup for test/perm mount
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.blrJs"></cv:cvMessages>
	<cv:cvEnum name="App.VSAFailoverStatus"></cv:cvEnum>
	<cv:cvEnum name="App.VSAReplicationStatus"></cv:cvEnum>
	<cv:cvEnum name="App.VMSLAStatus"></cv:cvEnum>
	<cv:cvEnum name="Common.VSVendor"></cv:cvEnum>
	<cv:cvEnum name="CvEntities.VMAllocationPolicyType"></cv:cvEnum>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvEnum name="App.TransportModeForVMWare"></cv:cvEnum>
	<cv:cvEnum name="TMMsg.DiskOption"></cv:cvEnum>
	<cv:cvEnum name="BlockReplication.BlockReplicationStatus"></cv:cvEnum>
	<cv:cvEnum name="BlockReplication.BlockReplicationBootStatus"></cv:cvEnum>
	<cv:cvEnum name="BlockReplication.BLRRecoveryType"></cv:cvEnum>
</script>
<div class="row" >
	<div class="col-md-12">
			<div data-ng-if="enableSimplifiedLiveSync" class="float-left" ><cv-changename obj='taskDetail' service-method='changeReplicationGroupName.do' callback="changeRepGroupNameCB"></cv-changename></div>
            <h1 data-ng-if="!enableSimplifiedLiveSync" class="float-left" data-ng-bind="taskDetail.forUI.replicationGroupName" ></h1>
			<!--For Oracle , there is no subclient content , hence using edit replication for Oracle.-->
			<cv-capability-links data-ng-if="replicationGroupsDetailsLoaded" cv-permitted-options="permittedOptions"></cv-capability-links>
	</div>
</div>

<div class="row" data-ng-if="!replicationGroupsDetailsLoaded && !replicationGroupsDetailsFailed && !enableSimplifiedLiveSync">
	<span class="col-md-12" class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
	<div class="col-md-6">
		<cv-tile-component loader="replicationGroupsDetailsLoaded">
		</cv-tile-component>
		<cv-tile-component loader="replicationGroupsDetailsLoaded">
		</cv-tile-component>
	</div>

	<div class="col-md-6">
		<cv-tile-component loader="replicationGroupsDetailsLoaded">
		</cv-tile-component>
		<cv-tile-component loader="replicationGroupsDetailsLoaded">
		</cv-tile-component>
	</div>
</div>

<div data-ng-if="enableSimplifiedLiveSync">
	<!-- New UI of VSA replication group  -->
	<cv-rep-group-vsa ctrl="ctrl"></cv-rep-group-vsa>
</div>

<div data-ng-if="!enableSimplifiedLiveSync || taskDetail.forUI.appName !== 'Virtual Server'">
	<div class="row" >
		<div class="col-md-6">
			<cv-tile-component data-ng-if="taskDetail.forUI.appName === 'Virtual Server'" title='<cv:msg key="label.replicationGroupsDetail" bundle="replicationGroups"/>' loader="replicationGroupsDetailsLoaded">
				<ul class="group list-style-secondary">
					<li class="group"><span class="pageDetailColumn"><cv:msg key="header.clientName" bundle="replicationGroups"/></span>
								<a data-ng-if="taskDetail.forUI.clientId !== null" href="#/clientDetails/{{taskDetail.forUI.clientId}}">{{taskDetail.forUI.clientName}}</a></li>
								<span data-ng-if="taskDetail.forUI.clientId === null"  class="pageDetailColumn" data-ng-bind="taskDetail.forUI.clientName"></span></li>
					<li class="group" ><span class="pageDetailColumn" data-ng-if="taskDetail.forUI.destinationLabel===null">
							<cv:msg key="header.destinationHypervisor" bundle="replicationGroups"/></span>
							<span class="pageDetailColumn" data-ng-if="taskDetail.forUI.destinationLabel===null && taskDetail.forUI.destinationId === null"><cv:msg key="label.notSet" bundle="replicationGroups"/></span>
							<span class="pageDetailColumn" data-ng-if="taskDetail.forUI.destinationLabel!==null && hideTarget">{{taskDetail.forUI.destinationLabel}}</span>
							<span class="pageDetailColumn"    data-ng-if="taskDetail.forUI.destinationId !== null && hideTarget">
							<span data-uib-tooltip="<cv:msg key="label.noTargetViewPermission" bundle="profiles"></cv:msg>">
								<a class="disabled" href="{{taskDetail.forUI.destinationUrl}}">{{taskDetail.forUI.destinationName}}</a></span>
							</span>
							<span class="pageDetailColumn" data-ng-if="taskDetail.forUI.destinationLabel!==null && !hideTarget">{{taskDetail.forUI.destinationLabel}}</span>
							<span class="pageDetailColumn"  data-ng-if="!hideTarget">
								<a data-ng-if="taskDetail.forUI.destinationId !== null && !hideTarget" href="{{taskDetail.forUI.destinationUrl}}">{{taskDetail.forUI.destinationName}}</a></span>
							<span data-ng-if="taskDetail.forUI.destinationId === null" class="pageDetailColumn" data-ng-bind="taskDetail.forUI.destinationName"></span></li>
					 <li class="group">
	                  <span class="pageDetailColumn">
	                   <cv:msg key="header.destinationVendor" bundle="vmsJs"/>
		              </span>
		              <span data-ng-if="taskDetail.forUI.vendorType" class="pageDetailColumn" data-ng-bind="taskDetail.forUI.vendorType"></span>
		              <span data-ng-if="!taskDetail.forUI.vendorType"><cv:msg key="label.notSet" bundle="replicationGroups"/></span>
		             </li>

					<!-- VM Group -->
					<li data-ng-if="taskDetail.forUI.subclientId && !enableSimplifiedLiveSync" class="group">
						<span class="pageDetailColumn">
							<cv:msg key="label.vmGroups" bundle="collectionsJs"/>
						</span>
						<a href="#collectionDetails/{{taskDetail.forUI.clientId}}/{{taskDetail.forUI.subclientId}}" class="pageDetailColumn" data-ng-bind="taskDetail.forUI.subclientName"></a>
					</li>

					<li class="group" data-ng-if="taskDetail.forUI.proxy">
						<span class="pageDetailColumn"><cv:msg key="label.accessNode" bundle="restore"/></span>
						<span class="pageDetailColumn">{{taskDetail.forUI.proxy}}</span>
					</li>

					<li class="group" data-ng-if="!enableSimplifiedLiveSync">
						<span class="pageDetailColumn">
							<cv:msg key="header.state" bundle="replicationGroups"/>
						</span>
						<span class="pageDetailColumn" data-ng-bind="taskDetail.forUI.stateLabel"></span>
					</li>
				</ul>
			</cv-tile-component>
			<cv-tile-component data-ng-if="taskDetail.forUI.appName === 'File System'"
				data-ac-id="replicationGroupsDetail-label_replicationGroupsDetail-replicationGroups"
				title='<cv:msg key="label.replicationGroupsDetail" bundle="replicationGroups"/>'
				loader="replicationGroupsDetailsLoaded">
	            <ul class="group list-style-secondary">
	                <li class="group"><span class="pageDetailColumn"><cv:msg key="header.sourceclient" bundle="replicationGroups"/></span>
	                            <a data-ng-if="taskDetail.forUI.clientId !== null" href="#/servers/{{taskDetail.forUI.clientId}}">{{taskDetail.forUI.clientName}}</a></li>
	                            <span data-ng-if="taskDetail.forUI.clientId === null"  class="pageDetailColumn" data-ng-bind="taskDetail.forUI.clientName"></span></li>
	                <li class="group" ><span class="pageDetailColumn" data-ng-if="taskDetail.forUI.destinationLabel===null">
	                        <cv:msg key="header.destinationclient" bundle="replicationGroups"/></span>
	                        <span class="pageDetailColumn" data-ng-if="taskDetail.forUI.destinationLabel!==null">{{taskDetail.forUI.destinationLabel}}</span>
	                        <a data-ng-if="taskDetail.forUI.destinationId !== null" href="{{taskDetail.forUI.destinationUrl}}">{{taskDetail.forUI.destinationName}}</a></li>
	                        <span data-ng-if="taskDetail.forUI.destinationId === null" class="pageDetailColumn" data-ng-bind="taskDetail.forUI.destinationName"></span></li>

	                <li class="group"><span class="pageDetailColumn"  data-ng-if="!enableSimplifiedLiveSync">
	                	<cv:msg key="header.state" bundle="replicationGroups"/></span>
	                    <span class="pageDetailColumn" data-ng-bind="taskDetail.forUI.stateLabel"></span>
	                </li>

	                <li data-ng-if="taskDetail.forUI.plan" class="group"><span class="pageDetailColumn" ><cv:msg key="label.plan" bundle="restore"/></span>
						<span class="pageDetailColumn">{{taskDetail.forUI.plan}}</span>
					</li>
	            </ul>
	        </cv-tile-component>
		</div>

		<div class="col-md-6">
			 <cv-tile-component data-ng-if="(taskDetail.forUI.appName === 'Virtual Server' || taskDetail.forUI.appName === 'File System')" data-ac-id="replicationGroupsDetail-label_replicationGroupsDetail-advancedOptions" title='<cv:msg key="label.advanced.options" bundle="restore"/>'>
				<ul class="group list-style-secondary" >
					<li class="group" data-ng-if="showPowerOnOption"><span class="pageDetailColumn"><cv:msg key="label.powerOn.replication" bundle="restore"/></span>
						<span class="pageDetailColumn">{{taskDetail.forUI.powerOnVmAfterRestore}}</span>
					</li>
					<li data-ng-if="taskDetail.forUI.diskOption" class="group"><span class="pageDetailColumn" ><cv:msg key="label.diskProvisioning" bundle="collectionsJs"/></span>
						<span class="pageDetailColumn" >{{taskDetail.forUI.diskOption}}</span>
					</li>
					<li data-ng-if="taskDetail.forUI.transportMode" class="group"><span class="pageDetailColumn" ><cv:msg key="header.transportMode" bundle="vmsJs"/></span>
						<span class="pageDetailColumn">{{taskDetail.forUI.transportMode}}</span>
					</li>
					<%-- <li class="group" data-ng-if="taskDetail.forUI.powerOnVmAfterRestore && taskDetail.taskInfo.subTasks.copyPrecedence!==null && taskDetail.taskInfo.subTasks.copyPrecedence === true"><span class="pageDetailColumn"><cv:msg key="label.selectCopy" bundle="restore"/></span>
						<span><cv:msg key="label.yes" bundle="restore"/></span>
					</li> --%>
				<%-- 	<li class="group" data-ng-if="taskDetail.forUI.powerOnVmAfterRestore && taskDetail.taskInfo.subTasks.copyPrecedence!==null && taskDetail.taskInfo.subTasks.copyPrecedence === false"><span class="pageDetailColumn"><cv:msg key="label.selectCopy" bundle="restore"/></span>
						<span><cv:msg key="label.no" bundle="restore"/></span>
					</li> --%>
					<li class="group" data-ng-if="taskDetail.taskInfo.subTasks.restoreAcls!==null && taskDetail.forUI.restoreAcls === true" class="group"><span class="pageDetailColumn" ><cv:msg key="label.restoreDataAcls" bundle="restore"/></span>
						<span><cv:msg key="label.yes" bundle="restore"/></span>
					</li>
					<li class="group" data-ng-if="taskDetail.taskInfo.subTasks.restoreAcls!==null && taskDetail.forUI.restoreAcls === false" class="group"><span class="pageDetailColumn" ><cv:msg key="label.restoreDataAcls" bundle="restore"/></span>
						<span><cv:msg key="label.no" bundle="restore"/></span>
					</li>
					<li class="group" data-ng-if="taskDetail.taskInfo.subTasks.validateOnly!==null && taskDetail.forUI.validateOnly === true" class="group"><span class="pageDetailColumn" ><cv:msg key="label.validateOnly" bundle="restore"/></span>
						<span><cv:msg key="label.yes" bundle="restore"/></span>
					</li>
				<li class="group" data-ng-if="taskDetail.taskInfo.subTasks.validateOnly!==null && taskDetail.forUI.validateOnly === false" class="group"><span class="pageDetailColumn" ><cv:msg key="label.validateOnly" bundle="restore"/></span>
						<span><cv:msg key="label.no" bundle="restore"/></span>
					</li>
					<li class="group" data-ng-if="taskDetail.taskInfo.subTasks.unconditialOverwrite!==null && taskDetail.taskInfo.subTasks.unconditialOverwrite === true"><span class="pageDetailColumn"><cv:msg key="label.overWrite" bundle="restore"/></span>
						<span><cv:msg key="label.yes" bundle="restore"/></span>
					</li>
					<li class="group" data-ng-if="taskDetail.taskInfo.subTasks.unconditialOverwrite!==null && taskDetail.taskInfo.subTasks.unconditialOverwrite === false"><span class="pageDetailColumn"><cv:msg key="label.overWrite" bundle="restore"/></span>
						<span><cv:msg key="label.no" bundle="restore"/></span>
					</li>
					<li class="group" data-ng-if="showDeployVmWhenFailover"><span class="pageDetailColumn"><cv:msg key="label.deployVmDuringFailover" bundle="replicationGroups"/></span>
						<span class="pageDetailColumn">{{taskDetail.forUI.deployVmWhenFailover}}</span>
					</li>
					<cv-replication-operation-window task-id="taskId" schedule-name="taskDetail.forUI.replicationGroupName"></cv-replication-operation-window>
				</ul>
			</cv-tile-component>
		</div>

	</div>

	<div class="row">
		<div class="col-md-6">
			<cv-tile-component data-ng-if="['SQL Server', 'Oracle Database', 'SAP HANA'].indexOf(taskDetail.forUI.appName) > -1" title='<cv:msg key="label.replicationGroupsDetail" bundle="replicationGroups"/>' loader="replicationGroupsDetailsLoaded">
				<ul class="group list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="header.clientName" bundle="replicationGroups"/></span>
						<a data-ng-if="taskDetail.forUI.clientId !== null" href="#/clientDetails/{{taskDetail.forUI.clientId}}">{{taskDetail.forUI.clientName}}</a>
						<span data-ng-if="taskDetail.forUI.clientId === null" class="pageDetailColumn" >{{taskDetail.forUI.clientName}}</span></li>
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="header.instanceName" bundle="replicationGroups"/></span>
						<a data-ng-if="taskDetail.forUI.sourceInstanceId !== null && taskDetail.forUI.appName === 'SQL Server'" href="#/instances/{{taskDetail.forUI.sourceInstanceId}}??clientId={{taskDetail.forUI.clientId}}&instanceName={{taskDetail.forUI.sourceInstanceName}}">{{taskDetail.forUI.sourceInstanceName}}</a>
						<a data-ng-if="taskDetail.forUI.sourceInstanceId !== null && (taskDetail.forUI.appName === 'Oracle Database' || taskDetail.forUI.appName === 'SAP HANA')" href="#/databaseDetails/{{taskDetail.forUI.sourceInstanceId}}">{{taskDetail.forUI.sourceInstanceName}}</a>
						<span data-ng-if="taskDetail.forUI.sourceInstanceId === null" class="pageDetailColumn">{{taskDetail.forUI.sourceInstanceName}}</span>
					<li class="group" data-ng-if="taskDetail.forUI.appName === 'SAP HANA' && taskDetail.forUI.destinationBackupsetName">
						<span class="pageDetailColumn"><cv:msg key="header.database" bundle="replicationGroups"/></span>
						<a data-ng-if="taskDetail.forUI.sourceBackupsetId !== null && taskDetail.forUI.appName === 'SAP HANA'" href="#/dbBackupsetDetails/{{taskDetail.forUI.sourceBackupsetId}}">{{taskDetail.forUI.sourceBackupsetName}}</a>
						<span data-ng-if="taskDetail.forUI.sourceBackupsetId === null" class="pageDetailColumn">{{taskDetail.forUI.sourceBackupsetName}}</span>
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="header.state" bundle="replicationGroups"/></span>
						<span class="pageDetailColumn" data-ng-bind="taskDetail.forUI.stateLabel"></span></li>
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="header.destinationName" bundle="replicationGroups"/></span>
						<a data-ng-if="taskDetail.forUI.destinationClientId !== null" href="#/clientDetails/{{taskDetail.forUI.destinationClientId}}">{{taskDetail.forUI.destinationClientName}}</a>
						<span data-ng-if="taskDetail.forUI.destinationClientId === null"class="pageDetailColumn" >{{taskDetail.forUI.destinationClientName}}</span></li>
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="header.destinationInstanceName" bundle="replicationGroups"/></span>
						<a data-ng-if="taskDetail.forUI.destinationInstanceId !== null && taskDetail.forUI.appName === 'SQL Server'" href="#/instances/{{taskDetail.forUI.destinationInstanceId}}??clientId={{taskDetail.forUI.destinationClientId}}&instanceName={{taskDetail.forUI.destinationInstanceName}}">{{taskDetail.forUI.destinationInstanceName}}</a>
						<a data-ng-if="taskDetail.forUI.destinationInstanceId !== null && (taskDetail.forUI.appName === 'Oracle Database' || taskDetail.forUI.appName === 'SAP HANA')" href="#/databaseDetails/{{taskDetail.forUI.destinationInstanceId}}">{{taskDetail.forUI.destinationInstanceName}}</a>
						<span class="pageDetailColumn" data-ng-if="taskDetail.forUI.destinationInstanceId === null" >{{taskDetail.forUI.destinationInstanceName}}</span></li>
					<li class="group" data-ng-if="taskDetail.forUI.appName === 'SAP HANA' && taskDetail.forUI.destinationBackupsetName">
						<span class="pageDetailColumn"><cv:msg key="header.database" bundle="replicationGroups"/></span>
						<a data-ng-if="taskDetail.forUI.destinationBackupsetId !== null" href="#/dbBackupsetDetails/{{taskDetail.forUI.destinationBackupsetId}}">{{taskDetail.forUI.destinationBackupsetName}}</a>
						<span data-ng-if="taskDetail.forUI.destinationBackupsetId === null" class="pageDetailColumn">{{taskDetail.forUI.destinationBackupsetName}}</span>
					<li  data-ng-if="taskDetail.forUI.replicationSchedule" class="group">
						<span class="pageDetailColumn">
							<cv:msg key="label.schedule" bundle="profiles"/>
						</span>
						<span class="pageDetailColumn" data-ng-bind="taskDetail.forUI.replicationSchedule"></span>
					</li>
				</ul>
			</cv-tile-component>
		</div>
		<div class="col-md-6" >
			<cv-tile-component data-ng-if="['SQL Server', 'Oracle Database', 'SAP HANA'].indexOf(taskDetail.forUI.appName) > -1" title="<cv:msg key="label.advanced.options" bundle="restore"/>"  loader="replicationGroupsDetailsLoaded">
				<ul class="list-style-secondary">
					<cv-replication-operation-window task-id="taskId" schedule-name="taskDetail.forUI.replicationGroupName"></cv-replication-operation-window>
				</ul>
			</cv-tile-component>
		</div>
	</div>

	<div class="row col-md-12 navigation" data-ng-if="['SQL Server', 'File System', 'Oracle Database', 'Virtual Server', 'SAP HANA'].indexOf(taskDetail.forUI.appName) > -1" >
		<cv-replication-monitor
			task-id="taskId"
			app-type-id="taskDetail.forUI.appTypeId">
		</cv-replication-monitor>
		<br />
	</div>

	<div class="row col-md-12 navigation" ng-if="replicationGroupsDetailsLoaded && taskDetail.forUI.appName === 'Virtual Server' && 
	!taskDetail.useAllocationPolicyForRestore && !hideDetails" >
		<div class="col-md-12 navigation">
			<cv-replication-groups-summary
				advanced-rst-options="taskDetail.forUI.advancedRstOptions"
				vendor="taskDetail.forUI.vendorType">
	         </cv-replication-groups-summary>
	    </div>
	</div>

	<div class="row col-md-12 navigation" ng-if="(replicationGroupsDetailsLoaded && taskDetail.forUI.appName === 'Virtual Server' || 
	taskDetail.forUI.appName === 'File System') && !taskDetail.useAllocationPolicyForRestore && hideDetails" >
		<cv-replication-groups-summary
			advanced-rst-options="taskDetail.forUI.advancedRstOptions"
			vendor="taskDetail.forUI.vendorType"
			replication-type="taskDetail.forUI.replicationType">
	     </cv-replication-groups-summary>
	</div>
</div>
