<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.overrideReplicationOptions" bundle="replicationGroups" /></h1>
</div>
<div class="bootstrap-wrapper">
	<form id="repGrpEditVMForm" name="repGrpEditVMForm" data-cv-submit="repGrpEditVMCtrl.save()" cv-hide-api>

		<cv-restore-options-vmware data-ng-if="(repGrpEditVMCtrl.replicationGroup.vendor === 'VMW')"
			vm-list="repGrpEditVMCtrl.vmsToOverride"
			modified-vms="repGrpEditVMCtrl.replicationGroup.modifiedVms"
			source-id={{repGrpEditVMCtrl.replicationGroup.selectedHypervisor.clientId}}
			destination-id="repGrpEditVMCtrl.replicationGroup.destinationHyperV.clientId"
			replication-type="{{repGrpEditVMCtrl.replicationGroup.attributes.replicationType}}"
			edit-mode="editMode"
			mode="repGroup"
			ctrl="repGrpEditVMCtrl.ctrl"
			show-guest-credentials="repGrpEditVMCtrl.showGuestCredentialsVMWare">
		</cv-restore-options-vmware>

		<cv-restore-options-amazon data-ng-if="(repGrpEditVMCtrl.replicationGroup.vendor === 'AMAZON')"
			vm-list="repGrpEditVMCtrl.vmsToOverride"
			modified-vms="repGrpEditVMCtrl.replicationGroup.modifiedVms"
			destination-for-vm-list="repGrpEditVMCtrl.replicationGroup.destinationHyperV"
			proxy-client-for-vm-list="repGrpEditVMCtrl.replicationGroup.amazonProxyClientForVMList"
			mode="repGrpEditVMCtrl.replicationGroup.restoreOptionsAWSMode"
			edit-mode="editMode"
			ctrl="repGrpEditVMCtrl.ctrl"
			is-amazon-proxy-selected="repGrpEditVMCtrl.replicationGroup.isAmazonProxy"
			is-aws-cross-restore="repGrpEditVMCtrl.replicationGroup.isAWSCrossRestore">
		</cv-restore-options-amazon>

		<cv-restore-options-azure data-ng-if="(repGrpEditVMCtrl.replicationGroup.vendor === 'AZURE_V2' || repGrpEditVMCtrl.replicationGroup.vendor === 'AZURE_STACK')"
			vendor="repGrpEditVMCtrl.replicationGroup.vendor"
			src-vendor="repGrpEditVMCtrl.sourceVendor"
			vm-list="repGrpEditVMCtrl.vmsToOverride"
			modified-vms="repGrpEditVMCtrl.replicationGroup.modifiedVms"
			mode=restore
			edit-mode="editMode"
			destination-for-vm-list="repGrpEditVMCtrl.replicationGroup.destinationHyperV"
			ctrl="repGrpEditVMCtrl.ctrl">
		</cv-restore-options-azure>

		<cv-restore-options-hyperv data-ng-if="(repGrpEditVMCtrl.replicationGroup.vendor === 'MICROSOFT')"
			vendor="repGrpEditVMCtrl.replicationGroup.vendor"
			vm-list="repGrpEditVMCtrl.vmsToOverride"
			mode=restore
			modified-vms="repGrpEditVMCtrl.replicationGroup.modifiedVms"
			edit-mode="editMode"
			ctrl="repGrpEditVMCtrl.ctrl"
			source-id="repGrpEditVMCtrl.replicationGroup.selectedHypervisor.clientId"
			destination-id="repGrpEditVMCtrl.replicationGroup.destinationHyperV.clientId"
			selected-proxy="repGrpEditVMCtrl.replicationGroup.selectedProxy">
		</cv-restore-options-hyperv>

		<cv-restore-options-oci data-ng-if="(repGrpEditVMCtrl.replicationGroup.vendor === 'ORACLE_CLOUD_INFRASTRUCTURE')"
			vendor ="repGrpEditVMCtrl.replicationGroup.vendor"
			vm-list="repGrpEditVMCtrl.vmsToOverride"
			mode=restore
			modified-vms="repGrpEditVMCtrl.replicationGroup.modifiedVms"
			edit-mode="editMode"
			ctrl="repGrpEditVMCtrl.ctrl"
			source-id="repGrpEditVMCtrl.replicationGroup.selectedHypervisor.clientId"
			destination-id="repGrpEditVMCtrl.replicationGroup.destinationHyperV.clientId"
			selected-proxy="repGrpEditVMCtrl.replicationGroup.selectedProxy">
		</cv-restore-options-oci>

		<cv-restore-options-openstack data-ng-if="(repGrpEditVMCtrl.replicationGroup.vendor === 'OPENSTACK')"
			vendor="repGrpEditVMCtrl.replicationGroup.vendor"
			vm-list="repGrpEditVMCtrl.vmsToOverride"
			modified-vms="repGrpEditVMCtrl.replicationGroup.modifiedVms"
			source-id={{repGrpEditVMCtrl.replicationGroup.selectedHypervisor.clientId}}
			destination-id="repGrpEditVMCtrl.replicationGroup.destinationHyperV.clientId"
			replication-type="{{repGrpEditVMCtrl.replicationGroup.attributes.replicationType}}"
			edit-mode="editMode"
			mode="repGroup"
			ctrl="repGrpEditVMCtrl.ctrl">
		</cv-restore-options-openstack>
		<cv-restore-options-nutanix data-ng-if="(repGrpEditVMCtrl.replicationGroup.vendor === 'NUTANIX')"
			vendor="repGrpEditVMCtrl.replcationGroup.vendor"
			vm-list="repGrpEditVMCtrl.vmsToOverride"
			modified-vms="repGrpEditVMCtrl.replicationGroup.modifiedVms"
			source-id={{repGrpEditVMCtrl.replicationGroup.selectedHypervisor.clientId}}
			destination-id="repGrpEditVMCtrl.replicationGroup.destinationHyperV.clientId"
			replication-type="{{repGrpEditVMCtrl.replicationGroup.attributes.replicationType}}"
			edit-mode="editMode"
			mode="repGroup"
			ctrl="repGrpEditVMCtrl.ctrl">
		</cv-restore-options-nutanix>
		<cv-restore-options-googlecloud data-ng-if="(repGrpEditVMCtrl.replicationGroup.vendor === 'GOOGLE_CLOUD')"
			vendor="repGrpEditVMCtrl.replcationGroup.vendor"
			vm-list="repGrpEditVMCtrl.vmsToOverride"
			modified-vms="repGrpEditVMCtrl.replicationGroup.modifiedVms"
			source-id="repGrpEditVMCtrl.replicationGroup.selectedHypervisor.clientId"
			destination-id="repGrpEditVMCtrl.replicationGroup.destinationHyperV.clientId"
			edit-mode="repGrpEditVMCtrl.editRepGroup"
			mode="repGroup"
			ctrl="repGrpEditVMCtrl.ctrl">
		</cv-restore-options-googlecloud>

		<div class="button-container">
			<button type="button" data-ng-click="repGrpEditVMCtrl.cancel()" class="btn btn-default cvBusyOnAjax">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button type="submit" class="btn btn-primary cvBusyOnAjax">
				<cv:msg key="Save" bundle="messages" />
			</button>
		</div>
	</form>
</div>