	<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
	<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
	<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
	<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	</script>
	<fmt:bundle basename="localization.settings">
	<span class="center-container">
		<div class="center-container__center-el">
			<div class="back-strip">
				<div class="set-up-page" data-ng-controller="registerWithCloudController">
	
					<div class="setup-title">
						<h1><fmt:message key="pageHeader.registerCloudHeading" /></h1>
						<h4 data-ng-if="!hideForm"><fmt:message key="pageHeader.registerCloud" /></h4>
					</div>
					<div class="setup-content">
						<span class="{{registerCloudMessage.type}} serverMessage">{{registerCloudMessage.message}}</span>
						<form name="registerCloudForm" novalidate data-cv-submit="registerCloud()" autocomplete="off">
							<div data-ng-if="!hideForm">
							
								<!-- fake fields are a workaround for chrome autofill getting the wrong fields and filling it with login credentials for add Server-->
								<input style="display:none" type="text" name="fakeusernameremembered"/>
								<input style="display:none" type="password" name="fakepasswordremembered"/>
								
								<label for="cloudEmail"><fmt:message key="label.cloudEmail" />
									<input type="text" name="cloudEmail" id="cloudEmail" data-ng-model="model.cloudEmail" autocomplete="off" ng-pattern="/^[_a-z0-9]+(\.[_a-z0-9]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4})$/" required />
									<span class="help-block" data-ng-show="cv.registerCloudForm.needsAttention(registerCloudForm.cloudEmail) || showError"><fmt:message key="error.cloudEmail" /></span>
								</label>
								<label for="cloudPassword"><fmt:message key="label.cloudPassword" />
									<input type="password" name="cloudPassword" id="cloudPassword" data-ng-model="model.cloudPassword" autocomplete="off" required/>
									<span class="help-block" data-ng-show="cv.registerCloudForm.needsAttention(registerCloudForm.cloudPassword) || showError"><fmt:message key="error.cloudPassword" /></span>
								</label>				
								
							</div>
								
							<div class="button-container" data-ng-if="!hideForm">
								<fmt:bundle basename="localization.messages">
									<button id="registerCloud_button_#2341" type="submit" class="btn btn-primary cvBusyOnAjax"><fmt:message key="Save" /></button> 
									<button id="registerCloud_button_#6711" type="button" class="btn btn-default skip-btn--hidden" data-ng-click="cancel()"><fmt:message key="Skip" /></button> 
								</fmt:bundle>
							</div>
							<div class="button-container" data-ng-if="hideForm" style="text-align: center;">
								<fmt:bundle basename="localization.messages">
								<button id="registerCloud_button_#3020" type="button" class="btn btn-default skip-btn--hidden"  data-ng-click="cancel()"><fmt:message key="Continue" /></button> 
								</fmt:bundle>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</span>
	</fmt:bundle>
