<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.regions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.security"></cv:cvMessages>
</script>
<div data-ng-controller="regionDetailsController as rgCtrl">
<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
<div class="row tile_count" data-ng-if="counts[0].value!==undefined">
	<div class="col-md-2 tile-inline-5" data-ng-repeat="count in counts">
         <div class="tile-count">
         	<a href="{{count.link}}">
	         	<div class="tile-icon-wrapper" ng-style="{'background':'{{count.color}}'}">
	         		<span data-ng-bind-html="count.svg"></span>
	         	</div>
	         	<div class="tile-count-number">{{count.value}}</div>
	         	<div class="tile-status-wrapper">
	         		<span class="tile-status-link" title="{{count.name}}">{{count.name}}</span>
	         	</div>
         	</a>
         </div>
    </div>
</div>
<div class="row">
	<div class="col-md-12">
			<span data-ng-if="rgCtrl.showEdit"><cv-changename obj='rgCtrl.changeNameObj' change="rgCtrl.regionNameChange(id,name)" class="float-left"></cv-changename></span>
			<cv-capability-links data-ng-if="profileDetails" cv-permitted-options="permittedOptions"></cv-capability-links>
			<span>
			<a data-ng-if="rgCtrl.regionData.regionEntity.regionName && (rgCtrl.userCreatedRegion)" class="page-action-item" data-ng-click="rgCtrl.deleteRegion(rgCtrl.regionData.regionEntity.regionId,rgCtrl.regionData.regionEntity.regionName)"><cv:msg key="action.delete" bundle="regions" /></a>
			<a data-ng-if="rgCtrl.regionData.regionEntity.regionName && (rgCtrl.userCreatedRegion)" class="page-action-item" data-ng-click="rgCtrl.editRegionWindow()"><cv:msg key="label.addZone" bundle="regions" /></a>
		</span>
	</div>
</div>
 <cv-grid cv-grid-options="rgCtrl.regionGridOptions"></cv-grid>
	<div class="group grid-header-group">
	<!-- dropdown to select plans or clients -->
		<div class="grid-header-dropdown">
			<isteven-multi-select id="regionDetails_isteven-multi-select_#3872" input-model="rgCtrl.gridSelectionList" output-model="rgCtrl.selectedGrid" button-label="optionName" item-label="optionName" tick-property="selected" class="isteven-multi-select user-group-select plan-migration-select" helper-elements="none" selection-mode="single" on-item-click="rgCtrl.setGridOption()"> 
		    </isteven-multi-select>
		    <div class="group" data-ng-if="selectedGridData.length ==0">
				<h4 ><cv:msg key="info.noData" bundle="regions" /></h4>
			</div>
		</div>
		
    <cv-grid data-ng-if="rgCtrl.selectedGrid[0].id==0 && selectedGridData.length>0" cv-grid-options="rgCtrl.clientGridOptions"></cv-grid>
    <cv-grid data-ng-if="rgCtrl.selectedGrid[0].id==1 && selectedGridData.length>0" cv-grid-options="rgCtrl.planGridOptions"></cv-grid>
</div>
</div>
