<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
</script>
<cv:comp name="show.proxy">
	<cv-tile-component data-ac-id="label_proxy-servers" class="failedproxy" data-title='<cv:msg key="label.proxy" bundle="servers"/>' loader="proxyList" min-height="true" edit-text="reorderHelpText">
		<span class="server-message {{proxyMessage.type}}">{{proxyMessage.message}}</span>

		<span class="error server-message" data-ng-if="serverType && serverType === 'AMAZON' && proxyCheck.noVendorProxy && showNoAmazonProxySelected"><cv:msg key="error.noAmazonProxySelected" bundle="servers"></cv:msg></span>
		<div data-ng-if="proxyList.length" id="scroll-box" data-ng-class="{'limit-tile-component-height' : showMinHeight }" class="limit-tile-component-height">
			<ul class="list-style-secondary" data-dragula='"bag-two"' data-dragula-scope="$parent" data-dragula-model="proxyList">
				<li data-ng-repeat="proxy in proxyList" class="group" data-ng-class="{'draggable-proxy' : proxyReorderingEnabled}">
					<span class="pageDetailColumn full-width">
						<span data-ng-if="proxy.clientName" title="{{proxy.clientName}}">{{proxy.clientName}}</span>
						<span data-ng-if="proxy.clientGroupName">{{proxy.clientGroupName}}<span class="parenthetical-text"><cv:msg key="indicator.group" bundle="collections"/></span></span>
					</span>
				</li>

				<li data-ng-if="showAutoScaleOption  && virtualServerInfo">
				<cv-auto-scale-proxy-component
               		 server-id="autoScaleConfigurationServerId"
               		 virtual-server-info="virtualServerInfo"
                	 instance-id="instanceId"
               		 server-name="serverName"
               		 kubernetes-options="hideConfigOptions">
            	</cv-auto-scale-proxy-component></li>

			</ul>

			<ul class="list-style-secondary">
				<li class="group" data-ng-repeat="(key, proxyObj) in proxiesInfo" >
					<div data-ng-if="proxyObj.status === 'Running'" class="failedproxy server-message">
						{{key}}: <cv:msg key="label.proxyPushInstallRunning" bundle="servers"/>
					</div>
					<div data-ng-if="proxyObj.status === 'Failed'" class="failedproxy error server-message">
						{{key}}: <cv:msg key="label.proxyPushInstallFailed" bundle="servers"/><a title="{{proxyObj.jpr}}">{{proxyObj.errorCode}}</a>
						<span class="float-right resubmit"><a data-ng-click="resubmitPushInstall(key, key)"><cv:msg key="action.resubmit" bundle="servers" /></a></span>
						<span class="float-right"><a data-ng-click="deleteFailedProxy(key, key)"><cv:msg key="action.dismiss" bundle="servers" /></a></span>
					</div>
				</li>
				<li class="group" data-ng-if="resubmitted.show">
					<p class="error server-message">
						<cv:msg key="message.resubmitted" bundle="servers" />
					</p>
				</li>
			</ul>
		</div>
		<div data-ng-if="proxyList && !proxyList.length && !emptyProxyMessage" class="info-place-holder"><cv:msg key="label.no.proxy" bundle="servers"/></div>
		<div data-ng-if="proxyList && !proxyList.length && emptyProxyMessage" data-ng-bind="emptyProxyMessage" class="info-place-holder"></div>
		<div class="page-details-box-links">
			<a data-ng-show="proxyReorderingEnabled" href="" data-ng-click="resetOrder()"><cv:msg key="Cancel" bundle="messages" /></a>
			<a data-ng-show="proxyReorderingEnabled" href="" data-ng-click="setOrder()"><cv:msg key="Save" bundle="messages" /></a>
			<a data-ng-show="proxyList.length && proxyList.length > 1 && !proxyReorderingEnabled && !proxiesInfo.length && !resubmitted.show" href="" data-ng-click="activateReordering()"><cv:msg key="action.reorder" bundle="servers" /></a>
			<a data-ng-show="serverType &&serverType=='AMAZON'||serverType=='AZURE'||serverType=='AZURE_V2'||serverType=='AZURE_STACK'" href="" data-ng-click="showAddProxyDialog()"><cv:msg key="label.installProxy" bundle="serversJs" /></a>
			<%-- <a data-ng-show="serverType &&serverType=='AMAZON'" href="" data-ng-click="showAddProxyDialog()"><cv:msg key="label.installProxy" bundle="serversJs" /></a> --%>
			<a data-ng-show="serverType && (proxyList.length || subclientId) && !proxyReorderingEnabled" href="" data-ng-click="showEditProxy()"><cv:msg key="action.edit" bundle="collections" /></a>
		</div>
	</cv-tile-component>
</cv:comp>