<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="title.glusterHost" bundle="serversJs"/></h1>
	</div>
	<form name="osGlusterModalForm" data-ng-submit="osGlusterModalCtrl.save()">
		<div class="bootstrap-wrapper">
			<div class="form-group">
				<label class="col-xs-12 col-sm-4" for="hostName"><cv:msg key="label.hostNameOpenShift" bundle="serversJs"/></label>
				<div class="col-xs-12 col-sm-8">
					<input name="hostName" id="hostName" data-ng-model="osGlusterModalCtrl.modalInfo.hostName" type="text" required autofocus />
					<span class="help-block" data-ng-show="osGlusterModalCtrl.duplicateEntry">{{osGlusterModalCtrl.duplicateEntry}}</span>
				</div>
			</div>
			<div class="form-group">
				<div class="col-xs-12">
					<h4><cv:msg key="label.authentication" bundle="serversJs"/></h4>
				</div>
				<div class="col-xs-12">
					<div class="multiple-radio-group">
						<label>
							<input name="radio" value="{{osGlusterModalCtrl.glusterAuthTypes.PASSWORD}}" type="radio" data-ng-model="osGlusterModalCtrl.modalInfo.authType"/>
							<span class="block-indent"><cv:msg key="label.usernameAndPassword" bundle="serversJs"/></span>
						</label>
					</div>
					<div class="multiple-radio-group">
						<label>
							<input name="radio" value="{{osGlusterModalCtrl.glusterAuthTypes.KEY}}" type="radio" data-ng-model="osGlusterModalCtrl.modalInfo.authType" />
							<span class="block-indent"><cv:msg key="label.usernameKeyAndPassphrase" bundle="serversJs"/></span>
						</label>
					</div>
				</div>
			</div>
			<div data-ng-show="osGlusterModalCtrl.modalInfo.authType === osGlusterModalCtrl.glusterAuthTypes.PASSWORD">
				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="userName"><cv:msg key="label.userName" bundle="serversJs"/></label>
					<div class="col-xs-12 col-sm-8">
						<input data-ng-model="osGlusterModalCtrl.modalInfo.credentials.userName" name="userName" id="userName" type="text" 
							data-ng-required="osGlusterModalCtrl.modalInfo.authType === osGlusterModalCtrl.glusterAuthTypes.PASSWORD"/>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="password"><cv:msg key="label.password" bundle="serversJs"/></label>
					<div class="col-xs-12 col-sm-8">
						<input data-ng-model="osGlusterModalCtrl.modalInfo.credentials.password" name="password" id="password" type="password"
							data-ng-required="osGlusterModalCtrl.modalInfo.authType === osGlusterModalCtrl.glusterAuthTypes.PASSWORD"/>
					</div>
				</div>
			</div>
			<div data-ng-show="osGlusterModalCtrl.modalInfo.authType === osGlusterModalCtrl.glusterAuthTypes.KEY">
				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="userNameKey"><cv:msg key="label.userName" bundle="serversJs"/></label>
					<div class="col-xs-12 col-sm-8">
						<input data-ng-model="osGlusterModalCtrl.modalInfo.credentials.userName" name="userNameKey" id="userNameKey" type="text" 
							data-ng-required="osGlusterModalCtrl.modalInfo.authType === osGlusterModalCtrl.glusterAuthTypes.KEY"/>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="passPhrase"><cv:msg key="label.passPhrase" bundle="serversJs"/></label>
					<div class="col-xs-12 col-sm-8">
						<input data-ng-model="osGlusterModalCtrl.modalInfo.passPhrase" name="passPhrase" id="passPhrase" type="text" />
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="key"><cv:msg key="label.key" bundle="serversJs"/></label>
					<div class="col-xs-12 col-sm-8 margin-top-10">
						<cv-file-input file-input="osGlusterModalCtrl.file" on-change="osGlusterModalCtrl.readFile(event)" />
						<span class="help-block" data-ng-show="osGlusterModalCtrl.fileReadError">{{osGlusterModalCtrl.fileReadError}}</span>
					</div>
				</div>
			</div>
			<div class="button-container">
				<button id="openShiftGlusterModal_button_#6005" type="button" data-ng-click="osGlusterModalCtrl.cancel()" class="btn btn-default cvBusyOnAjax"> 
					<cv:msg key="Cancel" bundle="messages" />
				</button>
				<button id="openShiftGlusterModal_button_#8662" type="submit" class="btn btn-primary cvBusyOnAjax" 
				 data-ng-disabled="!osGlusterModalCtrl.modalInfo.hostName 
				 	|| !osGlusterModalCtrl.modalInfo.credentials.userName 
				 	|| (osGlusterModalCtrl.modalInfo.authType === osGlusterModalCtrl.glusterAuthTypes.PASSWORD && !osGlusterModalCtrl.modalInfo.credentials.password)">
					<cv:msg key="Save" bundle="messages" />
				</button>
			</div>
		</div>
	</form>
</div>