<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.editDefaultPlans" bundle="profiles"/></h1>
	</div>
</div>
<div class="setup-content">
	<span class="{{editPlanMessage.type}} serverMessage">{{editPlanMessage.message}}</span>
	<form  name="editPlanForm" novalidate cv-submit="saveDefaultPlan()" autocomplete="off">
		<div class='addServerModal' >
			<label for="serverDefault" class="select-label" data-ng-if="serverPlans.length > 0"><cv:msg key="label.serverPlan" bundle="profiles" />
				<select name="serverDefault" id="serverDefault" class='select plan' data-ng-options="plan.planSummary.plan.planName for plan in serverPlans | orderBy: 'plan.planName'" data-ng-model="model.defaultServer">
					<option value=""><cv:msg key="label.serverDefaultPlan" bundle="profiles" /></option>
				</select>
			</label>
			
			<label for="fsDefault" class="select-label" data-ng-if="fsPlans.length > 0"><cv:msg key="label.fsPlan" bundle="profiles" />
				<select name="fsDefault" class='select plan' data-ng-options="plan.planSummary.plan.planName for plan in fsPlans | orderBy: 'plan.planName'" data-ng-model="model.defaultFs">
					<option value=""><cv:msg key="label.fsDefaultPlan" bundle="profiles" /></option>
				</select>
			</label>
			
			<label for="dbDefault" class="select-label" data-ng-if="dbPlans.length > 0"><cv:msg key="label.dbPlan" bundle="profiles" />
				<select name="dbDefault" class='select plan' data-ng-options="plan.planSummary.plan.planName for plan in dbPlans | orderBy: 'plan.planName'" data-ng-model="model.defaultDb">
					<option value=""><cv:msg key="label.dbDefaultPlan" bundle="profiles" /></option>
				</select>
			</label>
			
			<label for="laptopDefault" class="select-label" data-ng-if="laptopPlans.length > 0"><cv:msg key="label.laptopPlan" bundle="profiles" />
				<select name="laptopDefault" class='select plan' data-ng-options="plan.planSummary.plan.planName for plan in laptopPlans | orderBy: 'plan.planName'" data-ng-model="model.defaultLaptop">
					<option value=""><cv:msg key="label.laptopDefaultPlan" bundle="profiles" /></option>
				</select>
			</label>
			
			<div data-ng-if="(showAlwaysActivateLaptop && model.defaultLaptop && model.defaultLaptop.planSummary.plan.planId !== -1)" class="form-group enable-extended-retention-area text-align-left padding-left-20">
		 		<toggle-control class="extended-retention-toggle alwaysActivateWithDefaultPlanToggle" status="alwaysActivateWithDefaultPlanToggle" data-ng-click="toggleActivateWithDefaultPlan()"></toggle-control>
				<label class="extended-retention-label"><cv-help-text help-label="label.alwaysActivateDefaultPlan" help-text="label.alwaysActivateDefaultPlan.helpText"/></label>
			</div>
		</div>
			
		<div class="button-container">
			  	<button id="mspDefaultPlans_button_#3289" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="subscriptions" /></button> 
			  	<button id="mspDefaultPlans_button_#0588" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="subscriptions" /></button> 
		</div>
	</form>
</div>
