<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.collections">
	<div >
		<div class="setup-title">
			<h1><cv:msg key="label.editEsxServer" bundle="collections" /></h1>
		</div>
		<div class="setup-content">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<form name="addCollectionForm" novalidate cv-submit="saveEsxServer()" autocomplete="off" class="add-collection-form">
				<cv-browse-collection-content
					selected-content='collectionInfo.selectedContent'
					server-id="replicationTargetClientId"
					initial-content-browse-view-path='\NONE:Hosts'	
					hide-grouping="true"
					single-selection-mode="true"
					selectable-types='SERVER'
					hide-search="true" >
				</cv-browse-collection-content>
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
				  		<button id="manageEsxServer_button_#0408" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
				  		<button id="manageEsxServer_button_#2276" type="submit" data-ng-disabled="!isContentSelected()" class="btn btn-primary cvBusyOnAjax" ><fmt:message key="OK" /></button> 
				  	</fmt:bundle>
				</div>
			</form>
		</div>
	</div>
</fmt:bundle>