	<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
	<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
	<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	</script>
	<fmt:bundle basename="localization.restore">
		<div class="setup-title" >
			<h1>
				<cv:msg key="pageHeader.liveMount" bundle="restore" />
				<!--<cv-help-component help-text="<cv:msg key="label.liveMountHelpText" bundle="restore"/>"></cv-help-component>-->
			</h1>
		</div>
		<span class="setup-content">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
		</span>
		<form name="liveMountForm" id="liveMountForm" novalidate class="form-horizontal bootstrap-wrapper" autocomplete="off" data-cv-submit="submitLiveMountJob()">
				<div class="panel-body">
                    <div class="form-group" data-ng-if="showTarget">
                            <label class="col-xs-12 col-md-5 col-lg-5" for="policyType">
								<cv:msg key="label.lifeCyclePolicy" bundle="dr" />
							</label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<select id="policyType" name="vmAllocPolicyName" data-ng-options="target.entity.vmAllocPolicyName  for target in liveMountReplicationTargets | orderBy: 'vmAllocPolicyName'" data-ng-model="selectedReplicationTargetDetails" required
									data-ng-change="replicationTargetChanged(selectedReplicationTargetDetails)"">
								</select>
								<span class="help-block" data-ng-show="cv.liveMountForm.needsAttention(liveMountForm.vmAllocPolicyName)"><cv:msg key="error.selectLifeCyclePolicy" bundle="dr"/></span>
							</div>
                    </div>
                    <div class="form-group" data-ng-if="!showTarget">
                            <label class="col-xs-12 col-md-5 col-lg-5" for="destinationHost">
								<cv:msg key="label.destinationHost" bundle="restore" />
							</label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<div class="input-group cursor-pointer">
									<input type="text" readonly required name="destinationHost" id="destinationHost" value="{{model.hostName}}" data-ng-required="!showTarget"
											data-ng-click="openSelectDestinationHostDialog(serverDetails)" placeholder='<cv:msg key="placeholder.selectDestinationHost" bundle="restoreJs" />' />
									<span class="input-group-btn">
										<button class="btn btn-default" type="button" data-ng-click="openSelectDestinationHostDialog(restoreData.subClientEntity)">
											<cv:msg key="label.browse" bundle="restore" />
										</button>
									</span>
								</div>
								<span class="help-block" data-ng-show="!model.hostName && cv.liveMountForm.needsAttention()">
									<cv:msg key="error.destinationServer" bundle="restore"/>
								</span>
							</div>
                    </div>
					<div class="form-group">
                            <label class="col-xs-12 col-md-5 col-lg-5" for="vmName">
								<cv:msg key="label.virtualMachineName" bundle="restore" />
							</label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<input type="text" id="vmName" name="vmName" data-ng-model="model.vmName" data-ng-required="true" data-ng-disabled="!isReplicationTargetDetailsLoaded"  data-ng-pattern="vmNamePattern" />
								<span class="help-block" data-ng-show="liveMountForm.vmName.$error && cv.liveMountForm.needsAttention(liveMountForm.vmName)"> <cv:msg key="error.virtualMachineName" bundle="restore"/></span>
								<span data-ng-if="showVMNamePattern" class="help-block" data-ng-show="liveMountForm.vmName.$error.pattern && cv.liveMountForm.needsAttention(liveMountForm.vmName)"> <cv:msg key="error.virtualMachineName.pattern" bundle="restore"/></span>
							</div>
                    </div>
					<div class="form-group" data-ng-if="!showTarget" >
                            <label class="col-xs-12 col-md-5 col-lg-5" for="expirationTimeInHours">
								<cv:msg key="label.expirationTimeInHours" bundle="restore" />
							</label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<input type="number" id="expirationTimeInHours" name="expirationTimeInHours" data-ng-model="model.expirationTimeInHours" class="expirationTimeInput" min="1"  max="24">
								<span class="help-block" data-ng-show="cv.liveMountForm.needsAttention(liveMountForm.expirationTimeInHours)"><cv:msg key="error.expirationTimeInHours" bundle="restore"/></span>
							</div>
                    </div>
                    <div class="form-group">
                            <label class="col-xs-12 col-md-5 col-lg-5" for="network">
								<cv:msg key="label.network" bundle="restore" />
							</label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<div>
									<isteven-multi-select data-ng-class="select" id="network" name="network"
										data-input-model="networkList"
										data-output-model="networkOpts"
										data-tick-property="checked"
										item-label="displayName"
										data-button-label="displayName"
										data-search-property="displayName"
										disabled="disabled"
										helper-elements="filter showSelected"
										class="isteven-multi-select user-group-select modal-right"
										on-close="function()"
										translation="localLang"
										data-ng-disabled="disabled"
										group-property="header"
										data-selection-mode="single"
										on-item-click="validateNetworkOpts()">
									<isteven-multi-select>
								</div>
								<div class="help-block" data-ng-if="!isDestinationNetworkSelected(networkOpts)"><cv:msg key="error.networkSettings.destination" bundle="restore"/></div>
							</div>
                    </div>
                    <div class="form-group" data-ng-if="copyDetails">
                            <label class="col-xs-12 col-md-5 col-lg-5" for="copyPrecedence">
								<cv:msg key="label.copyPrecedenceLM" bundle="restore" />
								<cv-help-component help-text="<cv:msg key="label.copyPrecedenceLMHelpText" bundle="restore"/>"></cv-help-component>
							</label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<select name="copyPredecence" id="copyPrecedence"
											data-ng-options="copy.copyPrecedence as copy.StoragePolicyCopy.copyName for copy in copyDetails | orderBy: 'copyPrecedence'"
											data-ng-model="model.copyDetails.copyPrecedence">
											<option value=""><cv:msg key="label.defaultCopy" bundle="browse"/></option>
								</select>
							</div>
                    </div>
				</div>

				<div class="button-container">

					<button id="liveMountRestoreWizard_button_#1349" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()">
						<cv:msg key="Cancel" bundle="messages" />
					</button>
					<button id="liveMountRestoreWizard_button_#1057" type="submit" class="btn btn-primary cvBusyOnAjax" >
						<span ><cv:msg key="Submit" bundle="messages" /></span>
					</button>

			    </div>
		</form>
	</fmt:bundle>
