    <%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
        <%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
        <%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
        <script nonce="${sessionScope.cspNonce}" >
        <cv:cvMessages bundle="localization.dr"></cv:cvMessages>
        <cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
        </script>
    <div data-ng-controller="backupValidationConfigController">
        <div>
	        <div class="setup-title">
	        	<h1 data-ng-if="inEditMode"><cv:msg key="label.editBackUpValidation" bundle="dr"/></h1>
	        	<h1 data-ng-if="!inEditMode"><cv:msg key="label.configureBackupValidation" bundle="dr"/></h1>
	        </div>
        </div>
        <div class="setup-content server-plan medium-width server-backup-plan">
		<form class="bootstrap-wrapper form-horizontal" name="backupValidationSettingsForm" novalidate data-cv-submit="onSave()" autocomplete="off">
			<div class="panel panel-default" data-ng-if="isAdminUser">
			<div class="panel-body no-padding">
			<div class="form-group padding-left-20">
				<label class="col-xs-12 col-md-8 col-lg-12" for="liveMountUsingSourceEsx">
					<span>
						<toggle-control id="liveMountUsingSourceEsx" status="enableSourceVMESXMount ? 'enabled-activity' : 'disabled-activity'" data-ng-click="toggleSourceEsxLiveMountOption()"></toggle-control>
					</span>
					<span class="padding-left-5"><cv:msg key="label.liveMountUsingSourceEsx" bundle="dr" /></span>
				</label>
				</div>
			</div>
			</div>
			<div class="panel panel-default"  data-ng-if="(!LCPolicySet || inEditMode) && !enableSourceVMESXMount">
			<div class="panel-body no-padding">
			<div class="form-group padding-left-20">
				<label class="col-xs-12 col-md-4 col-lg-4" for="lifeCyclePolicySelection"><cv:msg key="label.lifeCyclePolicy" bundle="dr" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<div class="input-group" id="lifeCyclePolicySelection">
						<isteven-multi-select id="lifeCyclePolicyModal_isteven-multi-select_#7626" name="avLifeCyclePolicies" input-model="istevenLFPolicies" output-model="selectedLifeCyclePolicy" 
							button-label="name" item-label="name" tick-property="ticked" disable-property="disabled"
							class="isteven-multi-select user-group-select" hide-search-button="true"
							search-limit="10" selection-mode="single" ng-required on-item-click="onLCPolicySelect(data)">
						</isteven-multi-select>
					<span data-ng-if="isAdminUser" class="input-group-btn padding-left-10"><a href="" data-ng-click="createRecoveryTarget()"><cv:msg key="label.createNew" bundle="replicationGroups" /></a></span>
					</div>
					<span class="help-block text-left" data-ng-if="(backupValidationSettingsForm.$submitted || backupValidationSettingsForm.avLifeCyclePolicies.$dirty) && !enableSourceVMEXMMount">
                		<span ng-if="validLifeCyclePolicySelected == false" ><cv:msg key="error.selectLifeCyclePolicy" bundle="dr" /></span>
                	</span>
				</div>
			</div>
			</div>
			</div>
			<div class="panel panel-default" data-ng-if="!enableSourceVMESXMount && (validLifeCyclePolicySelected || (LCPolicySet && inEditMode))">
			<div class="panel-body no-padding">
			<div class="form-group padding-left-20">
				<label class="col-xs-12 col-md-12 col-lg-12" for="runAsDevTestGroup">
				<span>
					<toggle-control id="runAsDevTestGroup" status="runAsDevTestGroup ? 'enabled-activity' : 'disabled-activity'" data-ng-click="toggleDevTestGroupSelection()"></toggle-control>
				</span>
				<span class="padding-left-5"><cv-help-text help-label="label.runAsDevTestGroup" help-text="label.runAsDevTestToolTip"></cv-help-text></span>
				</label>
			</div>
			</div>
			</div>
			<!-- Schedule-->
			<div class="panel panel-default">
			<div class="panel-body no-padding">
			<div class="form-group padding-left-20">
				<label class="col-xs-12 col-md-6 col-lg-6" for="backUpScheduleSelection">
					<span id="backUpScheduleSelection">
						<toggle-control id="toggleBackupValidationSchedule" status="scheduleToggleState ? 'enabled-activity' : 'disabled-activity'" data-ng-click="toggleSchedule()"></toggle-control>
					</span>
					<span class="padding-left-5"><cv:msg key="label.backupValidationSchedule" bundle="dr" /></span>
				</label>
				<label class="col-xs-12 col-md-6 col-lg-6 padding-top-5"  data-ng-show="scheduleToggleState">
					<a href="" data-ng-click="invokeSchedulingModel()">{{editedScheduleDisplayString}}</a>
				</label>
			</div>
			</div>
			</div>

			<!--thread count-->
			<div class="panel panel-default">
				<div class="panel-body no-padding">
				<div class="form-group padding-left-20">
				<label class="col-xs-12 col-md-5 col-lg-5" for="noOfThreads"><cv:msg
							key="label.backupValidationThreadCount" bundle="dr" /></label>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input type="number" class="temporary-enabled" name="noOfThreads"
							data-ng-model="validationJobThreadCount" min="1" max="16" required/>
					<span class="help-block text-left" data-ng-if="(backupValidationSettingsForm.$submitted || backupValidationSettingsForm.noOfThreads.$dirty) && backupValidationSettingsForm.noOfThreads.$invalid">
						<span><cv:msg key="error.backupValidationThreadCount" bundle="dr" /></span>
					</span>
				</div>
			</div>
			</div>
			</div>

			<!--Custom validation script windows-->
			<div class="panel panel-default">
				<div class="panel-body no-padding">
					<uib-accordion close-others="true">
						<cv-plain-accordion accordion-label="label.customApplication" collapsed="true">
							<div class="form-group padding-left-20" data-ng-if="!isCustomValidationAppSetToDelete">
								<label class="col-xs-4 col-md-4 col-lg-4" for="customApp"><cv:msg
										key="label.windowsGuest" bundle="dr" /></label>
								</label>
								<label class="col-xs-4 col-md-5 col-lg-5 crop no-padding" for="customApp" data-ng-if="isWindowsScriptAvailable">{{windowsCustomScript.scriptPath}}</label>
								</label>
								<label data-ng-if="!isWindowsScriptAvailable" class="col-xs-6 col-md-3 col-lg-3 no-padding">
									<a id="cv_windowsCustomScript_add" class="tabAction" href=""
											data-ng-click="openCustomScriptModel('WINDOWS')" ><cv:msg
													key="label.add" bundle="dr" /></a>
								</label>
								<label
									data-ng-if="isWindowsScriptAvailable"
									class=" col-xs-4 col-md-3 col-lg-3 cv-main-bar-dropdown-menu menu"
									uib-dropdown> <a
									class="uib-dropdown-toggle main-tab-menu-toggle"
									uib-dropdown-toggle> <svg xmlns="http://www.w3.org/2000/svg"
										viewBox="0 0 20 20" fill="currentColor" width="20" height="20">
										<path
											d="M10.1 0C4.6-.1.1 4.4 0 9.9s4.4 10 9.9 10.1 10-4.4 10.1-9.9v-.2C19.9 4.5 15.5.1 10.1 0zm0 18.9c-5 0-9-4-9-9s4-9 9-9 9 4 9 9-4 9-9 9z" />
										<path d="M6.1 8.8h2v2h-2zM9.1 8.8h2v2h-2zM12.1 8.8h2v2h-2z" /></svg>
								</a>
									<ul uib-dropdown-menu class="dropdown-menu cv-dropdown-style-2">
										<li id="cv_windowsCustomScript_edit" class="no-padding"><a class="tabAction" href=""
											data-ng-click="openCustomScriptModel('WINDOWS')"><cv:msg
													key="label.edit" bundle="dr" /></a></li>
										<li id="cv_windowsCustomScript_delete" class="no-padding"><a class="tabAction" href=""
											data-ng-click="deleteCustomValidationApp('WINDOWS')"><cv:msg
													key="label.delete" bundle="dr" /></a></li>
									</ul>
								</label>
							</div>
							<!--Custom validation script unix-->
							<div class="form-group padding-left-20">
								<label class="col-xs-12 col-md-4 col-lg-4" for="customApp"><cv:msg
										key="label.unixGuest" bundle="dr" /></label>
								</label>
								<label class="col-xs-6 col-md-5 col-lg-5 crop no-padding" for="customApp" data-ng-if="isUnixScriptAvailable">{{unixCustomScript.scriptPath}}
								</label>
								<label data-ng-if="!isUnixScriptAvailable" class="col-xs-6 col-md-3 col-lg-3 no-padding">
									<a id="cv_unixCustomScript_add" class="tabAction" href=""
											data-ng-click="openCustomScriptModel('UNIX')"><cv:msg
													key="label.add" bundle="dr" /></a>
								</label>
								<label
									data-ng-if="isUnixScriptAvailable"
									class="col-xs-6 col-md-3 col-lg-3 cv-main-bar-dropdown-menu menu"
									uib-dropdown> <a
									class="uib-dropdown-toggle main-tab-menu-toggle"
									uib-dropdown-toggle> <svg xmlns="http://www.w3.org/2000/svg"
										viewBox="0 0 20 20" fill="currentColor" width="20" height="20">
										<path
											d="M10.1 0C4.6-.1.1 4.4 0 9.9s4.4 10 9.9 10.1 10-4.4 10.1-9.9v-.2C19.9 4.5 15.5.1 10.1 0zm0 18.9c-5 0-9-4-9-9s4-9 9-9 9 4 9 9-4 9-9 9z" />
										<path d="M6.1 8.8h2v2h-2zM9.1 8.8h2v2h-2zM12.1 8.8h2v2h-2z" /></svg>
								</a>
									<ul uib-dropdown-menu class="dropdown-menu cv-dropdown-style-2">
										<li id="cv_unixCustomScript_edit" class="no-padding"><a class="tabAction" href=""
											data-ng-click="openCustomScriptModel('UNIX')"><cv:msg
													key="label.edit" bundle="dr" /></a></li>
										<li id="cv_unixCustomScript_delete" class="no-padding"><a class="tabAction" href=""
											data-ng-click="deleteCustomValidationApp('UNIX')"><cv:msg
													key="label.delete" bundle="dr" /></a></li>
									</ul>
								</label>
							</div>
							</cv-plain-accordion>
					</uib-accordion>
				</div>
			</div>

			<!--Guest credentials-->
			<cv-plain-accordion accordion-label="label.guestCredentials" collapsed="true">
				<div class="form-group padding-left-20">
					<h4 class="push-down margin-left-15">
						<cv-help-text help-label="label.guestCredentials" help-text="label.backupValidationGuestCredentialsToolTip"></cv-help-text>
					</h4>
					<div class="col-xs-12 col-md-12 col-lg-12">
						<cv-credential-manager model="guestCredentialsInput" form-name="backupValidationSettingsForm"  input-name="guestName" password-complexity="1" is-optional="true" show-credential="true" css-class="form-group row"  password-required-on-edit="true"></cv-credential-manager>
					</div>
				</div>
			</cv-plain-accordion>
			<!--Model actions-->
			<div class="modal-footer">
				<button id="lifeCyclePolicyModal_button_#8211" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" 
					data-ng-click="onCancelModal()">
					<cv:msg key="Cancel" bundle="messages" />
				</button>
				<button id="lifeCyclePolicyModal_button_#8340" type="submit" class="btn btn-primary cvBusyOnAjax"> 
					<cv:msg key="Save" bundle="messages" />
				</button>
			</div>
			
		</form>
        </div>
    </div>
