<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.usersJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.users">
	<div class='setup-title'>
		<h1><fmt:message key="pageHeader.importBulkUsers" /></h1>
	</div>
	<form cv-hide-api data-ng-init="bulkUserCtrl.init()" name="importBulkUserForm" novalidate
		data-cv-submit="bulkUserCtrl.saveUsers()" autocomplete="off"
		class="form-horizontal edit-users-grid-form">
		<div class="modal-body">
			<div class="text-center" data-ng-if="bulkUserCtrl.importMessage.addUserFailed"><label class="{{bulkUserCtrl.importMessage.type}}"><fmt:message key="error.createBulkUsersFailed" /></label></div>
			<div class="text-center no-padding"><span class="{{bulkUserCtrl.importMessage.type}}">{{bulkUserCtrl.importMessage.message}}</span></div>
			<div class="bootstrap-wrapper" data-ng-if="bulkUserCtrl.userType">
				<div class="form-group">
					<label class="col-xs-5"><fmt:message key="label.userType" /></label>
					<div class="col-xs-7">
						<select id="userType" name="userType"
							data-ng-model="bulkUserCtrl.userType"
							data-ng-change="bulkUserCtrl.userTypeChange()">
							<option value="local" selected="selected"><fmt:message key="label.localUser" /></option>
							<option value="external"><fmt:message key="label.externalUser" /></option>
						</select>
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-5"
						for="bulkImporterPath"><fmt:message
							key="label.uploadCsvFile" /></label>
					<div class="col-sm-7">
						<div class="input-group">
							<input class="hidden" type="file" id="bulkImporter"
								name="bulkImporter" maxlength="100" />
								
								<input
								placeholder="<fmt:message key="label.uploadCsvFile" />"
								type="url" readonly required id="bulkImporterPath"
								name="bulkImporterPath" maxlength="100" disabled /> <span
								class="input-group-btn">
								<button type="button" id="outputToLocalPathBtn"
									class="btn btn-default"
									data-ng-click="bulkUserCtrl.browseLocalPath('bulkImporter');">
									<cv:msg key="action.upload" bundle="users" />
								</button>
							</span>
						</div>
					</div>
				</div>
				<div class="form-group">
					<div class="col-md-offset-5 col-sm-offset-5 col-sm-7">
						<a class='subtext-unspaced medium-size override-options-tooltip pull-left'
					data-ng-class="tooltipClass" data-tooltip-placement="bottom"
					data-uib-tooltip-html='bulkUserCtrl.getCSVhelpTextHtml()'>
						<fmt:message key="label.csvHelpText" /></a>
						<a data-ng-click="bulkUserCtrl.downloadCSVsample()"
						class='subtext-unspaced medium-size override-options-tooltip pull-right'
						data-ng-class="tooltipClass" data-tooltip-placement="bottom">
							<fmt:message key="label.downloadCsvSample" />
						</a>
					</div>
				</div>
				<div data-ng-if="bulkUserCtrl.fileUploaded">
						<div data-ng-if="!localUser" class="form-group">
							<label class="col-sm-5" for="externalProvider"><cv:msg
									key="label.externalProvider" bundle="users" /></label>
							<div class="col-sm-7">
								<select required name="externalProvider"
									data-ng-model="bulkUserCtrl.externalProvider"
									data-ng-change="bulkUserCtrl.updateExternalProvider(bulkUserCtrl.externalProvider)"
									data-ng-options="domain as domain.shortName.domainName for domain in bulkUserCtrl.nameServerData">
									<option disabled value="" selected="selected">{{bulkUserCtrl.noExternalProvider ? '<cv:msg
											key="label.noExternalProvider" bundle="users" />' : '<cv:msg
											key="placeholder.selectAnExternalProvider" bundle="users" />'}}</option>
								</select>
								<div class="help-block"
								data-ng-show="cv.importBulkUserForm.needsAttention(importBulkUserForm.externalProvider)"><i class="ion-alert-circled"></i><fmt:message
										key="error.externalProvider" /></div>
							</div>
						</div>
						<div class="form-group"
							data-ng-disabled="!bulkUserCtrl.externalProvider && !localUser">
							<label class="col-sm-5" for="userGroupType"><fmt:message key="label.userGroup" />
								<span class="optional-text"><cv:msg key="label.optional"
										bundle="subscriptions" /></span></label>
							<div data-ng-disabled="!bulkUserCtrl.groups" class="col-sm-7">
								<isteven-multi-select input-model="bulkUserCtrl.groups"
									button-label="name" item-label="name" tick-property="ticked"
									class="isteven-multi-select user-group-select"
									id="userGroupType" name="userGroupType"
									helper-elements="all none reset filter" max-labels="1"
									translation="bulkUserCtrl.localLang"
									disable-property="disabled"
									on-item-click="bulkUserCtrl.validateGroupSelection()"
									on-select-none="bulkUserCtrl.validateGroupSelection()"
									on-select-all="bulkUserCtrl.validateGroupSelection()"
									on-reset="bulkUserCtrl.validateGroupSelection()">
								</isteven-multi-select>
							</div>
						</div>
					<div data-ng-if="localUser" class="form-group">
						<div class="col-xs-12">
							<input type="checkbox" id="generatePassword"
							data-ng-model="bulkUserCtrl.systemGeneratePassword"
							data-ng-change="bulkUserCtrl.manageSystemGeneratePassword()" />
							<label for="generatePassword">
								<cv:msg key="label.useSystemGeneratePassword" bundle="users" /> <cv-help-component
								help-text="<cv:msg key="label.systemGeneratePasswordHelpText" bundle="users"/>"></cv-help-component>
							</label>
						</div>
					</div>
				</div>
			</div>
			<div data-ng-if="bulkUserCtrl.fileUploaded">
				<cv-grid cv-grid-options="gridOptions"></cv-grid>
			</div>
		</div>
		<div class="modal-footer">
			<button id="importBulkUsersModal_button_#9719" type='button' class='btn btn-default cvBusyOnAjax' 
				data-ng-click='bulkUserCtrl.cancel()'>
				<fmt:message key="action.cancel" />
			</button>
			<button id="importBulkUsersModal_button_#2816" data-ng-disabled="!bulkUserCtrl.fileUploaded" type='submit' 
				class='btn btn-primary cvBusyOnAjax'>
				<fmt:message key="action.save" />
			</button>
		</div>
	</form>
</fmt:bundle>
<!-- needed for encoding the password -->
<script src="${pageContext.request.contextPath}/common/js/encoder.js"></script>