<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div id="replicationTargetZone" ng-if="gcZoneCtrl.isReplicationTarget">
	<div class="form-group">
			<label class="col-xs-12 col-md-5 col-lg-5" for="destinationHost">
				<span><cv:msg key="label.primaryZone" bundle="restore" /></span>
			</label>
			<div class="col-xs-12 col-md-7 col-lg-7" data-ng-disabled="gcZoneCtrl.editMode">
				<div class="input-group">
					<input type="text" readonly
							name="destinationHost" id="destinationHost"
							value="{{gcZoneCtrl.getCurrentHostDisplayName()}}"
							/>
					<span class="input-group-btn">
						<button id="vmFullRestoreGoogleCloudZoneBrowseButton" type="button" 
							data-ng-click="gcZoneCtrl.openSelectDestinationHostDialog()"
							class="btn btn-default browse-btn">
							<cv:msg key="label.browse" bundle="restore"/>
						</button>
					</span>
				</div>
				<span class="help-block" data-ng-if="gcZoneCtrl.destinationHostError"> <cv:msg key="error.destinationZone" bundle="restore"/>
				</span>
			</div>
	</div>
	<div class="form-group" data-ng-if="gcZoneCtrl.restoreData.vmOptions.multipleZones">
		<div>
			<label class="col-xs-12 col-md-5 col-lg-5" for="secondaryZone">
				<cv-help-text help-label="label.secondaryZone" help-text="info.secondaryZone"></cv-help-text>
			</label>
			<div class="col-xs-12 col-md-7 col-lg-7" data-ng-disabled="gcZoneCtrl.editMode">
				<isteven-multi-select
					input-model="gcZoneCtrl.restoreData.vmOptions.destinationHost.secondaryZones"
					output-model="gcZoneCtrl.restoreData.vmOptions.destinationHost.secondaryZone"
					button-label="name"
					item-label="name"
					tick-property="selected"
					selection-mode="single"
					class="isteven-multi-select"
					id="secondaryZone"
					name="secondaryZone"
					directive-id="secondaryZone"
					search-property="name"
					max-height="400px"
					on-open="gcZoneCtrl.onSecondaryZoneOpen()"
					on-item-click="gcZoneCtrl.onSecondaryZoneSelect()"
					group-property="header"
					helper-elements="filter"
					translation="gcZoneCtrl.localLangSecondaryZone">
				</isteven-multi-select>
			</div>
		</div>
	</div>
</div>
<div id="restoreZone" ng-if="!gcZoneCtrl.isReplicationTarget">
	<div class="form-group">
		<div class="col-xs-12">
			<div class="input-group">
				<label for="destinationHost">
					<span data-ng-bind="::gcZoneCtrl.primaryZoneLabel"/>
					<input type="text" readonly
						name="destinationHost" id="destinationHost"
						value="{{gcZoneCtrl.getCurrentHostDisplayName()}}"
						data-ng-required="!gcZoneCtrl.isAll()" />
					<span class="help-block"
						data-ng-show="!gcZoneCtrl.isAll() && gcZoneCtrl.restoreData.vmOptions.destinationHost === null && submitController.getAttempted()">
						<cv:msg key="error.destinationServer" bundle="restore"/>
					</span>
				</label> 
				<span class="input-group-btn">
					<button id="vmFullRestoreGoogleCloudZoneBrowseButton" type="button" 
						data-ng-click="gcZoneCtrl.openSelectDestinationHostDialog()"
						class="btn btn-default browse-btn">
						<cv:msg key="label.browse" bundle="restore"/>
					</button>
				</span>
			</div>
		</div>
	</div>
	<div class="form-group" data-ng-if="gcZoneCtrl.restoreData.vmOptions.multipleZones">
		<div class="col-xs-12">
			<label for="secondaryZone">
				<cv-help-text data-ng-if="gcZoneCtrl.isAll()" help-label="label.secondaryZone" help-text="info.secondaryZone"></cv-help-text>
				<span data-ng-if="!gcZoneCtrl.isAll()"><cv:msg key="label.secondaryZone" bundle="restore" /></span>
				<isteven-multi-select
					input-model="gcZoneCtrl.restoreData.vmOptions.destinationHost.secondaryZones"
					output-model="gcZoneCtrl.restoreData.vmOptions.destinationHost.secondaryZone"
					button-label="name"
					item-label="name"
					tick-property="selected"
					selection-mode="single"
					class="isteven-multi-select"
					id="secondaryZone"
					name="secondaryZone"
					directive-id="secondaryZone"
					search-property="name"
					max-height="400px"
					on-open="gcZoneCtrl.onSecondaryZoneOpen()"
					on-item-click="gcZoneCtrl.onSecondaryZoneSelect()"
					group-property="header"
					helper-elements="filter"
					translation="gcZoneCtrl.localLangSecondaryZone">
				</isteven-multi-select>	
			</label>
		</div>
	</div>	
</div>
