<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<fmt:bundle basename="localization.restore">
<div data-ng-if="select2Override">
		<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/select2Overrides.css?${applicationScope.BUILD_TS}" />
	</div>
<div class="setup-title">
	<h1><fmt:message key="label.restoreOpts" /></h1>
</div>
<div class="setup-content" >

		<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
		<span data-ng-if="isLoading" class="{{serverMessage.type}} serverMessage">{{loadingMessage}}</span>
		
	<form data-ng-if="isRestoreValid && !isLoading" name="restoreForm" class="{{type.vmType}} restore-form" novalidate data-cv-submit="doRestore()" autocomplete="off">
		
		<div data-ng-if="showTab() && canBrowse">
			<cv-tabset-component control="tabControls" element='cvtile' on-select='changeTab'> 
				<cv-tab tabname="{{getVMLabel('label.myVM')}}" tabId='thisVM'></cv-tab> 
				<cv-tab tabname="{{getVMLabel('label.otherVm')}}" tabId='otherVM'></cv-tab> 
			</cv-tabset-component>
		</div>
		<!-- Destination drop down for virtual machine and file system -->
		<div data-ng-show="selectMachine">
			<label >{{::getVMLabel('status.vms')}}
				<div class="company-multi-select" data-ng-if="!select2Override">
						<isteven-multi-select id="fileLevelRestore_isteven-multi-select_#8958" 
								input-model="machineList"
								output-model="selectedMachine"
								button-label="name"
								item-label="name"
								tick-property="selected"
								selection-mode="single"
								directive-id="vm"
								class="isteven-multi-select user-group-select single-select"
								helper-elements="filter"
								search-limit="10"
								max-labels="1"
								translation="localLang"
								 search-property="name"
								on-item-click="changeMachine(selectedMachine[0])">
						</isteven-multi-select>
				</div>
				<input data-ng-show="select2Override" type="text" id="select2DestinationList" class="select2Overrides"/>
			</label>
		</div>

		<div data-ng-if="!selectMachine && canBrowse">
				<label >{{::getVMLabel('label.destinationServer')}}
					<div class="company-multi-select">
							<isteven-multi-select id="fileLevelRestore_isteven-multi-select_#6185" 
									input-model="servers"
									output-model="selectedDestinationServer"
									button-label="name"
									item-label="name"
									tick-property="selected"
									selection-mode="single"
									directive-id="destinationServer"
									class="isteven-multi-select user-group-select single-select"
									helper-elements="filter"
									search-limit="10"
									max-labels="1"
									translation="localLang"
									on-item-click="changeServerList(selectedDestinationServer[0])">
							</isteven-multi-select>
					</div>
				</label>
				<div  style="clear:both;"></div>
			</div>
					<div data-ng-if="vmRestore && showProxy">
			<label ><fmt:message key="label.proxy" ></fmt:message>
				<div class="company-multi-select">
						<isteven-multi-select id="fileLevelRestore_isteven-multi-select_#4866" 
								input-model="restoreData.globalOptions.proxyList"
								output-model="selectedProxy"
								button-label="clientName"
								item-label="clientName"
								tick-property="selected"
								selection-mode="single"
								directive-id="proxy"
								class="isteven-multi-select user-group-select single-select"
								helper-elements="filter"
								search-limit="10"
								max-labels="1"
								translation="localLang"
								on-item-click="changeProxy(selectedProxy[0])">
						</isteven-multi-select>
				</div>
			</label>
		</div>
		<div class="global-options" data-ng-if="false">
			<label  ><fmt:message key="label.fsServer" ></fmt:message>
				<div class="company-multi-select">
						<isteven-multi-select id="fileLevelRestore_isteven-multi-select_#2344" 
								input-model="restoreData.globalOptions.destinationFSClientList"
								output-model="selectedDestinationFsServer"
								button-label="clientName"
								item-label="clientName"
								tick-property="selected"
								directive-id="destinationFS"
								selection-mode="single"
								class="isteven-multi-select user-group-select single-select"
								helper-elements="filter"
								search-limit="10"
								max-labels="1"
								translation="localLang"
								on-item-click="destinationFsServerChanged(selectedDestinationFsServer[0])">
						</isteven-multi-select>
				</div>
			</label>
		</div>
		<span data-ng-if="!selectMachine && canBrowse">
			<cv-browse-collection-content
				selected-content='selectedMachine'
				server-id="serverId"
				selectable-types="VM"
				single-selection-mode="true"
				hide-grouping="true"
				server-name="{{serverDetails.serverName}}"
				username="{{serverDetails.username}}"
				password="{{serverDetails.password}}"
				initial-content-browse-view-path ="{{initialContentBrowseViewPath}}"
				select-content-warning-fn='cv.restoreForm.getAttempted()'
				server-type="{{vendor}}"
				ctrl="ctrl"
				filter-type="{{filterType}}"
				filter-rule="{{filterRule}}"
				hide-search="{{hideContentSearch}}"
				creating-application-group={{appGroupCreationEligible}}>
			</cv-browse-collection-content>
		</span>
		<div class="global-options remove-border-padding">
			<div data-ng-if="vendor && vendor!='MICROSOFT' && vendor !== 'AMAZON' && vmRestore">
				<label><h4 class="text-left">{{::getVMLabel('label.vmLogin')}}</h4></label>
				<label>
					<fmt:message key="label.username" />
					<input type="text" name="vmLoginName" autocomplete="new-password" ng-model="destination.vmLoginName" required/>
					<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.vmLoginName)"><fmt:message key="error.userRequired" /></span>
				</label>
				<label>
					<fmt:message key="label.password" />
					<input type="password" name="vmPassword" autocomplete="new-password" ng-model="destination.password" />
				</label>
			</div>
			<div  ng-if="!vmRestore">
			<label  data-ng-click="restoreData.globalOptions.impersonateUser = !restoreData.globalOptions.impersonateUser">
				<toggle-control id="fileLevelRestore_toggle_impersonateUser" status="restoreData.globalOptions.impersonateUser"></toggle-control>
				<span><cv:msg key="label.impersonateUser" bundle="restore" /></span>
			</label>
			</div>
			<div class="credentials" ng-if="!vmRestore && restoreData.globalOptions.impersonateUser"><!-- LOCALIZATION  -->
		
				
				<label>
					<fmt:message key="label.username" />
					<input type="text" name="fsLoginName" autocomplete="new-password" ng-model="destination.vmLoginName" required="restoreData.globalOptions.impersonateUser"/>
					<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.fsLoginName)"><fmt:message key="error.userRequired" /></span>
				
				</label>
				<label>
					<fmt:message key="label.password" />
					<input type="password" name="fsPassword" autocomplete="new-password" ng-model="destination.password" />
				</label>
			</div>
			<label for="restorePath" data-ng-class="{'restorePathLabel': showBrowse()}">
				<fmt:message key="label.destinationPath" />
				<button id="fileLevelRestore_button_#2919" data-ng-if="showBrowse()" type="button" ng-click="browse(destination.vmLoginName)" class="btn btn-default browse-btn ng-scope" ng-disabled="vmRestore && (restoreForm.vmLoginName.$error.required || restoreForm.password.$error.required || isVMBrowseDisabled())"> 
					<fmt:message key="label.browse" />
					<!--	<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.vmPassword)">Select a VM and enter username and password to browse</span> -->
				</button>
				<input type="text" name="restorePath" id="restorePath" ng-model="destination.selectedPath" required>
				<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.restorePath)"><fmt:message key="error.pathRequired" /></span>
				<span class="help-block margin-bottom-20" data-ng-show="!toolStatus">
					<cv:msg key="error.toolsNotAvailable" bundle="restore" />
				</span> 
			</label>
			<label data-ng-click="restoreData.globalOptions.overwrite = !restoreData.globalOptions.overwrite">
				<toggle-control id="fileLevelRestore_toggle_unconditionallyOverwrite" status="restoreData.globalOptions.overwrite"></toggle-control>
				<span><cv:msg key="warning.overwrite" bundle="restore" /></span>
			</label>
			
			<div  data-ng-if="!vmRestore" class="bootstrap-wrapper padding-bottom-35">
				<div class="form-group">
					<label class="col-xs-12 col-sm-4 margin-left-5"><cv:msg key="label.restore" bundle="restore" /></label>
					<div class="col-xs-12 col-sm-7 margin-left-25">
						<div class="multiple-checkbox-group">
							<input name="acls" id="acls" type="checkbox" ng-model="aclsTypeCBModel.acl" data-ng-change="restoreACLsTypeClick()" ng-true-value="'{{RESTORE_ACLS_TYPE.ACL_ONLY}}'" />
							<label for="acls"><cv:msg key="label.acls" bundle="restore"/></label>
						</div>
						<div class="multiple-checkbox-group">
							<input name="data" id="data" type="checkbox" ng-model="aclsTypeCBModel.data" data-ng-change="restoreACLsTypeClick()" ng-true-value="'{{RESTORE_ACLS_TYPE.DATA_ONLY}}'" />
							<label for="data"><cv:msg key="label.data" bundle="restore"/></label>
						</div>
						<span class="help-block" ng-show="invalidRestoreACLsTypeSelection">
                        	<cv:msg key="error.restoreTypeRequired" bundle="restore"/>
						</span>
					</div>
				</div>
			</div>
			<label>
				<div class="global-options remove-border-padding padding-top-10">
					<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
				</div>
			</label>
		</div>
		<div class="button-container">
			<fmt:bundle basename="localization.messages">
				<button id="fileLevelRestore_button_#5722" type="button" class="btn btn-default setup-btn--hidden" ng-click="cancel()"> 
					<fmt:message key="Cancel" />
				</button>
				<button id="fileLevelRestore_button_#8047" class="btn cvBusyOnAjax btn-primary" type="submit" ng-disabled="!isPathSelected()"> 
					<fmt:message key="Submit" />
				</button>
			</fmt:bundle>
		</div>
	</form>
</div>
</fmt:bundle>
