<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.blrJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
<cv:cvEnum name="BlockReplication.BlockReplicationStatus"></cv:cvEnum>
<cv:cvEnum name="BlockReplication.BlockReplicationBootStatus"></cv:cvEnum>
<cv:cvEnum name="BlockReplication.BLRRecoveryType"></cv:cvEnum>
<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
		<h1><cv:msg key="action.extendExpiryTime" bundle="blrJs"/></h1>
</div>
<fmt:bundle basename="localization.blrJs">
<div class="setup-content bootstrap-wrapper">
	<div class="help-block" ng-show="errMsg">{{errMsg}}</div>
	<form name="extendExpiryForm" novalidate autocomplete="off" id="extendExpiryForm" data-cv-submit="saveData(this)" class="form-horizontal">
	<div class="panel">
		<div class="panel-body">
			<div class="form-group">
				<label class="col-xs-12 col-md-5 col-lg-5" for="days"><cv:msg key="action.extendExpiryTime" bundle="blrJs"/></label>
				<div class="col-xs-12 col-md-3 col-lg-3">
					<input type="number" data-ng-model="days" min="0" max="30"  data-ng-change="updateNewExpiryTime()" data-ng-maxlength="2"  id="days" name="days" required ng-class="{'has-error': cv.extendExpiryForm.needsAttention(extendExpiryForm.days)}"/> <label class="inline-label" for="days"><cv:msg key="label.days" bundle="blrJs"/></label>
				</div>
				<div class="col-xs-12 col-md-4 col-lg-4">
					<input type="number" data-ng-model="hours" min="0" max="23" data-ng-change="updateNewExpiryTime()"  data-ng-maxlength="2"  id="hours" name="hours" required ng-class="{'has-error': cv.extendExpiryForm.needsAttention(extendExpiryForm.hours)}" /> <label class="inline-label" for="hours"><cv:msg key="label.hours" bundle="blrJs"/></label>
				</div>
				<label class="col-xs-12 col-md-5 col-lg-5">
					<cv:msg key="label.currentExpiryTime" bundle="blrJs"/>
				</label>
				<label class="col-xs-12 col-md-7 col-lg-7">
					<span>{{bootInfo.currentExpiryTime*1000|date:'medium'}}</span>
				</label>
				<label class="col-xs-12 col-md-5 col-lg-5">
					<cv:msg key="label.newExpiryTime" bundle="blrJs"/>
				</label>
				<label class="col-xs-12 col-md-7 col-lg-7">
					<span>{{bootInfo.newExpiryTime*1000|date:'medium'}}</span>
				</label>
				<div class="col-md-7 col-lg-7 col-md-offset-5 col-lg-offset-5">
					<span class="help-block" ng-show="extendExpiryForm.days.$invalid && cv.extendExpiryForm.needsAttention(extendExpiryForm.days)">
								<fmt:message key="error.expiryDays.invalid" />
					</span>
					<span class="help-block" ng-show="extendExpiryForm.hours.$invalid && cv.extendExpiryForm.needsAttention(extendExpiryForm.hours)">
								<fmt:message key="error.expiryHours.invalid" />
					</span>
				</div>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<fmt:bundle basename="localization.messages">
		<button id="extendExpiryModal_button_#4806" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button> 
		<button id="extendExpiryModal_button_#2593"  type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" /></button> 
		</fmt:bundle>
	</div>
	</form>
</div>
</fmt:bundle>