<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:setBundle basename="localization.messages" var="common" />
<fmt:bundle basename="localization.storage">
	<div ng-controller="addStorageController">
		<div class="modal-header">
			<h1>
				<fmt:message key="label.editStorage" />
			</h1>
		</div>
		<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
		<form name="editLbraryForm" class="simple-form" novalidate
			cv-submit="renameLibrary()" autocomplete="off">
			<div class="setup-content">
				<p class="info"></p>
				<label for="libraryName"><fmt:message key="Storage Name" />
					<input
					ng-class="{'has-error': cv.editLbraryForm.needsAttention(editLbraryForm.libraryName)}"
					type="text" name="libraryName" ng-model="libraryInfo.label"
					required maxlength="128" /> <span class="help-block"
					ng-show="editLbraryForm.libraryName.$error.required && cv.editLbraryForm.needsAttention(editLbraryForm.libraryName)"><fmt:message
							key="error.libraryName.required" /></span> <span class="help-block"
					ng-show="editLbraryForm.libraryName.$error.maxlength && cv.editLbraryForm.needsAttention(editLbraryForm.libraryName)"><fmt:message
							key="error.libraryName.length" /></span> </label>
			</div>
			<div class="modal-footer">
				<button id="editStorageModal_button_#4438" type="button" class="btn btn-default" ng-click="cancel()"> 
					<fmt:message key="Cancel" bundle="${common}" />
				</button>
				<button id="editStorageModal_button_#1208" type="button" class="btn btn-default" 
					ng-click="deleteLibrary()">
					<fmt:message key="Delete" bundle="${common}" />
				</button>
				<button id="editStorageModal_button_#4880" class="btn btn-primary" type="submit"> 
					<fmt:message key="OK" bundle="${common}" />
				</button>
			</div>
		</form>
	</div>
</fmt:bundle>