<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.collections">
	<div>
		<div class="setup-title">
			<h1><fmt:message key="dialogTitle.editStorage" /></h1>
		</div>
		<div class="setup-content">
			<!-- <p class="setupInfo"><fmt:message key="label.setupInfo" /></p> -->
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<form name="addCollectionForm" novalidate cv-submit="saveStorageForCollection()" autocomplete="off" class="add-collection-form">
					
				<div class="global-options remove-border-padding storage-global-options">
					<label for="storage" class="select-label"><fmt:message key="label.storage" />
						<select id="storage" name="storage" data-ng-model="sp.libId"
								data-ng-options="lib.id as lib.label for lib in libraries | orderBy: 'label'" required
								data-ng-class="{'has-error': cv.addCollectionForm.needsAttention(addCollectionForm.storage)}">
							<option value=""><fmt:message key="placeholder.storage" /></option>
						</select>
						<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.storage)"><fmt:message key="error.storage" /></span>
					</label>
					
					<label for="infinite" class="infinite-retention-label"><fmt:message key="label.retentionDays" /></label>
					<div class="storage-elements-wrapper less-margin">
						<label for="infinite" class="storage-label"><fmt:message key="label.infinite" /></label>
						<div class="storage-inline-wrapper">
							<input type="checkbox" data-ng-model="infiniteCheck" id="infinite" name="infinite">
							<label for="infinite" class="storage-checkbox-label"></label>
						</div>
					</div>
				
					<span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.retention)"><fmt:message key="error.retentionPeriod" /></span>				
					<span data-ng-show="!infiniteCheck"><input id="retention" name="retention" type="number" min="1" max="9999" data-ng-model="sp.ret" class="storage-retention-input less-margin" /><cv:msg key="label.days" bundle="collectionsJs"/></span>
					
				</div>
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
				  		<button id="editStorage_button_#1345" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
				  		<button id="editStorage_button_#7936" type="submit" class="btn btn-primary cvBusyOnAjax" ><fmt:message key="OK" /></button> 
				  	</fmt:bundle>
				</div>
			</form>
		</div>
	</div>
</fmt:bundle>