	<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
	<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
	<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	</script>
	<fmt:bundle basename="localization.servers">
		<div class="setup-title">
			<h1 data-ng-if="!AmazonHostedCS" data-ng-bind="titleHeader"></h1>
			<h1 data-ng-if="AmazonHostedCS"><fmt:message key="action.editAccountDetails" /></h1>
		</div>
		<div class="setup-content bootstrap-wrapper">
			<%-- <span class="setupInfo"><fmt:message key="label.editInfo" /></span> --%>
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<form name="editServerForm" novalidate data-cv-submit="editServer(serverId)" autocomplete="off" class="form-horizontal">
				<div class="global-options remove-border-padding">
					<div data-ng-if="!serverType || (serverType && ((serverType=='VMW') || (serverType=='VCLOUD')))">
						<div data-ng-if="!model.enableAdminAccount">
							 <label for="vsHostName"><fmt:message key="label.hostName" />
								<input type="text" name="vsHostName" id="vsHostName" data-ng-model="model.vsHostName" required
									data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.vsHostName)}"/>
								<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsHostName)"><fmt:message key="error.hostName" /></span>
							</label>
						</div>
						<!-- <br> -->
						<label for="vsOldUserName"><fmt:message key="label.curr.userName" />
							<input type="text" name="vsOldUserName" id="vsOldUserName" data-ng-model="model.vsOldUserName" ng-readOnly="true"/>
						</label>
						<label for="vsUserName"><fmt:message key="label.new.userName" />
							<input type="text" name="vsUserName" id="vsUserName" data-ng-model="model.vsUserName" required
								data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.vsUserName)}"/>
							<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsUserName)"><fmt:message key="error.userName" /></span>
						</label>
						<label for="vsCurrPassword"><fmt:message key="label.currPassword" />
							<input type="password" name="vsCurrPassword" id="vsCurrPassword" data-ng-model="model.vsCurrPassword"  required
								data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.vsCurrPassword)}" />
							<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsCurrPassword)"><fmt:message key="error.currPassword" /></span>
						</label>
						<label for="vsPassword"><fmt:message key="label.newPassword" />
							<input type="password" name="vsPassword" id="vsPassword" data-ng-model="model.vsPassword"
								data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.vsPassword)}" />
							<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsPassword)"><fmt:message key="error.newPassword" /></span>
						</label>
						<label for="confirmServerPassword"><fmt:message key="label.confirmNewPassword" />
							<input type="password"  name="confirmServerPassword" id="confirmServerPassword" data-ng-model="model.confirmPassword" data-cv-equals="{{model.vsPassword}}"
								data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.confirmServerPassword)}" />
							<!--
								The warning message logic for the confirm pw field below is as follows:
								If the field is blank AND the user has interacted with the field, show a required-field message
								If the field is not blank AND the field does not match the pw field AND the user has interacted with the field, show a does-not-match message
							-->
							<span class="help-block" data-ng-show="editServerForm.confirmServerPassword.$error.required && cv.editServerForm.needsAttention(editServerForm.confirmServerPassword)"><fmt:message key="error.confirmNewPassword" /></span>
							<span class="help-block"
								data-ng-show="!editServerForm.confirmServerPassword.$error.required && editServerForm.confirmServerPassword.$error.cvEquals && cv.editServerForm.needsAttention(editServerForm.confirmServerPassword)"><fmt:message key="error.mismatchedPassword" /></span>
						</label>
					</div>
					<!-- Edit server credentials for other vendors except VmWare and Microsoft-->
					<div data-ng-if="serverType">
						<%-- <label for="vsServerName"><cv:msg key="label.instanceName" bundle="servers"></cv:msg>
								<input type="text" name="vsServerName" id="vsServerName" data-ng-model="model.vsServerName" required
									data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.vsServerName)}"/>
								<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsServerName)"><fmt:message key="error.instanceName" /></span>
						</label> --%>
                   <!-- For OpenStack -->
                  <!--Can make hostname common accross all vendors-->
                   <div data-ng-if="(serverType=='OPENSTACK'||serverType=='MICROSOFT' || serverType=='NUTANIX' || serverType=='ORACLE_VM' ||serverType=='REDHAT')">
                    <label for="vsHostName">{{hostNameText}}
							<input type="text" name="vsHostName" id="vsHostName" data-ng-model="model.vsInfo.hostName" required
								data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.vsHostName)}"/>
							<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsHostName)">{{hostNameTextError}}</span>
					</label>
					<label for="vsUserName"><fmt:message key="label.userName" />
							<input type="text" name="vsUserName" id="vsUserName" data-ng-model="model.vsInfo.vcPassword.userName" required
								data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.vsUserName)}"/>
							<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsUserName)"><fmt:message key="error.userName" /></span>
					</label>
                    <div data-ng-if="(serverType=='OPENSTACK')">
						<!-- Openstack Domain  -->
						<label for="domainName" ><fmt:message key="label.openstackDomain" />(optional)
							<input type="text" name="domainName" data-ng-model="model.vsInfo.vcPassword.domainName"  />
						</label>
					</div>
                   </div>
                   <div data-ng-if="(serverType=='ORACLE_CLOUD')">
                    <label for="vsHostName">{{hostNameText}}
							<input type="text" name="vsHostName" id="vsHostName" data-ng-model="model.vsInfo.hostName" required
								data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.vsHostName)}"/>
							<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsHostName)">{{hostNameTextError}}</span>
					</label>
					<label for="vsUserName">{{userNameText}}
							<input type="text" name="vsUserName" id="vsUserName" data-ng-model="model.vsInfo.oracleCloud.credentials.userName" required
								data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.vsUserName)}"/>
							<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsUserName)"><!--<fmt:message key="error.userName" />-->{{userNameTextError}}</span>
					</label>
                   </div>
                <!--  For Azure (fields for  RM deployments) -->
                   <div data-ng-if="(serverType=='AZURE_V2' || serverType=='AZURE_STACK')">
					   <!-- For Azure RM we have addition field MSI ,based on which we show /hide fields.If MSI is selected just show Subscription Id -->
					<label data-ng-if="serverType=='AZURE_V2' "  class="cv-inline-checkbox">
					<input name="msiId" id="msiId" type="checkbox" data-ng-model="model.msiId" />
					<label for="msiId" class="cv-checkbox-label"><fmt:message key="label.managedSvcIdentity" /></label>
				   </label>
                    <label data-ng-if="(serverType =='AZURE_STACK')" for="authType" class="select-label add-server"><fmt:message key="label.authType" />
						<select name="authType" data-ng-options="auth as auth.name for auth in model.azureAuthTypes track by auth.value " data-ng-model="model.authType" required
							data-ng-change="changeAuthType()" >
						</select>
					</label>
					<label for="resourceMgrUrl" data-ng-if="serverType==='AZURE_STACK' "><fmt:message key="label.resourceMgrUrl" />
							<input type="text" name="resourceMgrUrl" data-ng-model="model.vsInfo.azureResourceManager.serverName" required/>
							<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.resourceMgrUrl)"><fmt:message key="error.resourceMgrUrl" /></span>
					</label>
					<label for="subscriptionId" ><fmt:message key="label.subscriptionId" />
							<input type="text" name="subscriptionId" data-ng-model="model.vsInfo.azureResourceManager.subscriptionId" required/>
							<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.subscriptionId)"><fmt:message key="error.subscriptionId" /></span>
					</label>
					<label for="tenantId"  data-ng-if="isMSIDUnselected() || isAzureAD()"><fmt:message key="label.tenantId" />
							<input type="text" name="tenantId" data-ng-model="model.vsInfo.azureResourceManager.tenantId" required/>
							<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.tenantId)"><fmt:message key="error.tenantId" /></span>
					</label>
					<label for="applicationId"  data-ng-if="isMSIDUnselected() || serverType=='AZURE_STACK'"><fmt:message key="label.applicationId" />
							<input type="text" name="applicationId" data-ng-model="model.vsInfo.azureResourceManager.credentials.userName" required/>
							<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.applicationId)"><fmt:message key="error.applicationId" /></span>
					</label>
					<!--  End Azure Rm -->
					</div>
					<!-- Field for Azure Classic -->
					<label for="subscriptionId" data-ng-if="serverType=='AZURE'"><fmt:message key="label.subscriptionId" />
							<input type="text" name="subscriptionId" data-ng-model="model.vsInfo.azure.credentials.userName" required/>
							<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.subscriptionId)"><fmt:message key="error.subscriptionId" /></span>
					</label>
					<!-- End Azure Classic -->
					<!-- Field for Amazon -->
                    <div class="global-options remove-border-padding restore-form" data-ng-if="serverType==='AMAZON'">
                    	<label for="regionEndPoints">
                           	<cv-help-text help-label="<cv:msg key="label.regionEndPoints" bundle="servers"/>"
								help-text="'<cv:msg key='info.regionEndPointsHelpText' bundle='servers'/>'"></cv-help-text>
							<input type="text" name="regionEndPoints" id="regionEndPoints" data-ng-model="model.regionName"/>
						</label>


							<label class="inline-label less-width"><cv:msg key="label.authentication" bundle="settings"/></label>
							<label class="inline-label" for="authentication">
								<input type="radio" data-ng-model="model.vsAuthenticationType" value="IAMRole" name="authenticationType"  data-ng-change="changeAuthenticationTypeForAmazon()">
								<span class="restore-settings-right-padding"><cv:msg key="label.IAMRole" bundle="servers"/></span>

								<input type="radio" data-ng-model="model.vsAuthenticationType" value="AccessAndSecretKey" name="authenticationType"  data-ng-change="changeAuthenticationTypeForAmazon()">
								<span class="restore-settings-right-padding"><cv:msg key="label.AccessSecretKey" bundle="servers"/></span>

								<input type="radio" data-ng-model="model.vsAuthenticationType" value="STSRole" name="authenticationType"  data-ng-change="changeAuthenticationTypeForAmazon()">
								<span class="restore-settings-right-padding"><cv:msg key="label.STSRole" bundle="servers"/></span>
							</label>
		                    <label for="vsAccessKey" data-ng-if="serverType=='AMAZON'" data-ng-hide="model.vsAuthenticationType==='IAMRole' || model.vsAuthenticationType==='STSRole'"><cv:msg key="label.accessKey" bundle="servers"/>
								<input type="text" name="vsAccessKey" data-ng-model="model.vsInfo.amazonInstanceInfo.accessKey" data-ng-required="model.vsAuthenticationType==='AccessAndSecretKey'"
									data-ng-disabled="model.vsAuthenticationType==='IAMRole' || model.vsAuthenticationType==='STSRole'"/>
								<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsAccessKey) || showError"><cv:msg key="error.accessKey" bundle="servers"/></span>
							</label>

							<label for="vsPassword" data-ng-if="serverType==='AMAZON'" data-ng-hide="model.vsAuthenticationType==='IAMRole' || model.vsAuthenticationType==='STSRole'">
							    <span>{{vsPasswordText}}</span>
								<input type="password" name="vsPassword" data-ng-model="model.vsPassword"  data-ng-required="model.vsAuthenticationType==='AccessAndSecretKey'"
									autoCompleteType="disable" autocomplete="off" data-ng-disabled="model.vsAuthenticationType==='IAMRole' || model.vsAuthenticationType==='STSRole'"/>
								<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsPassword) || showError">
								     <span>{{vsPasswordTextError}}</span>
							     </span>
							</label>

							<label for="vsSTSRole" data-ng-if="serverType=='AMAZON'" data-ng-hide="model.vsAuthenticationType==='IAMRole' || model.vsAuthenticationType==='AccessAndSecretKey'"><cv:msg key="label.roleArn" bundle="servers"/>
								<input type="text" name="vsAccessKey" data-ng-model="model.vsInfo.amazonInstanceInfo.accessKey" data-ng-required="model.vsAuthenticationType==='STSRole'"
									data-ng-disabled="model.vsAuthenticationType==='IAMRole' || model.vsAuthenticationType==='AccessAndSecretKey'"/>
								<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsAccessKey) || showError"><cv:msg key="error.roleArn" bundle="servers"/></span>
							</label>

						<!-- AWS Admin cross account -->
						<div>
						<label data-ng-click="toggleAmazonAdminAccount(disableAmazonAdminAccount || model.vsAuthenticationType==='IAMRole')" class="margin-top-15">
							<toggle-control
									disabled="disableAmazonAdminAccount || model.vsAuthenticationType==='IAMRole'"
									status="model.enableAdminAccount ? 'enabled-activity' : 'disabled-activity'">
							</toggle-control>&nbsp;
							<span><cv:msg key="label.enableAWSAdminAccount" bundle="servers" /></span>
						</label>
						<label data-ng-hide="!model.enableAdminAccount"><cv:msg key="label.account" bundle="servers"></cv:msg>
							<div class="company-multi-select">
								<isteven-multi-select id="editServerCredentials_isteven-multi-select_#7736"
									input-model="model.awsInstances"
									output-model="model.adminInstance"
									button-label="displayName"
									item-label="displayName"
									tick-property="selected"
									selection-mode="single"
									class="isteven-multi-select user-group-select single-select"
									helper-elements="filter"
									search-limit="10"
									max-labels="1"
									translation="localLang">
								</isteven-multi-select>
							</div>
						</label>
						</div>
						<!-- proxy selection in case user tries to remove admin instance association -->
						<div data-ng-show="showProxySelection()">
							<label>
								<cv:msg key="label.proxy" bundle="servers"/>
								<div class="company-multi-select">
									<cv-select-proxy model="model" ctrl="ctrl" selection="multi" id="proxy1"></cv-select-proxy>
								</div>
								<span class="help-block" data-ng-show="showProxyError">
									<cv:msg key="error.proxy" bundle="servers"/>
								</span>
							</label>
						</div>
					</div>
					<!-- End Amazon -->
					<!-- For Oracle Cloud Infrastructure-->
					<div data-ng-if="serverType === 'ORACLE_CLOUD_INFRASTRUCTURE'">
						<label for="tenancyOcid"><fmt:message key="label.tenancyOcid" />
								<input type="text" name="tenancyOcid" id="tenancyOcid" data-ng-model="model.vsInfo.oracleCloudInfrastructure.tenancyOCId" required />
							    <span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.tenancyOcid)"><fmt:message key="error.tenancyOcid" /></span>
						</label>
						<label for="userOcid"><fmt:message key="label.userOcid" />
								<input type="text" name="userOcid" id="userOcid" data-ng-model="model.vsInfo.oracleCloudInfrastructure.userOCId" required />
								<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.userOcid)"><fmt:message key="error.userOcid" /></span>
						</label>
						<label for="fingerPrint"><fmt:message key="label.fingerPrint" />
								<input type="text" name="fingerPrint" id="fingerPrint" data-ng-model="model.vsInfo.oracleCloudInfrastructure.fingerPrint" required />
							    <span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.fingerPrint)"><fmt:message key="error.fingerPrint" /></span>
						</label>
						<label for="privateKeyFileName"><fmt:message key="label.privateKeyFileName"  />
								<cv-help-text help-label="label.privateKeyFileName" help-text="label.privateKeyFileNameHelpText" />
								<input type="text" name="privateKeyFileName" id="privateKeyFileName" data-ng-model="model.vsInfo.oracleCloudInfrastructure.privateKeyFileName" data-ng-pattern="privateKeyFileNamePattern" placeholder="<fmt:message key="placeholder.privateKeyFileName" />" required/>
								<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.privateKeyFileName)"><fmt:message key="error.privateKeyFileName" /></span>
						</label>
						<label for="privateKeysPassword" ><fmt:message key="label.privateKeysPassword" />
								<cv-help-text help-label="label.privateKeysPassword" help-text="label.privateKeyFilePasswordHelpText" />
								<span class="optional-text"><cv:msg key="label.optional" bundle="restore"/></span>

								<input type="password" name="privateKeysPassword" id="privateKeysPassword" data-ng-model="model.vsPassword">
						</label>
						<label for="regionName"><fmt:message key="label.homeRegionName"  />
							<span uib-dropdown class="uib-dropdown select-label" on-toggle="toggled(open)" style="position: initial;" >
						    	<span class="uib-dropdown-toggle" uib-dropdown-toggle>
						      		<input style="cursor: pointer;" title="" type="text" id="regionName" name="regionName" data-ng-model="model.vsInfo.oracleCloudInfrastructure.regionName" data-ng-change="updateRegionName(null)" autocomplete="off" required/>
						     	</span>
						    	<ul uib-dropdown-menu class="dropdown-menu dropdown-regionlist-minwidth" >
						     		<li data-ng-repeat="region in ociRegionList" data-ng-click="updateRegionName(region)"><a title="{{region.name}}" href="javascript:void(0);">{{region.name}}</a></li>
						      	</ul>
							</span>
							<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.regionName)"><fmt:message key="error.homeRegionName" /></span>
						</label>
					</div>
					<!--End Oralce Cloud Infrastructure-->
					<!-- For Google Cloud -->
					<div data-ng-if="serverType === 'GOOGLE_CLOUD'">
						<div>
							<label for="vsHostName"><cv:msg key="label.clientName" bundle='servers'/>
								<input type="text" id="vsHostName" name="vsHostName" data-ng-model="model.vsInfo.hostName" required
								data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.vsHostName)}"/>
								<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsHostName)"><cv:msg key="error.hostName" bundle='servers'/></span>
							</label>
						</div>
						<div>
							<label for="serviceAccountID"><cv:msg key="label.serviceAccountId" bundle='servers'/>
								<input type="text" id="serviceAccountID" name="serviceAccountID" data-ng-model="model.vsInfo.googleCloud.serviceAccountId" placeholder="user@project.iam.gserviceaccount.com" required
								data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.serviceAccountId)}"/>
							<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.serviceAccountID)"><cv:msg key="error.serviceAccountId" bundle='servers'/></span>
							</label>
						</div>
						<div>
							<label class="padding-left-0 col-xs-12 col-md-4 col-lg-4" for="keyType"><cv:msg  key="label.keyType" bundle='servers'/></label>
							<div class="text-align-left">
								<div class="multiple-radio-group display-inline">
									<label class="display-inline margin-0" for="keyTypeJSON"><input type="radio" data-ng-model="keyType" id="keyTypeJSON" value="JSON" name="keyType" data-ng-change="clearGCPCredentials()" />
									<span class="block-indent"><cv:msg key="label.json" bundle='servers'/></span></label>
								</div>
								<div class="multiple-radio-group display-inline">
									<label class="display-inline" for="keyTypeP12"><input type="radio" data-ng-model="keyType" id="keyTypeP12" value="P12" name="keyType" data-ng-change="clearGCPCredentials()" />
									<span class="block-indent"><cv:msg key="label.p12" bundle='servers'/></span></label>
								</div>
							</div>
						</div>
						<div data-ng-if="keyType == 'P12'">
							<label class="padding-left-0 col-xs-12" for="p12KeyFileName"><cv:msg key="label.p12keyFileName" bundle='servers'/>
								<input type="text" id="p12KeyFileName" name="p12KeyFileName" data-ng-model="model.vsInfo.googleCloud.credentials.userName" placeholder="private-key-file.p12" required
								data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.p12keyFileName)}" data-ng-blur="p12KeyFileNameValidation()"/>
								<span class="help-block padding-left-15" data-ng-show="cv.editServerForm.needsAttention(editServerForm.p12KeyFileName) || showp12KeyError">{{p12KeyError}}</span>
							</label>
						</div>
						<div data-ng-if="keyType == 'JSON'">
							<label class="padding-left-0 col-xs-12" for="jsonFilePath"><cv:msg key="label.jsonFilePath" bundle='servers'/>
								<span class="btn btn-default btn-file"> 
									<span class="btn-text sshKeyFileName" data-ng-bind="fileName"></span>
									<cv-file-input file-input="file" on-change="fileUpload(file)"></cv-file-input>
								</span>
								<span class="help-block padding-left-15" data-ng-show="showjsonKeyError" data-ng-bind="jsonKeyError"></span>
							</label>							
						</div>
						<div data-ng-if="keyType == 'P12'">
							<label class="padding-left-0 col-xs-12" for="privateKeysPassword"><cv:msg key="label.privateKeysPassword" bundle='servers'/>
								<input type="password" id="privateKeysPassword" name="privateKeysPassword" data-ng-model="model.vsPassword" required
								data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.privateKeysPassword)}"/>
								<span class="help-block padding-left-15" data-ng-show="cv.editServerForm.needsAttention(editServerForm.privateKeysPassword)"><span>{{vsPasswordTextError}}</span></span>
							</label>
						</div>
					</div>
					<!-- End Google Cloud -->
					<!-- Field for Alibaba Cloud -->
                    <label for="vsAccessKey" data-ng-if="serverType=='ALIBABA_CLOUD'"><fmt:message key="label.accessKey"/>
						<input type="text" name="vsAccessKey" data-ng-model="model.vsInfo.aliBabaCloud.accessKey" required />
						<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsAccessKey) || showError"><fmt:message key="error.accessKey" /></span>
					</label>
					<!-- End Alibaba Cloud -->
					<label for="vsPassword" data-ng-if="((serverType!='VMW' && serverType!='VCLOUD') && serverType!='ORACLE_CLOUD_INFRASTRUCTURE' && serverType !='GOOGLE_CLOUD' && serverType!=='AMAZON' && !(serverType =='AZURE_V2' && model.msiId) && serverType!=='REDHAT_OPENSHIFT' && !showFileBrowse)">
					    <span>{{vsPasswordText}}</span>
						<input type="password" name="vsPassword" data-ng-model="model.vsPassword"  required autoCompleteType="disable" autocomplete="off"/>
						<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsPassword) || showError">
						     <span>{{vsPasswordTextError}}</span>
					     </span>
					</label>

					<div>
					<label data-ng-if="showFileBrowse" for="vsPassword">
						<cv:msg key="label.configFile" bundle="kubernetes"></cv:msg>
								<span class="btn btn-default btn-file ">
							<span class="btn-text sshKeyFileName" data-ng-bind="fileName"></span>
							<cv-file-input file-input="file" on-change="fileUpload(file)"></cv-file-input>
						</span>
						<span class="help-block" data-ng-if="showConfigError" data-ng-bind="configAuthenticationErr"></span>
					</label>
					</div>
					</div>
					<!-- Red Hat Open Shift -->
					<div data-ng-if="serverType === 'REDHAT_OPENSHIFT'" id="redHatOpenShift">
						<label for="vsHostName">
							<cv:msg key="label.masterNodenameRedHatOpenshift" bundle="serversJs"/>
							<input type="text" name="vsHostName" id="vsHostName"
								data-ng-model="model.vsInfo.hostName" required
								data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.vsHostName)}"/>
							<span class="help-block"
								data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsHostName)">
								{{hostNameTextError}}
							</span>
						</label>
						<div id="authentication">
							<div id="authTypes">
								<div class="form-group text-left margin-left-10">
									<div class="col-xs-12">
	                                    <div class="multiple-radio-group">
	                                        <label for="userNameRadio">
	                                        	<input id="userNameRadio" name="radio" value="{{model.vsInfo.redHatOpenShiftCopy.authTypes.UserName}}" type="radio" data-ng-model="model.vsAuthenticationType" />
												<span class="block-indent"><cv:msg key="label.userNamePassword" bundle="serversJs"/></span>
	                                        </label>
	                                    </div>
	                                    <div class="multiple-radio-group">
	                                        <label for="serviceNameRadio">
	                                        	<input id="serviceNameRadio" name="radio" value="{{model.vsInfo.redHatOpenShiftCopy.authTypes.ServiceName}}" type="radio" data-ng-model="model.vsAuthenticationType"/>
												<span class="block-indent"><cv:msg key="label.serviceNameToken" bundle="serversJs"/></span>
											</label>
	                                    </div>
	                                </div>
	                            </div>
	                        </div>
							<div data-ng-show="model.vsAuthenticationType === model.vsInfo.redHatOpenShiftCopy.authTypes.UserName">
								<label for="vsUserName"><fmt:message key="label.userName" />
									<input type="text" name="vsUserName" id="vsUserName"
										data-ng-model="model.vsInfo.redHatOpenShiftCopy.credentials.userName"
										data-ng-class="{'has-error': cv.editServerForm.needsAttention(editServerForm.vsUserName)}"
										data-ng-required="model.vsAuthenticationType === model.vsInfo.redHatOpenShiftCopy.authTypes.UserName"/>
									<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsUserName)">
										<fmt:message key="error.userName" />
									</span>
								</label>
								<label for="vsPassword">
								    <span><fmt:message key="label.password" /></span>
									<input type="password" name="vsPassword" id="vsPassword"
									data-ng-model="model.vsInfo.redHatOpenShiftCopy.credentials.password" autoCompleteType="disable" autocomplete="off"
									data-ng-required="model.vsAuthenticationType === model.vsInfo.redHatOpenShiftCopy.authTypes.UserName"/>
									<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.vsPassword)">
									     <span><fmt:message key="error.password" /></span>
								     </span>
								</label>
							</div>
							<div data-ng-show="model.vsAuthenticationType === model.vsInfo.redHatOpenShiftCopy.authTypes.ServiceName">
								<label for="serviceName">
									<cv:msg key="label.serviceName" bundle="serversJs"/>
									<input type="text" name="serviceName" id="serviceName"
										data-ng-model="model.vsInfo.redHatOpenShiftCopy.serviceName"
										data-ng-required="model.vsAuthenticationType === model.vsInfo.redHatOpenShiftCopy.authTypes.ServiceName"
										autoCompleteType="disable" />
									<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.serviceName)">
										<cv:msg key="error.specifyServiceName" bundle="serversJs" />
									</span>
								</label>
								<label for="serviceToken">
									<cv:msg key="label.serviceToken" bundle="serversJs"/>
									<input type="text" name="serviceToken" id="serviceToken"
										data-ng-model="model.vsInfo.redHatOpenShiftCopy.serviceToken.value"
										data-ng-required="model.vsAuthenticationType === model.vsInfo.redHatOpenShiftCopy.authTypes.ServiceName"
										autoCompleteType="disable"
										data-ng-click="model.vsInfo.redHatOpenShiftCopy.serviceToken.show()"/>
									<span class="help-block" data-ng-show="cv.editServerForm.needsAttention(editServerForm.serviceToken)">
										<cv:msg key="error.specifyServicToken" bundle="serversJs" />
									</span>
								</label>
							</div>
						</div>
						<div id="redHatGlusterGrid">
							<div id="redHatGlusterHeader">
								<label for="openShiftGlusterAdd">
									<cv:msg key="title.glusterHost" bundle="serversJs" />
									<span class="float-right">
										<a href="" id="openShiftGlusterAdd" name="openShiftGlusterAdd" data-ng-click="showOpenShiftGlusterModal(model.vsInfo.redHatOpenShiftCopy.glusterHostCredentials)">
											<cv:msg key="label.add" bundle="restore" />
										</a>
									</span>
									<span class="help-block" data-ng-show="cv.editServerForm.getAttempted() && model.vsInfo.redHatOpenShiftCopy.glusterHostCredentials.length == 0">
										<cv:msg key="error.gluster.add" bundle="serversJs"/>
									</span>
								</label>
							</div>
							<div id="redHatGlusterContents">
								<div class="filters-list-wrapper padding-left-0">
									<ul data-ng-repeat="gluster in model.vsInfo.redHatOpenShiftCopy.glusterHostCredentials | orderBy track by $index">
										<li title="{{gluster.credentials.userName}}@{{gluster.hostName}}">
											<label>
												<a data-ng-click="showOpenShiftGlusterModal(model.vsInfo.redHatOpenShiftCopy.glusterHostCredentials, gluster)">
													{{gluster.credentials.userName}}@{{gluster.hostName}}
												</a>
												<span class="delete-row">
													<a data-ng-click="deleteOpenShiftGlusterRow(gluster)"
													title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{gluster.credentials.userName}}@{{gluster.hostName}}">&times;</a>
												</span>
											</label>
										</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
					<!-- Red Hat Open Shift Ends -->
				</div>
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
						<button id="editServerCredentials_button_#6698" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><fmt:message key="Cancel" /></button>
						<button id="editServerCredentials_button_#2874" type="submit" class="btn btn-primary cvBusyOnAjax" ><fmt:message key="Save" /></button>
					</fmt:bundle>
				</div>
			</form>
		</div>
	</fmt:bundle>
