<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.editOperators" bundle="subscriptions"/></h1>
	</div>
</div>
<div class="setup-content remove-top-padding user-edit-content security-modal">
	<span class="{{editOperatorMessage.type}} serverMessage">{{editOperatorMessage.message}}</span>
	<form  name="editOperatorForm" novalidate cv-submit="saveOperatorForCompany()" autocomplete="off" class="edit-users-grid-form">
		<div id="subclient-content-tab">
			<div  class="add-users group extra-top-padding">
			<div class="user-suggestion-single-select-wrapper">
			<input id="userList" name="userList" data-ng-model="userOrGroupInfo.user.userOrGroupName" data-ng-change="nameAndRoleSelected()" class="add-user-type" >
			</div>
			<div class="select-label user">
				<isteven-multi-select 
					input-model="roles" 
					button-label="roleName" 
					output-model="userOrGroupInfo.role"
					id="adduserId" 
					item-label="roleName" 
					search-limit="10" 
					search-property="roleName" 
					selection-mode="single"
					tick-property="selected" 
					class="isteven-multi-select add-user-type"
					on-item-click="clearErrorMessage()">
				</isteven-multi-select>
			</div>
			<button id="editOperatorsForCompany_button_#6988" data-ng-click="addNewUserGroup()" data-ng-disabled="!nameAndRoleSelected()" class="btn btn-primary"><cv:msg key="Add" bundle="messages" /></button> 
			</div>
			<span data-ng-if='operatorsList.length==0'>
				<p class="empty-message info-place-holder horz-center extra-top-padding"><cv:msg key="label.noOperatorsAssigned" bundle="subscriptions" /></p>
			</span>
			<div  class="peopleInfos ownerInfo modal-version">
				<div class="users-list limit-modal-height">
					<ul>
						<li class="users-list__user group" data-ng-repeat="operator in operatorsList track by $index" >
							<span class="{{operator.cssName}}">
								<label data-id="{{operator.userOrGroupId}}" class="ellipsis-parent ellipsis-content user" data-ng-bind="operator.userOrGroupName" title="{{operator.userOrGroupName}}"></label>
								<label data-id="{{operator.roleId}}" class="ellipsis-parent ellipsis-content role" data-ng-bind="operator.roleName" title="{{operator.roleName}}"></label>
								<span class="delete-row"> <a href="" data-ng-click="removeUserAndRole(operator)" title="Delete {{operator.userOrGroupName}}">&times;</a></span>
							</span>
						</li>
					</ul>
				</div>
			</div>
		</div>
		<div class="button-container">
		  		<button id="editOperatorsForCompany_button_#3338" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="subscriptions" /></button> 
		  		<button id="editOperatorsForCompany_button_#6118" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="subscriptions" /></button> 
		</div>
	</form>
</div>
