<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.httpProxy" bundle="navJs"/></h1>
	</div>
</div>
<div class="bootstrap-wrapper form-horizontal" >
	<span class="serverMessage">{{message}}</span>
	<div class="text-center" data-ng-show="!pageLoaded"><img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif"></div>
	<form  name="clientGroupHttpProxyForm" novalidate cv-submit="saveHttpProxySettings()" autocomplete="off" data-ng-show="pageLoaded" cv-hide-api>
		<div class="panel">
			<div class="panel-body">
				<div class="form-group">
					<label for="proxyServer" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.proxyServer" bundle="settings"/></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input type="text" name="proxyServer" id="proxyServer" data-ng-model="proxyInfo.server" data-ng-required="true"/>
					</div>
					<div class="col-md-7 col-lg-7 col-md-offset-5 col-lg-offset-5">
						<span class="help-block" data-ng-show="cv.clientGroupHttpProxyForm.needsAttention(clientGroupHttpProxyForm.proxyServer)"><cv:msg key="error.proxyServer" bundle="settings"/></span>
					</div>
				</div>
				<div class="form-group">
					<label for="proxyPort" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.proxyPort"  bundle="settings"/></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input type="number" name="proxyPort" id="proxyPort" data-ng-model="proxyInfo.port" max="61000" min="1" data-ng-required="true"/>
					</div>
					<div class="col-md-7 col-lg-7 col-md-offset-5 col-lg-offset-5">
						<span class="help-block" data-ng-show="cv.clientGroupHttpProxyForm.needsAttention(clientGroupHttpProxyForm.proxyPort)"><cv:msg key="error.proxyPort" bundle="settings"/></span>
					</div>
				</div>
				<!-- Authentication -->
                <div class="form-group padding-top-10">
					<label class="col-xs-12 col-md-5 col-lg-5" for="use-authentication"><cv:msg key="label.useAuthentication"  bundle="settings"/></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<toggle-control id="use-authentication" title="<cv:msg key="label.useAuthentication"  bundle="settings"/>" data-ng-click="toggleAuthentication()" status="proxyInfo.useAuthentication ? 'enabled-activity' : 'disabled-activity'"></toggle-control>
					</div>
				</div>
               	<div class="form-group padding-top-5" data-ng-show="proxyInfo.useAuthentication">
                   	<label for="credential" class="col-xs-12 col-md-5 col-lg-5"> <cv:msg key="label.credentialName" bundle="storage"/></label>
                       <div class="col-xs-12 col-md-7 col-lg-7">
                        <select-with-create-button
                            select-id="credential"
                            select-name="credential"
                            key-label="credentialName"
                            key-id="credentialId"
                            create-button-disabled="false"
                            option-list="savedCredentials"
                            selected-option="proxyInfo.selectedCredential"
                            on-click-create-button="openCreateCredentialModal"
                            on-change-option="onChangeCredential"
                            has-error="cv.clientGroupHttpProxyForm.needsAttention(clientGroupHttpProxyForm.credential)"
                            class="no-float-auto tile-large-width"
                            placeholder='<cv:msg key="placeholder.credential" bundle="storage"/>'>
                         </select-with-create-button>
                        </div>
						<div class="col-md-7 col-lg-7 col-md-offset-5 col-lg-offset-5">
                        	<span class="help-block" data-ng-show="credentialNotSelectedError">
                            	<cv:msg key="error.credential.required" bundle="storage"/>
                        	</span>
                    	</div>
               	</div>
               	<div class="form-group  padding-top-10">
					<label for="useForNetworkRoutes" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.useForNetworkRoutes"  bundle="settings"/></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<toggle-control id="useForNetworkRoutes" title="<cv:msg key="label.useForNetworkRoutes"  bundle="settings"/>" data-ng-click="toggleNetworkRoutes()" status="proxyInfo.useForNetworkRoutes ? 'enabled-activity' : 'disabled-activity'"></toggle-control>
					</div>

				</div>
				<div class="form-group  padding-top-10">
					<label class="col-xs-12 col-md-5 col-lg-5"  for="proxyBypassList">
						<cv-help-text help-label="label.proxyBypassList" help-text="helpText.proxyBypassList" bundle="settings"></cv-help-text>
						<span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						 <div class="input-group">
							<input data-ng-model="domainName" ng-keypress="add(domainName, $event)" type="text" placeholder="https://www.example.com">
							<span  class="input-group-btn"><button id="clientGroupEditHttpProxyAddDomain" type="button" class="btn btn-primary" ng-click="add(domainName)" ><cv:msg key="Add" bundle="messages"/></button></span>
						</div>
						<span class="help-block" data-ng-show="!validDomain">
                         	<cv:msg key="error.proxyBypassList" bundle="settings"/>
                        </span>
					</div>
					<div class="col-xs-12 margin-top-20">
						<ul class="list-style__row group operation-rule-height-limit margin-0 padding-left-10 " data-ng-show="domainList.length>0">
							<li class="users-list__user " data-ng-repeat="domain in domainList" >
								<span >
									<label title="{{domain}}" ><span>{{domain}}</span></label>
									<span title="<cv:msg key="label.remove" bundle="settings"/> {{domain}}" class="delete-row margin-top-5" ng-click="deleteDomain(domain)">&times;</span>
								 </span>
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
		<div class="button-container">
			  	<button id="clientGroupEditHttpProxyCancel" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="settings" /></button>
			  	<button id="clientGroupEditHttpProxySubmit" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="settings" /></button>
		</div>
	</form>
</div>
