<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script type="text/ng-template"  id="tree_item_renderer.html">
		<div data-ng-class="{'selected': item.selectedState==='selected', 'partial': item.selectedState==='partial'}" >
			<span title="{{item.displayName}}"><span class="vsaIconLOADING {{item.iconName}}">&nbsp;</span>{{item.displayName}}</span>
		</div>
    	<div class="children" data-ng-class="item.state">
	        <div class="browse-item" data-ng-repeat="item in item.children" data-ng-include="'tree_item_renderer.html'"></div>
	    </div>
	</script>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.vms"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<div class="panel panel-default setup-panel">
		<div class="panel-body setup-content">
			<div class="row">
				<div class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
					<span class="col-xs-12 text-center server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
					<form class="form-horizontal edit-users-grid-form" id="selectContentForm"  name="selectContentForm" novalidate autocomplete="off">
						<div class="form-group">
							<label class="col-xs-12 col-lg-3 col-lg-offset-2"><cv:msg key="label.hypervisors" bundle="vmsJs"></cv:msg></label>
							<div data-ng-disabled="editMode || replicationGroup.replicatingVMGroup || replicationGroup.replicatingVM" class="col-xs-12 col-lg-7">
								<cv-select-hypervisors
									model="replicationGroup"
									vendor-list="sourceVendors"
									ctrl="ctrl">
								</cv-select-hypervisors>
							</div>
						</div>
						<div class="form-group" data-ng-hide='replicationGroup.attributes.replicationType === "LiveSyncIO"'>
							<label class="col-xs-12 col-lg-3 col-lg-offset-2"> <cv:msg
									key="label.name" bundle="vmsJs"></cv:msg>
							</label>
							<div class="col-xs-12 col-lg-7">
								<input type="text" id="name" name="name" data-ng-model="replicationGroup.name" data-ng-change="replicationGroupNameChanged(replicationGroup.name)"/>
								 <div class="help-block" data-ng-if="selectContentErr.name.message">
									<i class="ion-alert-circled" ></i>{{selectContentErr.name.message}}
								</div>
							</div>
						</div>
						<!-- Select VM Group -->
						<div class="form-group" data-ng-if="configureReplicationGroupContent.selections.showVMGroupSelection">
								<label class="col-xs-12 col-lg-3 col-lg-offset-2"><cv:msg
										key="label.selectVMGroups" bundle="restore"></cv:msg></label>
								<div class="col-xs-12 col-lg-7" >
									<div data-ng-if="replicationGroup.vmGroups"
									data-ng-disabled="replicationGroup.editMode || replicationGroup.replicatingVM || replicationGroup.replicatingVMGroup">
										<isteven-multi-select id="selectContent_isteven-multi-select_#3908" 
											data-input-model="replicationGroup.vmGroups"
											data-output-model="configureReplicationGroupContent.model.selectedVMGroup"
											data-tick-property="checked"
											data-item-label="subclientName"
											data-button-label="subclientName"
											data-search-property="subclientName"
											class="isteven-multi-select user-group-select"
											helper-elements="filter showSelected"
											data-selection-mode="single"
											group-property="msGroup"
											translation="configureReplicationGroupContent.localLang"
											on-close="configureReplicationGroupContent.vmGroupSelected()">
										</isteven-multi-select>
									</div>
									<!-- UI display when there is no data or when data is loading -->
									<input disabled type="text" data-ng-if="!replicationGroup.vmGroups" data-ng-model="configureReplicationGroupContent.loadingUI"/>
									<div class="help-block" data-ng-if="selectContentErr.selectVmGroup.message">
										<i class="ion-alert-circled"></i>{{selectContentErr.selectVmGroup.message}}
									</div>
								</div>
							</div>
						<!-- End Select VM Group -->
						<!-- Use Allocation Policy check-box -->
						<div class="form-group" 
							data-ng-if='configureReplicationGroupContent.selections.displayUseAllocationPolicyOption'>
							<div class="col-xs-12 col-lg-10 col-lg-offset-3" 
								data-ng-disabled="replicationGroup.editMode">
								<input name="useAllocationPolicyForRestore" 
									id="useAllocationPolicyForRestore" type="checkbox"
									data-ng-model="replicationGroup.useAllocationPolicyForRestore"
									data-ng-change="configureReplicationGroupContent.manageUpdatePolicy(replicationGroup.useAllocationPolicyForRestore)" />
									<label for="useAllocationPolicyForRestore" class="useVMAllocationPolicy">
										<cv:msg key="label.useVMAllocationPolicy" bundle="vms" />
									</label>
							</div>
						</div>
						<!-- Select VMs for existing backup -->
						<div class="form-group" data-ng-if="configureReplicationGroupContent.selections.showVMSelection">
								<label class="col-xs-12 col-lg-3 col-lg-offset-2"><cv:msg
										key="label.selectVMs" bundle="collections"></cv:msg></label>
								<div class="col-xs-12 col-lg-7">
									<div data-ng-disabled="!replicationGroup.vms || !replicationGroup.vms.length">
										<isteven-multi-select id="selectContent_isteven-multi-select_#4649" 
										data-input-model="replicationGroup.vms"
										data-output-model="replicationGroup.selectedVMs"
										data-tick-property="checked"
										data-search-property="name"
										data-item-label="name"
										class="isteven-multi-select user-group-select"
										data-button-label="name"
										helper-elements="{{helperElements}}"
										data-selection-mode="multiple"
										translation="configureReplicationGroupContent.localLang"
										on-close="configureReplicationGroupContent.vmSelected()"
										on-item-click="validateLastItem(data)"></isteven-multi-select>
									</div>
									<div class="help-block" data-ng-if="selectContentErr.selectVms.message">
										<i class="ion-alert-circled" ></i>{{selectContentErr.selectVms.message}}
									</div>
								</div>
							</div>
						<!-- Select VMs end -->
						<!-- VM Browsing -->
						<div class="form-group">
							<div data-ng-if='replicationGroup.isBrowseVMsAvailable'>
								<div data-ng-if="replicationGroup.defaultSubclientEntity">
									<label class="col-xs-12 col-lg-3 col-lg-offset-2">
										<cv:msg key="label.selectVMs" bundle="collections"></cv:msg>
									</label>
									<!-- Browse VMs -->
									<div class="col-sm-7">
										<div class="input-group">
											<input type="text" readonly
												maxlength="100" disabled />
											<span class="input-group-btn">
												<button type="button" id="browseVms"
													class="btn btn-default cvBusyOnAjax"
													data-ng-click="configureReplicationGroupContent.openCollectionContent();">
													<cv:msg key="label.browse" bundle="restore" />
												</button>
											</span>
										</div>
	
										<div class="help-block" data-ng-if="selectContentErr.selectVms.message">
											<i class="ion-alert-circled" ></i>{{selectContentErr.selectVms.message}}
										</div>
									</div>
								</div>
							</div>
						</div>
						<!-- End of browse VMs -->
						
						<!-- VM grids -->
						<div class="col-xs-12 col-lg-7 col-lg-offset-3" 
							data-ng-if="configureReplicationGroupContent.vmPreview.length && 
										configureReplicationGroupContent.selections.showVMGrid">
							<cv-grid cv-grid-options="configureReplicationGroupContent.gridOptions"></cv-grid>
						</div>
						<!-- VM grids end -->
						<div class="form-group" data-ng-if="replicationGroup.showPlan">
							<label class="col-xs-12 col-lg-3 col-lg-offset-2" for="plans"><cv:msg key="label.profile" bundle="profiles"/></label>
							<div class="col-xs-12 col-lg-7" data-ng-disabled="!replicationGroup.planList">
								<isteven-multi-select id="selectContent_isteven-multi-select_#1603" 
									input-model="replicationGroup.planList"
									output-model="replicationGroup.selectedPlanList"
									button-label="planName"
									item-label="planName"
									tick-property="selected"
									data-search-property="planName"
									class="isteven-multi-select user-group-select"
									helper-elements="filter showSelected"
									selection-mode="single"
									translation="configureReplicationGroupContent.localLang"
									group-property="msGroup"
									on-close="configureReplicationGroupContent.planSelected()">
								</isteven-multi-select>
								 <div class="help-block" data-ng-if="selectContentErr.selectPlan.message">
									<i class="ion-alert-circled" ></i>{{selectContentErr.selectPlan.message}}
								</div>
							</div>
						</div>
						<div class="form-group" data-ng-if="replicationGroup.showSnapShotEngine">
							<label class="col-xs-12 col-lg-3 col-lg-offset-2" for="snapEngine"><cv:msg key="label.snapEngine" bundle="vmsJs"/></label>
							<div class="col-xs-12 col-lg-7" >
									<div data-ng-if="replicationGroup.snapEngineList">
										<isteven-multi-select id="selectContent_isteven-multi-select_#4970" 
											input-model="replicationGroup.snapEngineList"
											output-model="replicationGroup.selectedSnapEngine"
											button-label="snapShotEngineName"
											item-label="snapShotEngineName"
											tick-property="selected"
											data-search-property="snapShotEngineName"
											class="isteven-multi-select user-group-select"
											helper-elements="filter showSelected"
											selection-mode="single"
											translation="configureReplicationGroupContent.localLang"
											on-close="configureReplicationGroupContent.snapEngineSelected()">
										</isteven-multi-select>
									</div>
									<input disabled type="text" data-ng-if="!replicationGroup.snapEngineList || !replicationGroup.snapEngineList.length" data-ng-model="configureReplicationGroupContent.loadingUI"/>
									 <div class="help-block" data-ng-if="selectContentErr.snapEngineErr.message">
										<i class="ion-alert-circled" ></i>{{selectContentErr.snapEngineErr.message}}
									</div>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<div class="button-container">
		<button id="selectContent_button_#0739" class="btn btn-default cvBusyOnAjax" 
			data-ng-click="goBackToReplicationType()" data-ng-if="goBackButtonAvailable">
			<cv:msg key="Back" bundle="messages"></cv:msg>
		</button>
		<button id="selectContent_button_#3186" data-ng-click="goToTarget()" class="btn btn-primary cvBusyOnAjax" type="submit"> 
			<cv:msg key="Next" bundle="messages"></cv:msg>
		</button>
	</div>
</div>