	<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
	<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
	<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
	<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	</script>
	<fmt:bundle basename="localization.settings">
	<span class="center-container">
		<div class="center-container__center-el">
			<div class="back-strip">
				<div class="set-up-page">
					<div class="setup-title">
						<h1><fmt:message key="pageHeader.configureEmail" /></h1>
					</div>
					<div class="setup-content" data-ng-controller="configureEmailController">
						<span class="{{configureEmailMessage.type}} serverMessage">{{configureEmailMessage.message}}</span>
						<form name="configureEmailForm" novalidate data-cv-submit="configureEmail()" autocomplete="off">
							<div>
								<label for="smtpServer"><fmt:message key="label.smtpServer" />
										<input type="text" name="smtpServer" id="smtpServer" data-ng-model="model.smtpServer" required/>
										<span class="help-block" data-ng-show="cv.configureEmailForm.needsAttention(configureEmailForm.smtpServer)"><fmt:message key="error.smtpServer" /></span>
								</label>
								<label for="smtpPort"><fmt:message key="label.smtpPort" />
										<input type="number" name="smtpPort" id="smtpPort" data-ng-model="model.smtpPort" max="61000" min="1" value="25" required/>
										<span class="help-block" data-ng-show="cv.configureEmailForm.needsAttention(configureEmailForm.smtpPort)"><fmt:message key="error.smtpPort" /></span>
								</label>
								<label for="senderEmail"><fmt:message key="label.senderEmail" />
									<input type="email" name="senderEmail" id="senderEmail" data-ng-model="model.senderEmail" ng-pattern="/^[_a-z0-9]+(\.[_a-z0-9]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4})$/" required />
									<span class="help-block" data-ng-show="cv.configureEmailForm.needsAttention(configureEmailForm.senderEmail) || showError"><fmt:message key="error.senderEmail" /></span>
								</label>
								<label for="senderName"><fmt:message key="label.senderName" />
									<input type="text" name="senderName" id="senderName" data-ng-model="model.senderName"  required/>
									<span class="help-block" data-ng-show="cv.configureEmailForm.needsAttention(configureEmailForm.senderName) || showError"><fmt:message key="error.senderName" /></span>
								</label>
			
							</div>
								
							<div class="button-container">
								<fmt:bundle basename="localization.messages">
									<button id="configureEmail_button_#7336" type="submit" class="btn btn-primary cvBusyOnAjax"><fmt:message key="Save" /></button> 
									<button id="configureEmail_button_#9921" type="button" class="btn btn-default skip-btn--hidden" data-ng-click="cancel()"><fmt:message key="Skip" /></button> 
								</fmt:bundle>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</span>
	</fmt:bundle>
