<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.scheduleJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
    <cv:cvMessages bundle="localization.reports"></cv:cvMessages>
    <cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
    <cv:cvMessages bundle="localization.capps"></cv:cvMessages>
    <cv:cvMessages bundle="localization.dr"></cv:cvMessages>
    <cv:cvMessages bundle="localization.browse"></cv:cvMessages>
	<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
	<cv:cvEnum name="App.VSAFailoverStatus"></cv:cvEnum>
	<cv:cvEnum name="App.VSAReplicationStatus"></cv:cvEnum>
	<cv:cvEnum name="Common.VSVendor"></cv:cvEnum>
	<cv:cvEnum name="App.VMSLAStatus"></cv:cvEnum>
</script>
<fmt:setBundle basename="localization.collections" var="collections" />
<fmt:setBundle basename="localization.servers" var="servers" />
<fmt:setBundle basename="localization.schedule" var="schedule" />
<div class="row" data-ng-if="!hidePage">
    <div class="col-xs-12">
        <cv-changename data-ng-if="changeNameObj" obj='changeNameObj' service-method='changeVMGroupName.do' class="float-left"></cv-changename>
    </div>
</div>
<cv-tab-nav></cv-tab-nav>

<div class="row" data-ng-if="showSearch">
	<div class="col-md-12">
		<span class="page-action-item search-widget-wrapper search-filter">
			<input name="fileAndFolderSearch" id="fileAndFolderSearch" type="search" data-ng-model="model.vmSearchTerm" style="width:220px" autocomplete="off"
			 placeholder="<cv:msg key="label.globalSearch.filesCommandDescription" bundle="messages" />" class="search-field" data-ng-keyup="$event.keyCode == 13 && searchVMgroup(model.vmSearchTerm)" title="<cv:msg key="placeholder.searchFilesAndFolders" bundle="serversJs" />">
			<input style="display:none" type="search" name="fileAndFolderSearch" />
			<span data-ng-click="model.vmSearchTerm=''" class="form-control-clear glyphicon glyphicon-remove form-control-feedback" title='<cv:msg key="label.clear" bundle="messages" />'></span>
		</span>
	</div>
</div>


<div class="row">
    <div class="col-xs-12"><span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span></div>
</div>
<uib-tabset ng-if="!hidePage" active="tabConfig.activeTab" class="vm-nav">
    <uib-tab index="0">
        <div class="row margin-top-20">
            <div class="col-md-6">
                <div data-ng-if="vmTitle.length > 0">
                    <cv-entity-status data="vmStatusInfo" data-title='{{::vmTitle}}'></cv-entity-status>
                </div>
                <cv-tile-component data-ac-id="collectionDetails-label_summary-servers" data-title='<cv:msg key="label.summary" bundle="servers"/>' loader="dataManagement" cv-capability="cvCapabilityConfig.general">
                    <ul class="list-style-secondary">
                        <li class="group" data-ng-if='!!details.subClientEntity.displayName' >
                        		<span class="pageDetailColumn" data-ng-if="vendor !== 'KUBERNETES'"><cv:msg key="label.serverName" bundle="servers" /></span>
                                <span class="pageDetailColumn" data-ng-if="vendor === 'KUBERNETES'"><cv:msg key="label.clusterName" bundle="servers" /></span>
				                  <span class="pageDetailColumn"><a href="{{clientDetailsUrl}}">{{::details.subClientEntity.displayName}}</a></span>
						</li>
                        <li class="group" data-ng-if='details.commonProperties.lastBackupTime!=0' >
                        		<span class="pageDetailColumn"><cv:msg key="label.lastbackup.time" bundle="collections" /></span>
                            <span class="pageDetailColumn">
                            		<div class="time crop" val="{{details.commonProperties.lastBackupTime}}"></div>
                            	</span>
						</li>
                        <li class="group" data-ng-if="details.commonProperties.lastBackupSize">
                        		<span class="pageDetailColumn"><cv:msg key="label.lastbackup.size" bundle="collections" /></span>
                            <span class="pageDetailColumn">{{details.commonProperties.lastBackupSize | capacity}}</span>
                        </li>
                        <li class="group" data-ng-if='details.commonProperties.nextBackupTime!=0'>
                            <span class="pageDetailColumn"><cv:msg key="label.nextbackup.time" bundle="collections" /></span>
                            <span data-ng-if='details.commonProperties.nextBackupTime!=0' class="pageDetailColumn">
                            <div class="time crop" val="{{details.commonProperties.nextBackupTime}}"></div>
                        </span>
                        </li>
                        <!-- plan block -->
                        <li class="group" data-ng-if="showPlanRow">
                            <cv-plan-select show-none="true" show-edit="true" plan-entity="planEntity" entity="backupEntity"></cv-plan-select>
                        </li>
                        <!-- region add/edit block -->
                        <li class="group" >
                            <cv-region-select class="planMigration-block" data-ng-if="planRuleEnabled" client-api="Subclient" data-cv-client-id="collectionId" data-cv-client-region-info="clientRegion"></cv-region-select>
                        </li>
                        <li class="group" data-ng-if="collectionTimeZoneObject">
							<cv-time-zone-select class="planMigration-block" data-cv-client-time-zone-object="collectionTimeZoneObject"></cv-time-zone-select>
						</li>
                        <!-- End region add/edit block -->
                        <!-- Replication group  -->
                        <li class="group" data-ng-if='details.replicationGroup.replicationGroupName' id="vmGroup-ReplicationGroupName">
                        	<span class="pageDetailColumn"><cv:msg key="label.replicationGroup" bundle="replicationGroups" /></span>
		                 	<a class="pageDetailColumn" href="#/replicationGroups/?repGrpId={{details.replicationGroup.replicationGroupId}}" data-ng-bind="details.replicationGroup.replicationGroupName"></a>
						</li>
						
                        <cv:comp name="show.label.data.management">
                            <li class="group">
                                <span class="pageDetailColumn"><cv:msg key="label.data.management" bundle="servers"/></span>
                                <span class="pageDetailColumn toggle-container">
                            <toggle-control class="{{dataManagement}} {{dataManagementRequest}}" status="dataManagement" data-ng-click="manageActivity('backup')" title="Enable/disable <cv:msg key='label.data.management' bundle='servers' />"></toggle-control>
                        </span>
                            </li>
                        </cv:comp>
                    </ul>
                </cv-tile-component>
            </div>
            <div class="col-md-6">
                <!-- <cv-tile-component data-ac-id="collectionDetails-label_backup-collections" data-title='<cv:msg key="label.backup" bundle="collections"/>' loader="details">
                    <ul class="serverBackupTile">
                        <li>
                            <span class="page-details-box-links multiLinks">
                                <ul>
                                    <li data-ng-if="showBackup['backup'] && vendor" class="restoreli" data-ng-click="showBackupOptions()"><a href=""><cv:msg key="action.backupNow" bundle="collections" /></a>
                                    </li>
                                    <li data-ng-show="details"> <a href="#jobs?serverId={{serverId}}&serverName={{serverName}}&collectionId={{collectionId}}&collectionName={{details.subClientEntity.subclientNameURL}}&jobType=Backup,SYNTHFULL"><cv:msg
                                        key="action.jobs" bundle="servers" /></a></li>
                                </ul>
                            </span>
                        </li>
                        <li data-ng-if="showBackup['backup']">
                            <p class="info-place-holder">
                                <cv:msg key="info.nobackupRunning" bundle="collections" />
                            </p>
                        </li>
                        <li data-ng-if="showBackup['submittingJob']">
                            <p class="info-place-holder">
                                <cv:msg key="info.submittingJob" bundle="collections" />
                            </p>
                        </li>
                        <li data-ng-if="backupJobs.length>0">
                            <cv-job jobs='backupJobs' show-backup='showBackup' capability="jobCap"></cv-job>
                        </li>
                    </ul>
                </cv-tile-component> -->
                <cv-backup-history data-title='<cv:msg key="label.recoveryPoint" bundle="vmsJs"/>' entity="backupEntity" show-legend="'true'" params="historyParams"  on-restore="performRestore(job, fromTimeStr, toTimeStr)"
                	on-validate-backup="validatePITBackup" is-backup-validation-eligible="backupValidationEnabled" ng-if="backupEntity"></cv-backup-history>
                <div data-ng-controller='showContentController' ng-show="isOverviewLeftSideTilesLoaded">
                    <cv-tile-component data-ac-id="collectionDetails-header_content-collections" data-title='<cv:msg key="header.content" bundle="collections"/>' loader="data.collectionContent.content" min-height="true">
                        <ul data-ng-repeat="ce in data.collectionContent.content" class="general-list list-style__row group viewContentList full-width__LI">
                            <li data-ng-if="ce.displayName=='\\'" class="vsaColumnIcon vsaIcon{{ce.icon}}">
                                {{::defaultContentLabel}}
                            </li>
                         	<li data-ng-if="ce.displayName!='\\' && ce.type == 'VMCustomAttribute' && vendor != 'KUBERNETES'" class="vsaColumnIcon vsaIcon{{ce.icon}}">{{ce.name}}:{{ce.displayName}}</li>
                            <li data-ng-if="ce.displayName!='\\' && ce.type == 'VMCustomAttribute' && vendor == 'KUBERNETES'" class="vsaColumnIcon vsaIcon{{ce.icon}}">{{ce.displayName}}</li>
                 			 <li data-ng-if="ce.displayName!='\\' && ce.type != 'VMCustomAttribute'" class="vsaColumnIcon vsaIcon{{ce.icon}}">{{ce.displayName}}</li>
                        </ul>
                        
                         <ul data-ng-if="data.collectionContent.allRules.length" data-ng-repeat="ce in data.collectionContent.allRules" class="general-list list-style__row group viewContentList full-width__LI">
                            <li data-ng-if="ce.isRuleGroup" class="vsaColumnIcon vsaIcon{{ce.icon}} wrap-cv-fancy-tooltip task-details-fancy-tooltip">
                            	<cv-fancy-tooltip class="fancy-tooltip-no-break" 
                            	cv-display-width="500"
                            	cv-objects="ce.allReadableChildren" ></cv-fancy-tooltip>
                            </li>
                        </ul>
                        
                        <div data-ng-if="data.collectionContent.filters.length || data.collectionContent.diskFilters.length" class="content-list-separator">
                            <ul data-ng-if="data.showFilters" data-ng-repeat="ce in data.collectionContent.filters" class="general-list list-style__row group viewContentList full-width__LI">
                                <li data-ng-if="ce.type == 'VMCustomAttribute' || (ce.type == 'Tag' && vendor == 'GOOGLE_CLOUD')" class="vsaColumnIcon vsaIcon{{ce.icon}}">{{ce.name}}:{{ce.displayName}}<span class="parenthetical-text"><cv:msg key="indicator.filter" bundle="collections" /></span></li>
                                <li data-ng-if="ce.type != 'VMCustomAttribute'" class="vsaColumnIcon vsaIcon{{ce.icon}}">{{ce.displayName}}<span class="parenthetical-text"><cv:msg key="indicator.filter" bundle="collections" /></span></li>
                            </ul>
                            <ul data-ng-if="data.showFilters" data-ng-repeat="ce in data.collectionContent.diskFilters" class="general-list list-style__row group viewContentList full-width__LI">
                                <li class="vsaColumnIcon vsaIcon{{ce.icon}}">{{ce.filter}}<span data-ng-if="ce.value"> / {{ce.value}} </span>
                                	<span class="parenthetical-text"><cv:msg key="indicator.diskFilter" bundle="collections" /></span>
                                </li>
                            </ul>
                            <ul data-ng-if="data.filtersHidable" class="general-list list-style__row group viewContentList full-width__LI">
                                <li><a href="" data-ng-click="data.showFilters=!data.showFilters">{{data.showFilters ? hideFiltersLabel : showFiltersLabel}}</a></li>
                            </ul>
                        </div>
                        <div class="page-details-box-links" data-ng-show="!isDeconfiguredClient">
                            <a href="" data-ng-if="data.collectionContent.content" data-ng-click="openManageCollectionContentDialog(details.subClientEntity)">
                                <cv:msg key="action.manage" bundle="collections" />
                            </a>
                        </div>
                    </cv-tile-component>
                </div>

				<div data-ng-if="details">
					<cv-entity-plan-policy-tiles data-ng-if="!(planEntity&&planEntity.planId)" data-cv-application-id="applicationId"   data-cv-subclient-id="subclientId" data-cv-client-id="serverId" data-cv-subclient-name ="details.subClientEntity.subclientName"  data-cv-plan-entity="planEntity" data-cv-show-edit="true"
	                data-cv-show-schedule="details" data-cv-show-storage="details.commonProperties" data-cv-show-plan="showPlan" data-cv-hide-plan-storage="planEntity&&planEntity.planId"  data-cv-hide-plan-schedule="planEntity&&planEntity.planId"  data-cv-on-policy-updated="onPolicyUpdated" cv-hide-policy-tile="true">
	                </cv-entity-plan-policy-tiles>
				</div>
            </div>
        </div>
    </uib-tab>
    <uib-tab index="1">
        <div class="row margin-top-20">
            <div class="col-md-6">
                <cv-security-component entity-type='entityType' generic-entity = 'genericEntity' associations='formattedSecurityAssociations' associations-loaded='associationsLoaded' cv-capability="cvCapabilityConfig.security">
                </cv-security-component>
                <cv-tile-component data-ac-id="collectionDetails-label_settings-profiles" data-title='<cv:msg key="label.settings" bundle="profiles"/>' loader="details">
                    <ul class="list-style-secondary">
                        <li class="group" data-ng-if="(showCBT() && (!isMeditechSystem))">
                            <span class="pageDetailColumn"><cv:msg key="label.useChangedBlockTracking" bundle="collectionsJs" /></span>
                            <span class="pageDetailColumn"><toggle-control  status="useCBT"  data-ng-click="manageOptionActivity('useCBT')" title="Enable/disable <cv:msg key="label.useChangedBlockTracking" bundle="collectionsJs" />"></toggle-control></span>
                        </li>
                        <li class="group" data-ng-if="showAutoDetectVMOwner">
                            <span class="pageDetailColumn"><cv:msg key="label.autoDetectVMOwner" bundle="collectionsJs" /></span>
                            <span class="pageDetailColumn"><toggle-control status="autoDetectVMOwner" data-ng-click="manageOptionActivity('autoDetectVMOwner')"  title="Enable/disable <cv:msg key="label.autoDetectVMOwner" bundle="collectionsJs" />"></toggle-control>
                        </span>
                        </li>
                        <li class="group">
                            <span class="pageDetailColumn"><cv:msg key="label.noOfReaders" bundle="collectionsJs" /></span>
                            <span class="pageDetailColumn">{{details.commonProperties.numberOfBackupStreams}}</span>
                        </li>

                        <li class="group" data-ng-if="(!isMeditechSystem) && (showVMBackupType() ||  (showAppaware() &&details.commonProperties.snapCopyInfo.applicationAware))"><span class="pageDetailColumn"><cv:msg key="label.vmBackupType" bundle="collectionsJs" /></span>
                            <span  class="pageDetailColumn">{{backupType()}}
                                <a class='credential-edit' title='  <cv:msg key="label.editCredentials" bundle="collectionsJs" />' href=""  data-ng-click="editAppCredentials()" data-ng-if="isAppAwareEnabled && isAppAwareEnabledVendor && details.commonProperties.snapCopyInfo.applicationAware">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="svg-primary-fill" >
                                    <path d="M12.65 10C11.83 7.67 9.61 6 7 6c-3.31 0-6 2.69-6 6s2.69 6 6 6c2.61 0 4.83-1.67 5.65-4H17v4h4v-4h2v-4H12.65zM7 14c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"/>
                                </svg>
                                <!--   <i class="glyphicon glyphicon-pencil "></i>-->
                                </a>
                            </span>
                        </li>
                        <li class="group" data-ng-repeat="ce in transportModeTypes" data-ng-if="showTransportMode(ce.value)">
                            <span class="pageDetailColumn"><cv:msg key="label.transportMode" bundle="collectionsJs" /></span>
                            <!-- <ul data-ng-repeat="ce in transportModeTypes" > -->
                            <span class="pageDetailColumn">{{ce.name}}</span>
                            <!-- </ul> -->
                        </li>
                        <li data-ng-if="loaded() && isFreespaceCheckEnabled()" class="group">
                            <span class="pageDetailColumn"><cv:msg key="label.datastoreFreespaceRequired" bundle="collectionsJs" /></span>
                            <span class="pageDetailColumn">{{getCurrentFreespaceRequired()}}%</span>
                        </li>
                        <li data-ng-if="loaded() && isFreespaceCheckApplicable() && !isFreespaceCheckEnabled()" class="group">
                            <span class="pageDetailColumn"><cv:msg key="label.datastoreFreespaceCheck" bundle="collectionsJs" /></span>
                            <span class="pageDetailColumn">{{locOnOff(false)}}</span>
                        </li>
                        <li data-ng-if ="!isIndexingV2VSA  && (vendor==='VMW' || vendor==='MICROSOFT' || vendor==='XEN_SERVER' )" class="group">
                            <span class="pageDetailColumn">
                            	<cv-help-text help-label='label.collectFileDetails' help-text='label.info.collectFileDetailsIndexing'></cv-help-text>
                            </span>
                            <span class="pageDetailColumn"><toggle-control  status="collectFileDetail" data-ng-click="manageOptionActivity('collectFileDetail')" title="Enable/disable <cv:msg key="label.collectFileDetails" bundle="collectionsJs" />"></toggle-control></span>
                        </li>
                    <li data-ng-if="!isIndexingV2VSA && vendor && (vendor==='VMW' ||vendor ==='MICROSOFT'|| vendor==='XEN_SERVER')&& (details.commonProperties.snapCopyInfo.isSnapBackupEnabled === true) " class="group">
                            <span class="pageDetailColumn">
                            	<cv-help-text help-label='label.collectFileDetailsForSnap' help-text='label.info.collectFileDetailsIndexing'></cv-help-text>
                            </span>
                            <span class="pageDetailColumn"><toggle-control  status="collectFileDetailsForSnap" data-ng-click="manageOptionActivity('collectFileDetailsForSnap')" title="Enable/disable <cv:msg key="collectFileDetailsForSnap" bundle="collectionsJs" />"></toggle-control></span>
                        </li>
                        <li data-ng-if="(!isMeditechSystem) && showIntellisnapOption()" class="group">
                            <span class="pageDetailColumn">
                            		 <cv-help-text help-label="label.intellisnap" help-text="label.intellisnapHelpText"></cv-help-text>
                            	</span>
                            <span class="pageDetailColumn toggle-container" data-ng-if="allowIntellisnapOperations">
                                <toggle-control status="intellisnapManagement" data-ng-click="manageIntellisnapActivity()" title="<cv:msg key='label.intellisnapTitle' bundle='collectionsJs'/>"></toggle-control>
                            </span>
                            <span class="pageDetailColumn error" data-ng-if="!allowIntellisnapOperations"><cv:msg key="label.associatePlanForIntellisnap" bundle="collectionsJs"/></span>
                        </li>
                      <li class="group" data-ng-if="showFileIndexing">
                            <span class="pageDetailColumn">
                                    <span data-ng-if="!indexingStatus || indexingStatus==''|| indexingRequest=='disabled'">
                                    	<cv-help-text help-label='label.data.indexing' help-text='label.info.indexingCollectFileDetails'></cv-help-text>
                                   	</span>
                                    <span data-ng-if="indexingStatus!==''&& fileIndexing=='disabled-activity' && indexingRequest!='disabled'">
                                    <cv-help-text use-icon="true" help-label="label.data.indexing" help-text="indexingStatus"/>
                                </span>
                                <span data-ng-if="indexingRequest=='disabled'">
                                    <i class="fa fa-spinner fa-spin" data-uib-tooltip="{{indexingStatus}}" tooltip-placement="top"></i>
                                </span>

                            </span>
                            <span class="pageDetailColumn toggle-container">
                                <toggle-control  class="{{fileIndexing}} {{indexingRequest}}" status="fileIndexing" data-ng-click="manageOptionActivity('fileIndexing')" title="<cv:msg key='label.data.indexing' bundle='servers' />"></toggle-control>
                            </span>
                        </li>
                        <li class="group" ng-if="jobStartTimeProps">
                            <span class="pageDetailColumn"><cv:msg key="label.jobStartTime" bundle="profiles" /></span>
                            <span class="pageDetailColumn">
                                <cv-job-start-time on-save="jobStartTimeProps.onStartTimeChange(isEnabled, jobStartTime)" on-reset="jobStartTimeProps.onStartTimeChange()" job-start-time="jobStartTimeProps.jobStartTimeObj"></cv-job-start-time>
                            </span>
                        </li>
                    </ul>
                    <div class="page-details-box-links">
                        <a href="" data-ng-click="showOptionsDialog(id, details.commonProperties.numberOfBackupStreams)">
                            <cv:msg key="action.edit" bundle="collections" />
                        </a>
                    </div>
                </cv-tile-component>
                <cv-tile-component data-ng-if="isMeditechSystem" data-ac-id="collectionDetails-label_Meditech_System" data-title='<cv:msg key="label.meditechSystem" bundle="dr"/>' loader="details">
                    <ul class="list-style-secondary">
                        <li class="group">
                            <span class="pageDetailColumn"><cv:msg key="label.systemName" bundle="dr" /></span>
                            <span class="pageDetailColumn" data-ng-bind="details.hcSubclientProp.meditechSystems[0].medicalSystemName"></span>
                        </li>
                        <li class="group">
                            <span class="pageDetailColumn"><cv:msg key="label.masterNode" bundle="dr" /></span>
                            <span class="pageDetailColumn" data-ng-bind="details.hcSubclientProp.meditechSystems[0].listenerIP"></span>
                        </li>
                        <li class="group">
                            <span class="pageDetailColumn"><cv:msg key="label.masterNodePort" bundle="dr" /></span>
                            <span class="pageDetailColumn" data-ng-bind="details.hcSubclientProp.meditechSystems[0].listenerPort"></span>
                        </li>
                        <li class="group">
                            <span class="pageDetailColumn"><cv:msg key="label.userName" bundle="dr" /></span>
                            <span class="pageDetailColumn" data-ng-bind="details.hcSubclientProp.meditechSystems[0].userAccount.userName"></span>
                        </li>
                        <li class="group">
                            <span class="pageDetailColumn"><cv:msg key="label.mbfTimeout" bundle="dr" /></span>
                            <span class="pageDetailColumn" data-ng-bind="details.hcSubclientProp.meditechSystems[0].timeout"></span>
                        </li>
                    </ul>
                    <div class="page-details-box-links">
                        <a href="" data-ng-click="openMeditechSystemModel()">
                            <cv:msg key="action.edit" bundle="collections" />
                        </a>
                    </div>
                </cv-tile-component>
                <cv:comp name="show.storage">
                    <%--ByAbdul:@Gaurav Uncomment this if directive is needed ..  --%>
                        <!--<cv-storage-policy-component data-ng-if="isScheduleEditable" show-edit="true" client-id="serverId" application-id="vsaApplicationId" subclient-id="collectionId" hide-copy-properties="true"></cv-storage-policy-component>-->
                        <!--<cv-tile-component data-ac-id="collectionDetails-label_storage-collections" data-ng-if="storagePolicyLoaded" data-title='<cv:msg key="label.storage" bundle="collections"/>' loader = "storagePolicyLoaded">
                        <ul class="list-style-secondary" data-ng-class='{error: !storagePolicy.copy.length}' >
                            <li data-ng-if='storagePolicy' class="group"><span class="pageDetailColumn"><cv:msg key="label.library" bundle="collections" /></span>
                                    <span data-ng-if="storagePolicy.copy.length" class="pageDetailColumn">{{storagePolicy.copy[0].library.libraryName}}</span>
                                    <span data-ng-if="!storagePolicy.copy.length" class="pageDetailColumn"><cv:msg key="label.noRetentionSelected" bundle="collections" /></span></li>
                            <li data-ng-if='storagePolicy' class="group"><span class="pageDetailColumn"><cv:msg key="label.retentionDays" bundle="collections" /></span>
                                    <div data-ng-if="storagePolicy.copy.length" ><span data-ng-if="storagePolicy.copy[0].retentionRules.retainBackupDataForDays !=-1" class="pageDetailColumn basic-text-color">{{storagePolicy.copy[0].retentionRules.retainBackupDataForDays | days:'<cv:msg key="label.days" bundle="collections" />'}} </span>
                                    <span data-ng-if="storagePolicy.copy[0].retentionRules.retainBackupDataForDays ==-1" class="pageDetailColumn basic-text-color"><cv:msg key="label.infinite" bundle="collections" /></span></div>
                                    <span data-ng-if="!storagePolicy.copy.length" class="pageDetailColumn"><cv:msg key="label.noLibSelected" bundle="collections" /></span></li>
                        </ul>
                        <div class="page-details-box-links">
                            <a href=""
                                data-ng-click="showEditStorageDialog(storagePolicy, storagePolicy.copy[0].library.libraryId, storagePolicy.copy[0].retentionRules.retainBackupDataForDays)" data-ng-if="editStorageEnabled && !storageUnavailable"><cv:msg key="action.edit" bundle="collections" />
                            </a>
                        </div>
                        </cv-tile-component>--->
                    <cv-storage-pool-tile data-ng-if="primaryStoragePoolInfo && !isScheduleEditable && !(planEntity&&planEntity.planId)" plan-sub-type="planSubType" show-edit="false" profile-id="profileId" primary-storage-pool-info="primaryStoragePoolInfo" secondary-storage-pool-info="secondaryStoragePoolInfo"
                        snap-storage-info="snapStorageInfo"></cv-storage-pool-tile>
                </cv:comp>
                    <cv-snap-shot-engine-tile data-ng-if="details && showSnapEngine" subclient-details="details"  vendor="vendor"></cv-snap-shot-engine-tile>
            </div>
            <div class="col-md-6" ng-if="isConfigurationLeftSideTilesLoaded">
                <!--<cv-plan-component subclient-id="collectionId" app-id="applicationId" data-ng-if="(collectionId && showPlan && PlanSet) || (!PlanSet && storageUnavailable)" client-id="serverId" type="Server" vendor="vendor" plan-entity="planEntity">
                </cv-plan-component>-->
                <cv-tile-component ng-if="showBackupValidationSettings && !isSnapBackupEnabled && backupValidationLoadComplete" data-ac-id="backupValidation-label_BackupValidation" data-title='<cv:msg key="label.backupValidation" bundle="dr"/>'>
                <ul class="list-style-secondary">
                    <li class="group">
                    <div><span class="pageDetailColumn"><cv:msg key="label.enableBackupValidation" bundle="dr"/></span>
                    </div>
                    <div class="pageDetailColumn inline-editor">
                        <span>
                            <toggle-control id="enableBackupValidation" status="backupValidationEnabled ? 'enabled-activity' : 'disabled-activity'" data-ng-click="toggleVMGroupBackUpValidation()">
                            </toggle-control>
                        </span>
                	</div>
                    </li>
                    <li class="group" data-ng-if="LCPolicySet && backupValidationEnabled">
                        <span class="pageDetailColumn"><cv:msg key="label.lifeCyclePolicy" bundle="dr" /></span>
                        <span class="pageDetailColumn">{{userVMAllocPolicy.vmAllocPolicyName}}</span>
                    </li>
                    <li class="group" data-ng-if="enableSourceVMESXMount && !LCPolicySet && backupValidationEnabled">
                        <span class="pageDetailColumn"><cv:msg key="label.lifeCyclePolicy" bundle="dr" /></span>
                        <span class="pageDetailColumn"><cv:msg key="label.sourceEsx" bundle="dr" /></span>
                    </li>
                    <li class="group" data-ng-if="bkpValidationScheduleAvailable && backupValidationEnabled">
                         <span class="pageDetailColumn"><cv:msg key="label.scheduleFrequency" bundle="dr"/></span>
                         <span class="pageDetailColumn">
                            {{bkpValidationscheduleModel.pattern.timeStr}}
                         </span>
                    </li>
                    <li class="group" data-ng-if="!bkpValidationScheduleAvailable && backupValidationEnabled">
                         <span class="pageDetailColumn"><cv:msg key="label.scheduleFrequency" bundle="dr"/></span>
                         <span class="pageDetailColumn">
                            <cv:msg key="label.scheduleNotSet" bundle="dr"/>
                         </span>
                    </li>
                </ul>
                <div class="page-details-box-links" ng-if="backupValidationEnabled">
                     <a href="" data-ng-click="openLifeCyclePolicyModal(true)">
                         <cv:msg key="action.edit" bundle="collections" />
                     </a>
                 </div>
                </cv-tile-component>
             <!--    <cv-alert-component alerts='alerts' cv-capability="cvCapabilityConfig.alerts"></cv-alert-component> -->
              	<cv-capps-snap-replication-tile data-ng-if="showCrossAccountOperations" subclient-info="details" />
              	<cv-proxy-component empty-proxy-message="{{emptyProxyMsg}}" instance-id="instanceId" subclient-id="collectionId" client-id="serverId" server-name="serverName" server-type="vendor"></cv-proxy-component>
            </div>
        </div>
    </uib-tab>
</uib-tabset>
