<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.collections">
	<script type="text/ng-template"  id="tree_item_renderer.html">
		<div data-ng-class="{'selected': item.selectedState==='selected', 'partial': item.selectedState==='partial'}" >
			<button id="browseVMDestinations_button_#5211" type="button" data-ng-class="item.state | lowercase" data-ng-click="itemDrilledDown(item)"></button> 
            <span data-ng-click="toggleSelectedState(item)"><span class="vsaIconLOADING {{item.iconName}}">&nbsp;</span>{{item.displayName}}</span>
		</div>
    	<div class="children" data-ng-class="item.state">
	        <div class="browse-item" data-ng-repeat="item in item.children" data-ng-include="'tree_item_renderer.html'"></div>
	    </div>
	</script>
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<!-- add additional check to make this visible only on a condition for attached disk-->
	<div data-ng-if="ctrl && ctrl.showInstaceNameIdSelection">
		<input name="instanceNameId" id="instanceNameId" type="checkbox"
				data-ng-model="model.showInstanceNameIdSelection"
				data-ng-change="showInstanceName()"/>
		<label for="instanceNameId" class="overwriteLabel">
			<cv:msg key="label.showVMInstanceId" bundle="browse"/>
		</label>
	</div>
	<div class="multiSelectVMs" ng-hide="serverMessage.message">
			<div class="browseAndSelectVM">
				<div class="browse-tree" style="clear: both;">
			    	<div data-ng-repeat="item in treeData.tree.children" class="browse-item" data-ng-include="'tree_item_renderer.html'"></div>
				</div>
				<span class="help-block"
					data-ng-if="showContentWarning()">
						<fmt:message key="error.noItemSelected" />
				</span>
 			</div>
	</div>
</fmt:bundle>