<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.collections">
	<script type="text/ng-template"  id="tree_item_renderer.html">
		<div data-ng-class="{'selected': item.selectedState==='selected', 'partial': item.selectedState==='partial'}" >
			<button id="browseCollectionContent_button_#3035" type="button" data-ng-class="item.state | lowercase" data-ng-click="itemDrilledDown(item)"></button>
			<span data-ng-click="toggleSelectedState(item)" title="{{serverVendor === 'KUBERNETES' ? item.toggle : item.displayName}}"><span class="vsaIconLOADING {{item.iconName}}">&nbsp;</span>{{item.displayName}}</span>
		</div>
    	<div class="children" data-ng-class="item.state">
	        <div class="browse-item" data-ng-repeat="item in item.children" data-ng-include="'tree_item_renderer.html'"></div>
	    </div>
	</script>
	<script type="text/ng-template" id="vmSelection">
	    <div data-ng-hide="singleSelectionMode || strictSingleSelectionMode" class="padding-bottom-20">
			<a ng-show="browseResp"
				class="group select-clear-all"
				data-ng-class="{' float-right position-relative' : wizardLayout ==='true'}"
				ng-click='clearAll()'>
					<cv:msg key="label.clearAll" bundle="collections"/>
			</a>
			<a ng-show="browseResp"
				class="group select-clear-all"
				data-ng-class="{' float-right position-relative margin-right-20' : wizardLayout ==='true'}"
				ng-click='selectAll()'>
					<cv:msg key="label.selectAll" bundle="collections" />
			</a>
		</div>
	 </script>
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<div class="multiSelectVMs" id="browseCollectionContent">
			<div data-ng-class="{'wizardLayout' : wizardLayout === 'true'}">
			<div class="bootstrap-wrapper form-horizontal modal-margin padding-bottom-0" data-ng-class="{'margin-bottom-0 margin-top-10' : wizardLayout === 'true'}">
				<div class="form-group" data-ng-if="!hideGrouping">
					<label class="col-xs-12 col-md-4 col-lg-4" for="vmBrowseView">{{browseSelectionLabel}}</label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<isteven-multi-select id="browseCollectionContent_isteven-multi-select_#0847"
							input-model="treeData.contentBrowseViewOptions"
							output-model="selectedBrowseOption"
							button-label="displayName"
							item-label="displayName"
							tick-property="selected"
							selection-mode="single"
							class="isteven-multi-select user-group-select single-select"
							helper-elements="None"
							translation="localLang"
							on-item-click="browseOptionChanged(selectedBrowseOption)">
						</isteven-multi-select>
					</div>
				</div>

				<!-- // data-ng-if="serverVendor==='AMAZON'" // -->
				<div class="form-group" data-ng-if="serverVendor==='AMAZON'">
					<div class="col-xs-12">
						<input name="instanceNameId" id="instanceNameId" type="checkbox" data-ng-model="model.showInstanceNameIdSelection" data-ng-change="showInstanceName()" />
						<label for="instanceNameId"><cv:msg key="label.showVMInstanceId" bundle="browse" /></label>
					</div>
				</div>

				<div class="form-group" data-ng-if="!hideSearch || hideSearch === 'false'" data-ng-class="{'margin-bottom-0' : wizardLayout === 'true'}">
					<div class="col-xs-12" data-ng-class="{'col-sm-6' : wizardLayout === 'true'}">
						<div class="search-widget-wrapper form-control-search-wrapper"
							data-ng-class="{'margin-top-0 margin-left-0 float-left' : wizardLayout === 'true'}" >
						     <input class="search-field form-control-search-field" type="search" placeholder="{{searchFieldLabel}}" data-ng-model="search" data-ng-keypress='searchVMList(search, $event)' />
						     <span data-ng-click="search='';searchVMList(search, $event);" class="form-control-clear glyphicon glyphicon-remove form-control-feedback" title="<cv:msg key="label.clear" bundle="messages"/>"></span>
					    </div>
					</div>
					<div class="col-xs-12 col-sm-6">
						<div data-ng-if="wizardLayout === 'true'" data-ng-include="'vmSelection'"/>
					</div>
				</div>

			</div>

			    <span class="error"	data-ng-show="showContentWarning() && serverType !== 'KUBERNETES'">
						 {{getNoInstanceErrorMessage('error.noInstanceSelected')}}
				</span>

				 <span class="error"	data-ng-show="showContentWarning() && serverType === 'KUBERNETES'">
						 {{getNoInstanceErrorMessage('error.noInstanceSelectedKUBERNETES')}}
				</span>


				<div class="browse-tree select-vms">
					<div class="browse-item" data-ng-if="noSearchResult">
						<p><cv:msg key="label.noResultsFound" bundle="messagesJs"/></p>
					</div>
					<div data-ng-if="wizardLayout !== 'true'" data-ng-include="'vmSelection'"></div>
			    	<div ng-hide="serverMessage.message" data-ng-repeat="item in treeData.tree.children" class="browse-item" data-ng-include="'tree_item_renderer.html'"></div>
				</div>
 			</div>
	</div>
</fmt:bundle>