<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.scheduleJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<fmt:setBundle basename="localization.servers" var="servers"/>
<fmt:bundle basename="localization.schedule">
	<div ng-controller="backupOptionsController">
		<div class="setup-title">
			<h1><cv:msg key="header.backupOptions" bundle="servers"/></h1>
		</div>
		<div class="setup-content backup-options">
			<!-- <p class="setupInfo"><fmt:message key="label.setupInfo" /></p> -->
			<span class="{{serverMessage.type}} serverMessage no-margin">{{serverMessage.message}}</span>
			<span data-ng-show="!backupMsg">
				<label data-ng-if="subclientName"><cv:msg key="info.backupSubclient" bundle="servers"/> : &nbsp;<b>{{subclientName}}</b></label>
				<!-- <div class="global-options remove-border-padding">
					<label><cv:msg key="label.backupLevel" bundle="servers"/></label>
				</div> -->
				<div class="global-options remove-border-padding">
					<label data-ng-disabled="hideOption || isClientDeconfigured" data-ng-hide="hideFullBackupLevel">
						<input type="radio" ng-model="backupType" value="FULL" >
						<span><fmt:message key="option.full" /></span>
					</label>
					<label data-ng-disabled="isClientDeconfigured">
						<input  type="radio" ng-model="backupType" value="INCREMENTAL">
						<fmt:message key="option.incremental" />
					</label>
					<cv:comp name="show.synthFull">
						<label data-ng-disabled="hideOption" data-ng-hide="hideSynthFull">
							<input type="radio" ng-model="backupType" value="SYNTHETIC_FULL">
							<span ><fmt:message key="option.synthfull" /></span>
						</label>
					</cv:comp>
				</div>
				<div class="global-options remove-border-padding padding-top-10">
					<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
				</div>
				<!-- <cv:comp name="show.granularRecovery">
					<div class="global-options remove-border-padding" data-ng-hide="hideGranularRecovery">
						<div class="collectMetaDiv">
							<input id="backupOptionCollectMetadata" data-ng-model="collectMetadata" type="checkbox">
							<label for="backupOptionCollectMetadata"><fmt:message key="option.enableGranularRecovery" /></label>
						</div>
					</div>
				</cv:comp> -->
			</span>
			<div class="button-container">
				<fmt:bundle basename="localization.messages">
					<button id="backupOptionsModal_button_#7248" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-show="!backupMsg" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
			  		<button id="backupOptionsModal_button_#0595" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-show="backupMsg" data-ng-click="cancel()"><fmt:message key="OK" /></button> 
			  		<button id="backupOptionsModal_button_#4865" type="button" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" data-ng-show="!backupMsg" data-ng-click="startBackup(collectionId)"><fmt:message key="OK" /></button> 
			  	</fmt:bundle>
			</div>
		</div>
	</div>
</fmt:bundle>