<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.${param.vendor}"></cv:cvMessages>
</script>
<cv:bundle override="${param.vendor}"/>
<fmt:setBundle basename="localization.messages" var="messages" />
<fmt:bundle basename="localization.servers">
	<div data-ng-if="customizeForMetallic" class="wizard-step-header">
		<h2><cv:msg key='pageHeader.addServer' bundle='servers' /></h2>
        <p><cv:msg key='label.addServerHelpText' bundle='servers' /></p>
	</div>
	<div data-ng-if="!customizeForMetallic">
		<div class="setup-title" data-ng-hide="goToCollection || isAmazonHostedCS">
			<h1 data-ng-if="!forCloudAccount">
				<cv-help-text help-label="<cv:msg key='pageHeader.addServer' bundle='servers' />" help-text="'<cv:msg key='label.addServerHelpText' bundle='servers' />'" use-icon=true />
			</h1>
			<h1 data-ng-if="forCloudAccount">
				<cv:msg key='label.addCloudAccount' bundle='capps' />
			</h1>
		</div>
		<div class="setup-title" data-ng-if="isAmazonHostedCS">
			<h1>
			<fmt:message key="label.addAwsAccount" />
			</h1>
		</div>
	</div>
	<div class="setup-content medium-width" data-ng-controller="addServerController" data-ng-class="{'wizard-step-body' : customizeForMetallic}">
		<p>
			<span class="{{addServerMessage.type}} serverMessage no-margin">{{addServerMessage.message}}</span>
			<span data-ng-if="ctrl.proxyError && !model.isCSProxy && !model.isSqlCloud && model.vendorType !== 'KUBERNETES'" class="serverMessage"><cv:msg key="label.createProxy" bundle="serversJs" /> <a href="{{downloadLink}}" target="_blank"><cv:msg key="label.here" bundle="messagesJs" /></a>.</span>
		</p>
		<p class="serverMessage {{serversPresentMessage.type}}">{{serversPresentMessage.message}}</p>
		<p class="text-center"><a data-ng-click="changeAddServer()" data-ng-show="formAddServer.hide"><fmt:message key="label.addMore" /></a></p>
		<form name="addServerForm" novalidate data-cv-submit="addServer()" autocomplete="off" data-ng-hide="goToCollection || formAddServer.hide" class="bootstrap-wrapper form-horizontal padding-bottom-0">
			<div class="panel panel-default">
				<div class="panel-body">
					<div class="form-group" data-ng-if="showVendorType()">
						<label class="col-xs-12 col-md-4 col-lg-4" for="vendorType"><fmt:message key="label.vendorType" /></label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<div data-ng-disabled="nodes && model.selectedVendor[0].value =='MICROSOFT'">
								<isteven-multi-select id="addServerContent_isteven-multi-select_#8657"
									input-model="model.vendorTypes"
									output-model="model.selectedVendor"
									button-label="name"
									item-label="icon name"
									directive-id="vendorType"
									tick-property="selected"
									selection-mode="single"
									class="isteven-multi-select user-group-select single-select"
									name="vendorType"
									helper-elements="filter"
									search-limit="10"
									max-labels="1"
									translation="localLang"
									on-item-click="changeStepsByVendor()">
								</isteven-multi-select>
							</div>
						</div>
					</div>

					<div  data-ng-if="model.vendorType === 'VCLOUD'" data-ng-hide="!showvCloudTenantClientConfiguration || disablevCloudTenantAccount">
	                   <div class="form-group" data-ng-click="togglevCloudTenantAccount(disablevCloudTenantAccount)">
							<div class="col-xs-1 col-md-1 col-lg-1">
								<toggle-control
									disabled="disablevCloudTenantAccount"
									status="model.enablevCloudTenantAccount ? 'enabled-activity' : 'disabled-activity'">
								</toggle-control>
							</div>
							<label class="col-xs-11 col-md-11 col-lg-11" for="enablevCloudTenantAccount">
								<cv-help-text help-label="<cv:msg key="label.vCloudTenantAccount" bundle="servers"/>"
									help-text="'<cv:msg key='info.vCloudTenantAccountWarning' bundle="servers"/>'">
								</cv-help-text>
							</label>
						</div>

					</div>
					<div class="form-group" data-ng-if="model.vendorType!='AMAZON' && !model.isAzure() && model.vendorType!='GOOGLE_CLOUD' && model.vendorType!='ORACLE_CLOUD_INFRASTRUCTURE' && model.vendorType!='ALIBABA_CLOUD' && !model.enablevCloudTenantAccount">
						<label class="col-xs-12 col-md-4 col-lg-4" for="hostname">{{hostNameText}}</label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<input type="text" name="hostname" id="hostname" data-ng-model="model.hostname" required data-ng-change="clearEndpointErrMsg()" data-ng-disabled="nodes && model.vendorType=='MICROSOFT'" data-ng-class="{'temporary-disabled' : nodes && model.vendorType=='MICROSOFT'}" />
							<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.hostname) || showError">{{hostNameTextError}}</span>
							<span class="help-block" data-ng-if="invaliClientName" data-ng-bind="invaliClientName.message"></span>
						</div>
					</div>
					<!-- data-ng-show here -->
					<div class="form-group" data-ng-if="model.vendorType!='AMAZON' && model.vendorType!='GOOGLE_CLOUD' && model.vendorType!='ORACLE_CLOUD_INFRASTRUCTURE'">
						<label class="col-xs-12 col-md-4 col-lg-4" for="serverName">{{serverNameText}}</label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<input type="text" autocomplete="off" name="serverName" id="serverName" data-ng-model="model.serverName" data-ng-pattern="serverPattern" required data-ng-disabled="nodes && model.vendorType=='MICROSOFT'" data-ng-class="{'temporary-disabled' : nodes && model.vendorType=='MICROSOFT'}" />
							<span class="help-block" data-ng-show="addServerForm.serverName.$error.required && cv.addServerForm.needsAttention(addServerForm.serverName)">
								<span data-ng-if="!$parent.forCloudAccount" data-ng-bind="serverNameError"></span>
								<span data-ng-if="$parent.forCloudAccount"><cv:msg key="error.cloudAccountName" bundle="capps"/> </span>
							</span>
							<span class="help-block" data-ng-show="addServerForm.serverName.$error.pattern &&cv.addServerForm.needsAttention(addServerForm.serverName)" >{{serverInvalidText}}</span>
						</div>
					</div>
					<div class="form-group" data-ng-if="model.vendorType=='AMAZON' && !isAmazonHostedCS">
						<label class="col-xs-12 col-md-4 col-lg-4" for="serverName2">
							<span data-ng-if="!$parent.forCloudAccount"><fmt:message key="label.clientName" /> </span>
							<span data-ng-if="$parent.forCloudAccount">{{serverNameText}}</span>
						</label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<input type="text" autocomplete="off" name="serverName" id="serverName2" data-ng-model="model.serverName" required focus-on-field="focusText" />
							<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.serverName)">
								<span data-ng-if="!$parent.forCloudAccount"><fmt:message key="error.clientName" /> </span>
								<span data-ng-if="$parent.forCloudAccount"><cv:msg key="error.cloudAccountName" bundle="capps"/> </span>
							</span>
						</div>
					</div>
					<%--For Azure Stack --%>
						<div class="form-group" data-ng-if="model.vendorType =='AZURE_STACK'">
							<label class="col-xs-12 col-md-4 col-lg-4" for="vendor-type"><fmt:message key="label.authType" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<isteven-multi-select id="addServerContent_isteven-multi-select_#9745"
									input-model="model.azureAuthTypes"
									output-model="model.selectedAuthType"
									button-label="name"
									item-label="name"
									directive-id="authType"
									tick-property="selected"
									selection-mode="single"
									class="isteven-multi-select user-group-select single-select"
									name="authType"
									helper-elements="None"
									max-labels="1"
									translation="authTypelocalLang"
									on-item-click="changeAuthType()">
								</isteven-multi-select>
							</div>
						</div>
						<div class="form-group" data-ng-if="model.vendorType=='AMAZON' && isAmazonHostedCS">
							<label class="col-xs-12 col-md-4 col-lg-4" for="serverName"><fmt:message key="label.awsAccountName" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input autocomplete="off" type="text" name="serverName" id="serverName" data-ng-model="model.serverName" required focus-on-field="focusText" />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.serverName)"><fmt:message key="error.awsAccountName" /></span>
							</div>
						</div>
						<div class="form-group" data-ng-if="model.vendorType =='AZURE_STACK'">
							<label class="col-xs-12 col-md-4 col-lg-4" for="serverName"><fmt:message key="label.resourceMgrUrl" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" name="resourceMgrUrl" id="resourceMgrUrl" data-ng-model="model.resourceMgrUrl" required />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.resourceMgrUrl)"><fmt:message key="error.resourceMgrUrl" /></span>
							</div>
						</div>
								<!-- For Azure RM we have addition field MSI ,based on which we show /hide fields.If MSI is selected just show Subscription Id -->
					<div class="form-group" data-ng-click="model.msiId = !model.msiId"
						data-ng-if="model.vendorType =='AZURE_V2' && !enableCredentialManagerForCloudAccount">
						<div class="col-xs-12 col-md-5 col-lg-12">
							<toggle-control id="toggle"
								status="model.msiId ? 'enabled-activity' : 'disabled-activity'"></toggle-control>
							&nbsp;<cv:msg key="label.managedSvcIdentity" bundle="servers" />
						</div>
					</div>
					<div class="form-group" data-ng-if="model.isAzure()">
							<label class="col-xs-12 col-md-4 col-lg-4" for="subscriptionId"><fmt:message key="label.subscriptionId" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" name="subscriptionId" id="subscriptionId" data-ng-model="model.subscriptionId" required />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.subscriptionId)"><fmt:message key="error.subscriptionId" /></span>
							</div>
						</div>
						<div class="form-group" data-ng-if="!enableCredentialManagerForCloudAccount && (isMSIDUnselected() || isAzureAD())">
							<label class="col-xs-12 col-md-4 col-lg-4" for="tenantId"><fmt:message key="label.tenantId" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" name="tenantId" id="tenantId" data-ng-model="model.tenantId" required />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.tenantId)"><fmt:message key="error.tenantId" /></span>
							</div>
						</div>
						<div class="form-group" data-ng-if="!enableCredentialManagerForCloudAccount && (isMSIDUnselected() || model.vendorType=='AZURE_STACK')">
							<label class="col-xs-12 col-md-4 col-lg-4" for="applicationId"><fmt:message key="label.applicationId" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" name="applicationId" id="applicationId" data-ng-model="model.applicationId" required />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.applicationId)"><fmt:message key="error.applicationId" /></span>
							</div>
						</div>
					<!--  End Azure -->
					<!-- fake fields are a workaround for chrome autofill getting the wrong fields and filling it with login credentials for add Server-->
					<!-- setting display to none for text/password fields with matching field name to avoid chrome browser to autofill in it -->
					<input style="display:none" type="text" name="vsUserName" />
					<input style="display:none" type="text" name="accessKey" />
					<input style="display:none" type="text" name="domainName" />
					<input style="display:none" type="text" name="p12KeyFileName" />
					<input style="display:none" type="text" name="privateKeyFileName" />
					<input style="display:none" type="text" name="regionName" />
					<input style="display:none" type="text" name="regionEndPoints" />
					<input style="display:none" type="password" name="vsPassword" autocomplete="new-password"  />
					<input style="display:none" type="password" name="thumbprint" autocomplete="new-password" />
					<input style="display:none" type="password" name="applicationPassword" autocomplete="new-password"  />
					<input style="display:none" type="password" name="secretKey" autocomplete="new-password"  />
					<input style="display:none" type="password" name="privateKeysPassword" autocomplete="new-password" />
                  <div data-ng-if="model.vendorType =='VMW'||model.vendorType =='MICROSOFT' || enableCredentialManagerForCloudAccount">
		            <cv-credential-manager model="model" show-credential="{{showCredential}}" input-name="vsCredentials" password-complexity="1" form-name="addServerForm" need-confirm=false></cv-credential-manager>
		            </div>
		            <!-- Start of kubernetes -->
						<div class="form-group" data-ng-if="model.vendorType === 'KUBERNETES'" required>
							<label id="authentication" class="col-xs-12 col-md-4 col-lg-4" for="authentication"><cv:msg key="label.authentication" bundle="settings"/></label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<isteven-multi-select data-ng-class="select" id="authenticationType"
									data-input-model="model.kubernetesAuthTypes"
									data-output-model="model.selectedKubernetesAuthenticationType"
									data-tick-property="checked"
									item-label="name"
									data-button-label="name"
									data-search-property="name"
									helper-elements="filter showSelected"
									class="isteven-multi-select user-group-select modal-right"
									translation="localLangKubernetes"
									data-selection-mode="single"
									on-close="onAuthentcationTypeSelection()">
									</isteven-multi-select>
									<span class="help-block" data-ng-show="showAuthError" data-ng-bind="authenticationErr"></span>
								</div>
						</div>
						<div class="form-group" data-ng-if="model.selectedKubernetesAuthenticationType[0].id === 2">
							<label class="col-xs-12 col-md-4 col-lg-4" for="configFile"><cv:msg key="label.configFile" bundle="kubernetes"></cv:msg></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
							<span class="btn btn-default btn-file btn-file-fullWidth"> <span
								class="btn-text sshKeyFileName" data-ng-bind="fileName"></span>
								<cv-file-input file-input="file" on-change="fileUpload(file)"></cv-file-input>
								</span>
								<span class="help-block" data-ng-if="showConfigError" data-ng-bind="configAuthenticationErr"></span>
							</div>
						</div>
						<!-- End of Kubernetes -->

						<!-- Tenant configuration of vCloud Director -->
						<div data-ng-hide="!showvCloudTenantClientConfiguration">
							<div data-ng-if="model.enablevCloudTenantAccount">
								<div class="form-group">
									<label class="col-xs-12 col-md-4 col-lg-4" for="vendorType"><fmt:message key="label.vendor.vcloud" /></label>
									<div class="col-xs-12 col-md-8 col-lg-8">
											<isteven-multi-select
												input-model="model.vCloudInstances"
												output-model="model.vCloudAdminInstance"
												button-label="displayName"
												directive-id="AdminAccount"
												item-label="displayName"
												id="vCloudAdminInstance"
												tick-property="selected"
												selection-mode="single"
												class="isteven-multi-select user-group-select single-select"
												helper-elements="filter"
												search-limit="10"
												max-labels="1"
												translation="localLang"
												on-item-click="loadOrgList()">
											</isteven-multi-select>
									</div>
								</div>
								<div data-ng-if="entityCapabilities.agentManagementCapability" >
									<div class="form-group">
										<label class="col-xs-12 col-md-4 col-lg-4" for="vendorType"><fmt:message key="label.organization" /></label>
										<div class="col-xs-12 col-md-8 col-lg-8">
												<isteven-multi-select
													input-model="orgList"
													output-model="vCloud.organization"
													button-label="displayName"
													directive-id="TenantOrg"
													item-label="displayName"
													id="organization"
													tick-property="selected"
													selection-mode="single"
													class="isteven-multi-select user-group-select single-select"
													helper-elements="filter"
													search-limit="10"
													max-labels="1"
													translation="localLang"
													on-item-click="isOrgSelected()">
												</isteven-multi-select>
										</div>
									</div>
								</div>
							</div>
						</div>
						<!-- End Tenant configuration of vCloud Director -->

					<div class="form-group" data-ng-if="!isCustomVendor() && !isEnableMSPOrgMode()">
						<label class="col-xs-12 col-md-4 col-lg-4" for="vsUserName">{{userNameText}}</label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<input type="text" name="vsUserName" id="vsUserName" data-ng-model="model.vsUserName" required autoCompleteType="disable" autocomplete="new-password" data-ng-disabled="nodes && model.vendorType=='MICROSOFT'" data-ng-class="{'temporary-disabled' : nodes && model.vendorType=='MICROSOFT'}" />
							<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.vsUserName) || showError">{{userNameTextError}}</span>
						</div>
					</div>
					<div class="form-group" data-ng-if="model.vendorType=='OPENSTACK'">
						<label class="col-xs-12 col-md-4 col-lg-4" for="domainName"><fmt:message key="label.openstackDomain" /> <span class="optional-text"><cv:msg key="label.optional" bundle="restore" /></span></label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<input type="text" name="domainName" id="domainName" data-ng-model="model.domainName" />
						</div>
					</div>
					<div class="form-group" data-ng-if="!isCustomVendor() && !isEnableMSPOrgMode()">
						<label class="col-xs-12 col-md-4 col-lg-4" for="vsPassword"><fmt:message key="label.password" /></label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<input type="password" name="vsPassword" id="vsPassword" data-ng-model="model.vsPassword" required autoCompleteType="disable" autocomplete="new-password" data-ng-disabled="nodes && model.vendorType=='MICROSOFT'" data-ng-class="{'temporary-disabled' : nodes && model.vendorType=='MICROSOFT'}" />
							<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.vsPassword) || showError"><fmt:message key="error.password" /></span>
						</div>
					</div>
					<!--  For Azure -->
						<div class="form-group" data-ng-if="model.vendorType==='AZURE' || (model.vendorType==='AZURE_STACK' && model.selectedAuthType[0].value ==='azureADFS' )">
							<label class="col-xs-12 col-md-4 col-lg-4" for="thumbprint"><fmt:message key="label.thumbprint" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="password" name="thumbprint" id="thumbprint" data-ng-model="model.thumbprint"  required autoCompleteType="disable" autocomplete="new-password" />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.thumbprint) || showError"><fmt:message key="error.thumbprint" /></span>
							</div>
						</div>
						<div class="form-group" data-ng-if="!enableCredentialManagerForCloudAccount && (isMSIDUnselected() || isAzureAD())">
							<label class="col-xs-12 col-md-4 col-lg-4" for="applicationPassword"><fmt:message key="label.applicationPassword" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="password" name="applicationPassword" id="applicationPassword" data-ng-model="model.applicationPassword" required autoCompleteType="disable" autocomplete="new-password" />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.applicationPassword) || showError"><fmt:message key="error.applicationPassword" /></span>
							</div>
						</div>
					<!--  End Azure -->

                    <!---Currently comapny supports for vCloud Director only--->
					<div data-ng-if="isOrgAvailable && model.enablevCloudTenantAccount">
						<div class="form-group">
							<label class="col-xs-12 col-md-4 col-lg-4" for="company_#100"><cv-help-text help-label="<cv:msg key="label.company" bundle="servers"/>"
								help-text="'<cv:msg key='info.company' bundle="servers"/>'">
							</cv-help-text></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<span uib-dropdown class="uib-dropdown select-label" on-toggle="toggled(open)" style="position: initial;">
									<span class="uib-dropdown-toggle" uib-dropdown-toggle>
											<input style="cursor: pointer;" title="" type="text" id="company_#100" name="company" data-ng-model="model.company" data-ng-change="updateCompanyName(null)" autocomplete="off"/>
									 </span>
									<ul uib-dropdown-menu class="dropdown-menu" style="margin-right: 15px;">
										 <li data-ng-repeat="company in companyArray" data-ng-click="updateCompanyName(company)"><a title="{{company.name}}" href="javascript:void(0);">{{company.name}}</a></li>
									</ul>
								</span>
								<!--<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.company)"><fmt:message key="error.company" /></span>-->
							</div>
						</div>
					</div>
                    <!---End comapny ---->

					<!-- For Amazon Server-->
					<div data-ng-if="model.vendorType==='AMAZON'">
						<div class="form-group">
							<label class="col-xs-12 col-md-4 col-lg-4" for="regionEndPoints">
								<cv-help-text help-text="'<cv:msg key='info.regionEndPointsHelpText' bundle='servers'/>'"
									help-label="<cv:msg key="label.regionEndPoints" bundle="servers" />" help-placement="right"></cv-help-text>
								<span class="optional-text"><cv:msg key="label.optional" bundle="restore"/></span>
							</label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" name="regionEndPoints" id="regionEndPoints" data-ng-model="model.regionName" />
							</div>
						</div>
						<h4><cv:msg key="label.authentication" bundle="settings" /></h4>
						<div class="form-group">
							<div class="col-xs-12">
								<div class="multiple-radio-group">
									<label for="authentication1"><input type="radio" data-ng-model="model.authenticationType" value="IAMRole" name="authenticationType" id="authentication1" data-ng-change="changeAuthenticationTypeForAmazon()" />
									<span class="block-indent"><cv:msg key="label.IAMRole" bundle="servers" /></span></label>
								</div>
								<div class="multiple-radio-group">
									<label for="authentication2"><input type="radio" data-ng-model="model.authenticationType" value="AccessAndSecretKey" name="authenticationType" id="authentication2" data-ng-change="changeAuthenticationTypeForAmazon()" />
									<span class="block-indent"><cv:msg key="label.AccessSecretKey" bundle="servers" /></span></label>
								</div>
								<div class="multiple-radio-group">
									<label for="authentication3"><input type="radio" data-ng-model="model.authenticationType" value="STSRole" name="authenticationType" id="authentication3" data-ng-change="changeAuthenticationTypeForAmazon()" />
									<span class="block-indent"><cv:msg key="label.STSRole" bundle="servers" /></span></label>
								</div>
							</div>
						</div>
						<div class="form-group" data-ng-hide="enableCredentialManagerForCloudAccount || model.authenticationType==='IAMRole' || model.authenticationType==='STSRole'">
							<label class="col-xs-12 col-md-4 col-lg-4" for="accessKey"><cv:msg key="label.accessKey" bundle="servers" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" name="accessKey1" id="accessKey1" data-ng-model="model.accessKey" data-ng-required="model.authenticationType==='AccessAndSecretKey'" />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.accessKey1) || showError"><cv:msg key="error.accessKey" bundle="servers" /></span>
							</div>
						</div>
						<div class="form-group" data-ng-hide="enableCredentialManagerForCloudAccount || model.authenticationType==='IAMRole' || model.authenticationType==='STSRole'">
							<label class="col-xs-12 col-md-4 col-lg-4" for="secretKey"><cv:msg key="label.secretKey" bundle="servers" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="password"
										name="secretKey"
										id="secretKey"
										data-ng-model="model.secretKey"
										data-ng-required="!enableCredentialManagerForCloudAccount && model.authenticationType==='AccessAndSecretKey'"
										autoCompleteType="disable" autocomplete="new-password"
										data-ng-disabled="model.authenticationType==='IAMRole' || model.authenticationType==='STSRole'" />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.secretKey) || showError"><cv:msg key="error.secretKey" bundle="servers" /></span>
							</div>
						</div>
						<div class="form-group" data-ng-hide="enableCredentialManagerForCloudAccount || model.authenticationType==='IAMRole' || model.authenticationType==='AccessAndSecretKey'">
							<label class="col-xs-12 col-md-4 col-lg-4" for="accessKey"><cv:msg key="label.roleArn" bundle="servers" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" name="accessKey2" id="accessKey2" data-ng-model="model.accessKey" data-ng-required="model.authenticationType==='STSRole'" />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.accessKey2) || showError"><cv:msg key="error.roleArn" bundle="servers" /></span>
							</div>
						</div>
						<!-- AWS Admin cross account -->
						<div>
							<div class="form-group" data-ng-if="!isSqlAmazon && (!enableCredentialManagerForCloudAccount || 
							(model.selectedCredential && model.selectedCredential.length > 0 && model.credentialRecordType && model.credentialRecordType[model.selectedCredential[0].credentialName] !== 'AMAZON_IAM_ROLE'))">
								<div class="col-xs-1 col-md-1 col-lg-1">
									<toggle-control data-ng-click="toggleAmazonAdminAccount(disableAmazonAdminAccount || !enableCredentialManagerForCloudAccount && model.authenticationType==='IAMRole')"
										disabled=" (disableAmazonAdminAccount || !enableCredentialManagerForCloudAccount && model.authenticationType==='IAMRole')"
										status="model.enableAdminAccount ? 'enabled-activity' : 'disabled-activity'">
									</toggle-control>
								</div>
								<label class="col-xs-10 col-md-4 col-lg-4" for="enableAWSAdminAccount" data-ng-click="toggleAmazonAdminAccount(disableAmazonAdminAccount || !enableCredentialManagerForCloudAccount && model.authenticationType==='IAMRole')">
									<cv-help-text help-label="<cv:msg key="label.enableAWSAdminAccount" bundle="servers"/>"
										help-text="'<cv:msg key='info.awsAdminAccountWarning' bundle="servers"/>'">
									</cv-help-text>
								</label>
								<div class="col-xs-1 col-md-7 col-lg-7">
								</div>
							</div>
							<div class="form-group" data-ng-hide="!model.enableAdminAccount">
								<label class="col-xs-12 col-md-4 col-lg-4" for="awsAdminInstance"><cv:msg key="label.account" bundle="servers" /></label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<isteven-multi-select
										input-model="model.awsInstances"
										output-model="model.adminInstance"
										button-label="displayName"
										directive-id="AdminAccount"
										item-label="displayName"
										id="awsAdminInstance"
										tick-property="selected"
										selection-mode="single"
										class="isteven-multi-select user-group-select single-select"
										helper-elements="filter"
										search-limit="10"
										max-labels="1"
										translation="localLang">
									</isteven-multi-select>
								</div>
							</div>
						</div>
					</div><!-- // end data-ng-if="model.vendorType==='AMAZON'"  // -->
					<!-- End Amazon Server-->
					<!-- For AliBaba Cloud -->
						<div class="form-group" data-ng-if="model.vendorType=='ALIBABA_CLOUD'">
							<label class="col-xs-12 col-md-4 col-lg-4" for="accessKey"><fmt:message key="label.accessKey" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" name="accessKey" id="accessKey" data-ng-model="model.accessKey" required />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.accessKey) || showError"><fmt:message key="error.accessKey" /></span>
							</div>
						</div>
						<div class="form-group" data-ng-if="model.vendorType=='ALIBABA_CLOUD'">
							<label class="col-xs-12 col-md-4 col-lg-4" for="secretKey"><fmt:message key="label.secretKey" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="password" name="secretKey" id="secretKey" data-ng-model="model.secretKey"  required autoCompleteType="disable" autocomplete="new-password" />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.secretKey) || showError"><fmt:message key="error.secretKey" /></span>
							</div>
						</div>
					<!-- AliBaba Cloud Ends -->
					<!-- For Google Cloud-->
					<div data-ng-if="model.vendorType=='GOOGLE_CLOUD'">
						<div class="form-group">
							<label class="col-xs-12 col-md-4 col-lg-4" for="clientName">
								<span data-ng-if="!$parent.forCloudAccount"><cv:msg key="label.clientName" bundle='servers'/> </span>
								<span data-ng-if="$parent.forCloudAccount">{{serverNameText}}</span>
							</label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" id="clientName" name="clientName" data-ng-model="model.serverName" required />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.clientName)">
									<span data-ng-if="!$parent.forCloudAccount"><cv:msg key="error.hostName" bundle='servers'/> </span>
									<span data-ng-if="$parent.forCloudAccount"><cv:msg key="error.cloudAccountName" bundle="capps"/> </span>
								</span>
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-md-4 col-lg-4" for="serviceAccountID"><cv:msg key="label.serviceAccountId" bundle='servers' /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" id="serviceAccountID" name="serviceAccountID" data-ng-model="model.subscriptionId" placeholder="user@project.iam.gserviceaccount.com" required />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.serviceAccountID)"><cv:msg key="error.serviceAccountId" bundle='servers'/></span>
							</div>
						</div>
						<div class="form-group" >
							<label class="col-xs-12 col-md-4 col-lg-4" for="jsonFilePath"><cv:msg key="label.jsonFilePath" bundle='servers'/></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<span class="btn btn-default btn-file btn-file-fullWidth">
									<span class="btn-text sshKeyFileName" data-ng-bind="fileName"></span>
									<cv-file-input id="jsonFilePath" file-input="file" on-change="fileUpload(file)"></cv-file-input>
								</span>
								<span class="help-block" data-ng-show="showjsonKeyError" data-ng-bind="jsonKeyError" ></span>
							</div>
						</div>
					</div>
					<!--End Google Cloud -->
					<!-- For Oracle Cloud Infrastructure-->
					<div data-ng-if="model.vendorType=='ORACLE_CLOUD_INFRASTRUCTURE'">
						<div class="form-group">
							<label class="col-xs-12 col-md-4 col-lg-4" for="serverName"><fmt:message key="label.serverName" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" name="serverName" id="serverName" data-ng-model="model.serverName" required />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.serverName)"><fmt:message key="error.serverName" /></span>
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-md-4 col-lg-4" for="tenancyOcid"><fmt:message key="label.tenancyOcid" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" name="tenancyOcid" id="tenancyOcid" data-ng-model="model.tenantId" required />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.tenancyOcid)"><fmt:message key="error.tenancyOcid" /></span>
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-md-4 col-lg-4" for="userOcid"><fmt:message key="label.userOcid" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" name="userOcid" id="userOcid" data-ng-model="model.userId" required />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.userOcid)"><fmt:message key="error.userOcid" /></span>
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-md-4 col-lg-4" for="fingerPrint"><fmt:message key="label.fingerPrint" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" name="fingerPrint" id="fingerPrint" data-ng-model="model.fingerPrint" required />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.fingerPrint)"><fmt:message key="error.fingerPrint" /></span>
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-md-4 col-lg-4" for="privateKeyFileName">
								<cv-help-text help-label="label.privateKeyFileName" help-text="label.privateKeyFileNameHelpText" />
							</label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="text" name="privateKeyFileName" id="privateKeyFileName" data-ng-model="model.vsUserName" data-ng-pattern="privateKeyFileNamePattern" placeholder="<fmt:message key='placeholder.privateKeyFileName' />" required />
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.privateKeyFileName)"><fmt:message key="error.privateKeyFileName" /></span>
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-md-4 col-lg-4" for="privateKeysPassword">
								<cv-help-text help-label="label.privateKeysPassword" help-text="label.privateKeyFilePasswordHelpText" />
								<span class="optional-text"><cv:msg key="label.optional" bundle="restore"/></span>
							</label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<input type="password" name="privateKeysPassword" id="privateKeysPassword" data-ng-model="model.vsPassword" autocomplete="new-password" />
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-md-4 col-lg-4" for="regionName"><fmt:message key="label.homeRegionName" /></label>
							<div class="col-xs-12 col-md-8 col-lg-8">
								<span uib-dropdown class="uib-dropdown select-label" on-toggle="toggled(open)" style="position: initial;">
									<span class="uib-dropdown-toggle" uib-dropdown-toggle>
											<input style="cursor: pointer;" title="" type="text" id="regionName" name="regionName" data-ng-model="model.regionName" data-ng-change="updateRegionName(null)" autocomplete="off" required />
									 </span>
									<ul uib-dropdown-menu class="dropdown-menu dropdown-regionlist-minwidth">
										 <li data-ng-repeat="region in ociRegionList" data-ng-click="updateRegionName(region)"><a title="{{region.name}}" href="javascript:void(0);">{{region.name}}</a></li>
										</ul>
								</span>
								<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.regionName)"><fmt:message key="error.homeRegionName" /></span>
							</div>
						</div>
					</div>
					<!--End Oracle Cloud Infrastructure-->
					<!-- Red Hat OpenShift -->
					<div
						data-ng-if="model.vendorType === 'REDHAT_OPENSHIFT' || model.vendorType === 'KUBERNETES'">
						<div data-ng-if="model.vendorType === 'REDHAT_OPENSHIFT'">
							<h4>
								<cv:msg key="label.authentication" bundle="settings" />
							</h4>
							<div class="form-group">
								<div class="col-xs-12">
									<div class="multiple-radio-group">
										<label for="redHat1">
											<input name="radio" id="redHat1"
												value="{{model.redHatOpenShift.authTypes.UserName}}"
												type="radio" data-ng-model="model.authenticationType"
												data-ng-init="model.authenticationType = model.redHatOpenShift.authTypes.UserName" />
											<span class="block-indent">
												<cv:msg key="label.userNamePassword" bundle="serversJs" />
											</span>
										</label>
									</div>
									<div class="multiple-radio-group">
										<label for="redHat2">
											<input name="radio" id="redHat2"
												value="{{model.redHatOpenShift.authTypes.ServiceName}}"
												type="radio" data-ng-model="model.authenticationType" />
											<span class="block-indent">
												<cv:msg key="label.serviceNameToken" bundle="serversJs" />
											</span>
										</label>
									</div>
								</div>
							</div>
						</div>
						<div
							data-ng-show="model.authenticationType === model.redHatOpenShift.authTypes.UserName || model.selectedKubernetesAuthenticationType[0].id === 3">
							<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="vsUserName">
									<cv:msg key="label.userName" bundle="serversJs" />
								</label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<input type="text" name="vsUserName" id="vsUserName"
										data-ng-model="model.vsUserName"
										data-ng-required="model.authenticationType === model.redHatOpenShift.authTypes.UserName || model.selectedKubernetesAuthenticationType[0].id === 3"
										autoCompleteType="disable" />
									<span class="help-block"
										data-ng-show="cv.addServerForm.needsAttention(addServerForm.vsUserName)">{{userNameTextError}}</span>
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="vsPassword">
									<fmt:message key="label.password" />
								</label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<input type="password" name="vsPassword" id="vsPassword"
										data-ng-model="model.vsPassword"
										data-ng-required="model.authenticationType === model.redHatOpenShift.authTypes.UserName || model.selectedKubernetesAuthenticationType[0].id === 3"
										autoCompleteType="disable" />
									<span class="help-block"
										data-ng-show="cv.addServerForm.needsAttention(addServerForm.vsPassword)">
										<fmt:message key="error.password" />
									</span>
								</div>
							</div>
						</div>
						<div
							data-ng-show="model.authenticationType === model.redHatOpenShift.authTypes.ServiceName || model.selectedKubernetesAuthenticationType[0].id === 1">
							<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="serviceName">
									<cv:msg key="label.serviceName" bundle="serversJs" />
								</label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<input type="text" name="serviceName" id="serviceName"
										data-ng-model="model.redHatOpenShift.serviceName"
										data-ng-required="model.authenticationType === model.redHatOpenShift.authTypes.ServiceName || model.selectedKubernetesAuthenticationType[0].id === 1"
										autoCompleteType="disable" />
									<span class="help-block"
										data-ng-show="cv.addServerForm.needsAttention(addServerForm.serviceName)">
										<cv:msg key="error.specifyServiceName" bundle="serversJs" />
									</span>
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="serviceToken">
									<cv:msg key="label.serviceToken" bundle="serversJs" />
								</label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<input type="text" name="serviceToken" id="serviceToken"
										data-ng-model="model.redHatOpenShift.serviceToken"
										data-ng-required="model.authenticationType === model.redHatOpenShift.authTypes.ServiceName || model.selectedKubernetesAuthenticationType[0].id === 1"
										autoCompleteType="disable" />
									<span class="help-block"
										data-ng-show="cv.addServerForm.needsAttention(addServerForm.serviceToken)">
										<cv:msg key="error.specifyServicToken" bundle="serversJs" />
									</span>
								</div>
							</div>
						</div>
					</div>
					<!-- End Red Hat OpenShift -->
					<!--Change ng-if to ng-show as we want to load Proxies and sent to backend but not display them for KUBERNETES  -->
					<div class="form-group" data-ng-show="showProxy()"
						data-ng-class="{'hide-error':ctrl.proxyError && !model.isCSProxy}">
						<label data-ng-if="model.vendorType !== 'MICROSOFT' && !(isSqlAzure && model.msiId)"
							class="col-xs-12 col-md-4 col-lg-4" for="proxy1">
							<fmt:message key="label.accessNodes" />
						</label>

						<label class="col-xs-12 col-md-4 col-lg-4" for="proxy1"
							id="accessNodeLb" data-ng-if="isSqlAzure && model.msiId">
							<cv-help-text
								help-label="<cv:msg key="label.accessNodes" bundle="serversJs" />"
								help-text="'<cv:msg key="help.azureAccessNodes" bundle="sqlserver" />'"></cv-help-text>
						</label>

						<label data-ng-if="model.vendorType === 'MICROSOFT'"
							class="col-xs-12 col-md-4 col-lg-4" for="proxy1">
							<fmt:message key="label.proxyOld" />
						</label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<cv-select-proxy model="model" ctrl="ctrl"
								selection="{{model.selection}}" vendor="{{model.vendorType}}"
								id="proxy1" platform="{{model.platform}}"></cv-select-proxy>
							<span class="help-block"
								data-ng-show="(addServerForm.$submitted || createServerAttempted) && (ctrl.proxyError || !model.selectedProxy || !model.selectedProxy.length || model.selectedProxy.length < 1)">
								<fmt:message key="error.proxy" />
							</span>
						</div>
					</div>
					<div id="proxyConfigurationModal" class="{{configureOptionClass}}" data-ng-disabled="disableAccesNodeCreation" data-ng-if="showConfigureProxyOption">
									<a href="" id="openConfigureProxy" name="openConfigureProxyK8s" data-ng-click="checkRequiredInputs(model)">
										<cv:msg key="label.installProxy" bundle="serversJs" />
									</a>
					</div>
					<!--  SQL AZURE START-->
					<uib-accordion close-others="false" class="text-left"
						data-ng-if="model.isSqlCloud">
					<div uib-accordion-group is-open="openAccordionOfConnectionDetails"
						class="panel form-panel-holder" data-scroll-to-when-open>
						<uib-accordion-heading> <cv:msg
							key="title.connectionDetails" bundle="cloudStorageApp" /> <span
							class="optional-text">
							<cv:msg key="label.optional" bundle="users" />
						</span> <i class="float-right glyphicon"
							data-ng-class="{'glyphicon-chevron-down': openAccordionOfConnectionDetails, 'glyphicon-chevron-right': !openAccordionOfConnectionDetails}"></i>
						</uib-accordion-heading>

						<div class="form-group" data-ng-if="isSqlAmazon">
							<label class="col-xs-12 col-sm-5" for="s3BucketName">
								<cv:msg key="label.s3bucketName" bundle="sqlserver" />
							</label>
							<div class="col-xs-12 col-md-7">
								<input type="text" id="s3BucketName" name="s3BucketName"
									data-ng-required="false" data-ng-model="model.s3BucketName"
									placeholder="{{'<cv:msg key="error.s3bucketName" bundle="sqlserver" />'}}" />
								<span class="help-block" data-ng-show="error.s3BucketName">
									<cv:msg key="error.s3bucketName" bundle="sqlserver" />
								</span>
							</div>
						</div>
						<div class="form-group " data-ng-if="isSqlAzure">
							<label class="col-xs-12 col-sm-5"
								for="azureStorageConnectionString">
								<cv:msg key="label.azureStorageConnectionString"
									bundle="sqlserver" />
							</label>
							<div class="col-xs-12 col-sm-7">
								<textarea class="textarea" id="azureStorageConnectionString"
									name="azureStorageConnectionString" data-ng-required="false"
									data-ng-model="model.azureStorageConnectionString"
									placeholder="{{'<cv:msg key="error.azureStorageConnectionString" bundle="sqlserver" />'}}"></textarea>
								<span class="help-block"
									data-ng-show="error.azureStorageConnectionString">
									<cv:msg key="error.azureStorageConnectionString"
										bundle="sqlserver" />
								</span>
							</div>
						</div>

						<div class="form-group">
							<label class="col-xs-12 col-sm-5" for="dbUser">
								<cv:msg key="label.userName" bundle="servers" />
							</label>
							<div class="col-xs-12 col-sm-7">
								<input type="text" name="dbUser"
									data-ng-model="model.SAUser.userName" data-ng-required="false"
									placeholder="{{'<cv:msg key="error.userName" bundle="users" />'}}" />
								<span class="help-block" data-ng-show="error.userName">
									<cv:msg key="error.dbUser" bundle="postgres" />
								</span>
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-sm-5" for="dbPassword">
								<cv:msg key="label.dbPassword" bundle="postgres" />
							</label>
							<div class="col-xs-12 col-sm-7">
								<input type="password" name="dbPassword"
									data-ng-model="model.SAUser.password"
									placeholder="{{'<cv:msg key="error.password" bundle="users" />' }}" />
								<span class="help-block" data-ng-show="error.password">
									<cv:msg key="error.password" bundle="users" />
								</span>

							</div>
						</div>

						<div class="form-group">
							<label class="col-xs-12 col-sm-5" for="dbConfirmPassword">
								<cv:msg key="label.confirmPassword" bundle="servers" />
							</label>
							<div class="col-xs-12 col-sm-7">
								<input type="password" name="dbConfirmPassword"
									data-ng-model="model.SAUser.confirmPassword"
									placeholder="{{'<cv:msg key="error.confirmPassword" bundle="users" />' }}" />
								<span class="help-block" data-ng-show="error.confirmPassword">
									<cv:msg key="error.confirmPassword" bundle="users" />
								</span>
								<span class="help-block" data-ng-show="error.passwordMismatch">
									<cv:msg key="error.mismatchedPassword" bundle="users" />
								</span>
							</div>
						</div>
					</div>
					</uib-accordion>

					<!--  END SQL AZURE-->
					<!-- Gluster for Red Hat Open Shift -->
					<div id="redHatGlusterGrid" data-ng-if="model.vendorType === 'REDHAT_OPENSHIFT'">
						<div id="redHatGlusterHeader" class="form-group">
							<label for="openShiftGlusterAdd" class="col-xs-12">
								<cv:msg key="title.glusterHost" bundle="serversJs" />
								<span class="float-right">
									<a href="" id="openShiftGlusterAdd" name="openShiftGlusterAdd" data-ng-click="showOpenShiftGlusterModal(model.glusterHostCredentials)">
										<cv:msg key="label.add" bundle="restore" />
									</a>
								</span>
								<span class="help-block" data-ng-show="cv.addServerForm.getAttempted() && model.glusterHostCredentials.length == 0">
									<cv:msg key="error.gluster.add" bundle="serversJs"/>
								</span>
							</label>
						</div>
						<div id="redHatGlusterContents">
							<div class="filters-list-wrapper padding-left-0">
								<ul data-ng-repeat="gluster in model.glusterHostCredentials | orderBy track by $index">
									<li title="{{gluster.hostName}}">
										<label class="padding-left-0">
											<a data-ng-click="showOpenShiftGlusterModal(model.glusterHostCredentials, gluster)">
												{{gluster.credentials.userName}}@{{gluster.hostName}}
											</a>
											<span class="delete-row margin-right-0">
												<a data-ng-click="deleteOpenShiftGlusterRow(gluster)"
												title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{gluster.hostName}}">&times;</a>
											</span>
										</label>
									</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- Gluster for Red Hat Open Shift Ends -->
					<div class="form-group" data-ng-if="nodes && model.vendorType=='MICROSOFT'">
						<label class="col-xs-12 col-md-4 col-lg-4" for="node"><fmt:message key="label.proxy" /></label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<select multiple
								required
								data-ui-select2
								id="node"
								name="node"
								data-ng-model="model.node"
								data-ng-options="node.clientName for node in nodes"
								data-ng-class="{'has-error': cv.addServerForm.needsAttention(addServerForm.node) && model.vendorType=='MICROSOFT'}">
								<option value=""></option>
							</select>
							<span class="help-block" data-ng-show="cv.addServerForm.needsAttention(addServerForm.node) && model.vendorType=='MICROSOFT'"><fmt:message key="error.nodes" /></span>
						</div>
					</div>
					<!-- snap array details -->
					<div class="form-group" data-ng-if="showPlanInSnap">
						<label class="col-xs-12 col-md-4 col-lg-4" for="selectPlan"><fmt:message key="label.selectPlan" /></label>
						<div class="col-xs-12 col-md-8 col-lg-8">
							<select name="selectPlan"
								id="selectPlan"
								data-ng-options="plan.planSummary.plan.planId as plan.planSummary.plan.planName for plan in profileList | orderBy: 'planSummary.plan.planName'"
								data-ng-model="snap.plan">
								<option value=""><fmt:message key="label.selectPlan" /></option>
							</select>
						</div>
					</div>
					<!-- snap array details end -->
					<div data-ng-if="!customizeForMetallic" class="button-container">
						<button id="addServerContent_button_#8568" type="button" data-ng-if="(!nodes && model.vendorType=='MICROSOFT') || (model.vendorType!='MICROSOFT')" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()">
							<fmt:message key="Cancel" bundle="${messages}" />
						</button>
						<button id="addServerContent_button_#4909" type="button" data-ng-if="!nodes && model.vendorType=='MICROSOFT'" data-ng-class="{disabled:addServerForm.$invalid, busy:discoveredNodes}" class="btn btn-primary cvBusyOnAjax" data-ng-click="discoverNodes()">
							<fmt:message key="button.discover.nodes" />
						</button>
						<button id="addServerContent_button_#0923" type="button" data-ng-if="nodes && model.vendorType=='MICROSOFT'" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="back()">
							<fmt:message key="Back" bundle="${messages}" />
						</button>
						<button id="addServerContent_button_#0253" type="button" data-ng-if="isSetup && serversPresent && !showDoItLater" class="btn btn-default cvBusyOnAjax" data-ng-click="skip()">
							<fmt:message key="Skip" bundle="${messages}" />
						</button>
						<button id="addServerContent_button_#8643" type="button" data-ng-if="isSetup && showDoItLater" class="btn btn-default cvBusyOnAjax" data-ng-click="skip()">
							<cv:msg key="action.doItLater" bundle="profiles" />
						</button>
						<button id="addServerContent_button_#1409" data-ng-if="(nodes && model.vendorType=='MICROSOFT') || (model.vendorType!='MICROSOFT')" data-ng-disabled="(model.vendorType=='MICROSOFT' && (model.node==undefined || model.node.length <1))" data-ng-class="(model.vendorType=='MICROSOFT' && (model.node==undefined || model.node.length <1)) && 'disabled'" type="submit" class="btn btn-primary cvBusyOnAjax">
							<span data-ng-if="!showDoItLater && !isAmazonHostedCS && model.vendorType!='VCLOUD'"><fmt:message key="Save" bundle="${messages}" /></span>
							<span data-ng-if="(!showDoItLater && isAmazonHostedCS) || (model.vendorType=='VCLOUD' && !model.enablevCloudTenantAccount)"><fmt:message key="Next" bundle="${messages}" /></span>
							<span data-ng-if="model.vendorType=='VCLOUD' && model.enablevCloudTenantAccount"><fmt:message key="Create" bundle="${messages}" /></span>
							<span data-ng-if="showDoItLater"><fmt:message key="Finish" bundle="${messages}" /></span>
						</button>
					</div>
					<div data-ng-if="customizeForMetallic" class="wizard-footer">
						<button id="addServerContent_button_#8570" type="button" class="link-btn" data-ng-click="cancel()">
							<fmt:message key="Cancel" bundle="${messages}" />
						</button>
						<div class="btn-group-right">
							<button id="addServerContent_button_#1419"  type="submit" class="btn btn-primary cvBusyOnAjax">
								<span><fmt:message key="Next" bundle="${messages}" /></span>
							</button>
						</div>
					</div>
				</div>
			</div>
		</form>
			<form name="addVcenterForm" id="add-v-center-form" class="form-horizontal" novalidate data-cv-submit="addVcenter()" autocomplete="off"  data-ng-if="formAddVcenter"
			class="bootstrap-wrapper form-horizontal padding-bottom-0">

					<div class="panel panel-default">
						<div class="panel-body">
							<h4><fmt:message key="label.selectVcenter" /></h4>
							<div class="form-group">
                   				<div class="col-xs-12">
							     	<cv-kendo-grid data-cv-grid-options="vGgridOptions"></cv-kendo-grid>
								</div>
	             			</div>
                 		</div>

           		</div>
				<div class="button-container">
					<button id="addServerContent_button_#5606" type="button"  class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()">
						<fmt:message key="Cancel" bundle="${messages}" />
					</button>
					<button id="addServerContent_button_#1286" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="disableSubmit">
                      <span data-ng-if="model.vendorType=='VCLOUD'"><fmt:message key="Save" bundle="${messages}" /></span>
					</button>
				</div>
			</form>

		<div class="button-container centered" data-ng-show="formAddServer.hide">
			<fmt:bundle basename="localization.messages">
				<button id="addServerContent_button_#4612" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()"><fmt:message key="Continue" /></button>
			</fmt:bundle>
		</div>
		<div  data-ng-show="goToCollection && !formAddVcenter">
			<p><cv:msg key="message.serverAddSuccess" bundle="servers"/></p>
			<button id="addServerContent_button_#6800" type="button" class="btn btn-primary extra-spacing" data-ng-click="showAddCollection()"><cv:msg key="action.addVMGroup" bundle="collectionsJs" /></button>
			<a data-ng-click="skipAddCollection()" class="extra-spacing"><fmt:message key="action.skip" /></a>
		</div>
	</div> <!-- // end class="setup-content medium-width"   // -->
</fmt:bundle>
