<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<fmt:bundle basename="localization.collections">
	<div class="setup-title">
		<h1>{{::localizedTitle}}</h1>
	</div>
	<div class="setup-content">
		<span class="{{restoreSettingServerMessage.type}} serverMessage">{{restoreSettingServerMessage.message}}</span>
		<form name="addNetworkSettingsForm" novalidate cv-submit="addNetworkSettings()" autocomplete="off" class="add-collection-form" cv-hide-api>
			<label class="select-label" for="networkSettingsSource"><cv:msg key="label.sourceNetworkModal" bundle="restore"/>
				<select id="networkSettingsSource"
					data-ng-options="sourceNetwork as sourceNetwork for sourceNetwork in restoreData.vmOptions.settings.networkSettingsSourceNetworkData" data-ng-model="restoreData.vmOptions.settings.networkSettings.sourceNetwork" required>
					 <option class="options-placeholder" value="" selected></option>
				</select>
				<span class="help-block" data-ng-show="addNetworkSettingsForm.networkSettingsSource.$error && cv.addNetworkSettingsForm.needsAttention(addNetworkSettingsForm.networkSettingsSource)">
					<cv:msg key="error.networkSettings.source" bundle="restore"/>
				</span>
			</label>

			<label class="select-label" for="networkSettingsDestination"><cv:msg key="label.destinationNetworkModal" bundle="restore"/>
				<select id="networkSettingsDestination"
					data-ng-options="destinationNetwork as destinationNetwork for destinationNetwork in restoreData.vmOptions.settings.networkSettingsDestinationNetworkData" data-ng-model="restoreData.vmOptions.settings.networkSettings.destinationNetwork" required>
					 <!-- Just specify the loading label until the result is obtained, the controller handles the text after that -->
					 <option class="options-placeholder" value="" selected><cv:msg key="label.loading" bundle="restoreJs"/></option>
				</select>
				<span class="help-block" data-ng-show="addNetworkSettingsForm.networkSettingsDestination.$error && cv.addNetworkSettingsForm.needsAttention(addNetworkSettingsForm.networkSettingsDestination)">
					<cv:msg key="error.networkSettings.destination" bundle="restore"/>
				</span>
			</label>

			<div class="button-container">
				<fmt:bundle basename="localization.messages">
			  		<button id="addNetworkSettingsModal_button_#4590" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancelAddNetworkSettings()"><fmt:message key="Cancel" /></button>
			  		<button id="addNetworkSettingsModal_button_#5190" type="submit" class="btn btn-primary" data-ng-disabled="!restoreData.vmOptions.settings.networkSettingsDataAvailable"><fmt:message key="OK" /></button>
			  	</fmt:bundle>
			</div>
		</form>
	</div>
</fmt:bundle>