<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<fmt:bundle basename="localization.collections">
	<div class="setup-title">
		<h1>{{::localizedTitle}}</h1>
	</div>
	<div class="setup-content address-settings-reduce-padding">
		<form name="addIpAddressSettingsForm" novalidate cv-submit="addIpAddressSettings()" autocomplete="off" class="add-collection-form">
		
			<div class="global-options remove-border-padding restore-form">
					<label><h4><cv:msg key="label.sourceVMSettings" bundle="restore"/></h4></label>
				
					<label class="label-only restore-options-label" for="sourceIpAddress"><cv:msg key="label.ipAddress" bundle="restore"/>
						<input type="text" class="ip-text-input" name="sourceIpAddress" id="sourceIpAddress" placeholder="___.___.___.___" data-ng-pattern="ipPattern"
						data-ng-model="restoreData.vmOptions.settings.ipAddressSettings.sourceIpAddress" data-ng-required="!restoreData.vmOptions.settings.ipAddressSettings.destComputerName"/>
						<span class="help-block" data-ng-show="cv.addIpAddressSettingsForm.needsAttention(addIpAddressSettingsForm.sourceIpAddress)"><cv:msg key="error.ipAddressSettings.ipAddress" bundle="restore"/></span>
					</label>
					
					<label class="label-only restore-options-label" for="sourceSubnetMask"><cv:msg key="label.subnetMask" bundle="restore"/>
						<input type="text" class="ip-text-input" name="sourceSubnetMask" id="sourceSubnetMask" placeholder="___.___.___.___" data-ng-pattern="ipPattern"
						data-ng-model="restoreData.vmOptions.settings.ipAddressSettings.sourceSubnetMask" data-ng-required="!restoreData.vmOptions.settings.ipAddressSettings.destComputerName"/>
						<span class="help-block" data-ng-show="cv.addIpAddressSettingsForm.needsAttention(addIpAddressSettingsForm.sourceSubnetMask)"><cv:msg key="error.ipAddressSettings.subnetMask" bundle="restore"/></span>
					</label>
					
					<label class="label-only restore-options-label" for="sourceDefaultGateway"><cv:msg key="label.defaultGateway" bundle="restore"/>
						<input type="text" class="ip-text-input" name="sourceDefaultGateway" id="sourceDefaultGateway" placeholder="___.___.___.___" data-ng-pattern="ipPattern"
						data-ng-model="restoreData.vmOptions.settings.ipAddressSettings.sourceDefaultGateway" data-ng-required="!restoreData.vmOptions.settings.ipAddressSettings.destComputerName"/>
						<span class="help-block" data-ng-show="cv.addIpAddressSettingsForm.needsAttention(addIpAddressSettingsForm.sourceDefaultGateway)"><cv:msg key="error.ipAddressSettings.defaultGateway" bundle="restore"/></span>
					</label>
			</div>
			
		
			<div class="global-options remove-border-padding restore-form">
					<label><h4><cv:msg key="label.destinationVMSettings" bundle="restore"/></h4></label>
					<label data-ng-click="restoreData.vmOptions.settings.ipAddressSettings.destinationUseDHCP = !restoreData.vmOptions.settings.ipAddressSettings.destinationUseDHCP; dhcpUsed()">
							<toggle-control status="restoreData.vmOptions.settings.ipAddressSettings.destinationUseDHCP ? 'enabled-activity' : 'disabled-activity'">
						</toggle-control><span><cv:msg key="label.useDHCP" bundle="restore" /></span>
					</label>
					<div data-ng-hide="restoreData.vmOptions.settings.ipAddressSettings.destinationUseDHCP">
					<label class="label-only restore-options-label" for="destinationIpAddress"><cv:msg key="label.ipAddress" bundle="restore"/>
						<input type="text" class="ip-text-input" name="destinationIpAddress" id="destinationIpAddress" placeholder="___.___.___.___" data-ng-pattern="ipPattern"
						data-ng-model="restoreData.vmOptions.settings.ipAddressSettings.destinationIpAddress" data-ng-required="!restoreData.vmOptions.settings.ipAddressSettings.destinationUseDHCP && !restoreData.vmOptions.settings.ipAddressSettings.destComputerName"
						data-ng-disabled="restoreData.vmOptions.settings.ipAddressSettings.destinationUseDHCP"/>
						<span class="help-block" data-ng-show="cv.addIpAddressSettingsForm.needsAttention(addIpAddressSettingsForm.destinationIpAddress)"><cv:msg key="error.ipAddressSettings.ipAddress" bundle="restore"/></span>
					</label>
					
					<label class="label-only restore-options-label" for="destinationSubnetMask"><cv:msg key="label.subnetMask" bundle="restore"/>
						<input type="text" class="ip-text-input" name="destinationSubnetMask" id="destinationSubnetMask" placeholder="___.___.___.___" data-ng-pattern="ipPattern"
						data-ng-model="restoreData.vmOptions.settings.ipAddressSettings.destinationSubnetMask" data-ng-required="!restoreData.vmOptions.settings.ipAddressSettings.destinationUseDHCP && !restoreData.vmOptions.settings.ipAddressSettings.destComputerName"
						data-ng-disabled="restoreData.vmOptions.settings.ipAddressSettings.destinationUseDHCP"/>
						<span class="help-block" data-ng-show="cv.addIpAddressSettingsForm.needsAttention(addIpAddressSettingsForm.destinationSubnetMask)"><cv:msg key="error.ipAddressSettings.subnetMask" bundle="restore"/></span>
					</label>
					
					<label class="label-only restore-options-label" for="destinationDefaultGateway"><cv:msg key="label.defaultGateway" bundle="restore"/>
						<input type="text" class="ip-text-input" name="destinationDefaultGateway" id="destinationDefaultGateway" placeholder="___.___.___.___" data-ng-pattern="ipPattern"
						data-ng-model="restoreData.vmOptions.settings.ipAddressSettings.destinationDefaultGateway" data-ng-required="!restoreData.vmOptions.settings.ipAddressSettings.destinationUseDHCP && !restoreData.vmOptions.settings.ipAddressSettings.destComputerName"
						data-ng-disabled="restoreData.vmOptions.settings.ipAddressSettings.destinationUseDHCP"/>
						<span class="help-block" data-ng-show="cv.addIpAddressSettingsForm.needsAttention(addIpAddressSettingsForm.destinationDefaultGateway)"><cv:msg key="error.ipAddressSettings.defaultGateway" bundle="restore"/></span>
					</label>
					
					<label class="label-only restore-options-label" for="destinationPrefDnsServer"><cv:msg key="label.preferredDNSServer" bundle="restore"/>
						<input type="text" class="ip-text-input" name="destinationPrefDnsServer" id="destinationPrefDnsServer" placeholder="___.___.___.___" data-ng-pattern="ipPattern"
						data-ng-model="restoreData.vmOptions.settings.ipAddressSettings.destinationPrefDnsServer" data-ng-disabled="restoreData.vmOptions.settings.ipAddressSettings.destinationUseDHCP"/>
						<span class="help-block" data-ng-show="cv.addIpAddressSettingsForm.needsAttention(addIpAddressSettingsForm.destinationPrefDnsServer)"><cv:msg key="error.ipAddressSettings.prefDNSServer" bundle="restore"/></span>
					</label>
					
					<label class="label-only restore-options-label" for="destinationAltDnsServer"><cv:msg key="label.alternateDNSServer" bundle="restore"/>
						<input type="text" class="ip-text-input" name="destinationAltDnsServer" id="destinationAltDnsServer" placeholder="___.___.___.___" data-ng-pattern="ipPattern"
						data-ng-model="restoreData.vmOptions.settings.ipAddressSettings.destinationAltDnsServer" data-ng-disabled="restoreData.vmOptions.settings.ipAddressSettings.destinationUseDHCP"/>
						<span class="help-block" data-ng-show="cv.addIpAddressSettingsForm.needsAttention(addIpAddressSettingsForm.destinationAltDnsServer)"><cv:msg key="error.ipAddressSettings.altDNSServer" bundle="restore"/></span>
					</label>
					
					<label class="label-only restore-options-label" for="destinationPrefWinsServer"><cv:msg key="label.preferredWINSServer" bundle="restore"/>
						<input type="text" class="ip-text-input" name="destinationPrefWinsServer" id="destinationPrefWinsServer" placeholder="___.___.___.___" data-ng-pattern="ipPattern"
						data-ng-model="restoreData.vmOptions.settings.ipAddressSettings.destinationPrefWinsServer" data-ng-disabled="restoreData.vmOptions.settings.ipAddressSettings.destinationUseDHCP"/>
						<span class="help-block" data-ng-show="cv.addIpAddressSettingsForm.needsAttention(addIpAddressSettingsForm.destinationPrefWinsServer)"><cv:msg key="error.ipAddressSettings.prefWINSServer" bundle="restore"/></span>
					</label>
					
					<label class="label-only restore-options-label" for="destinationAltWinsServer"><cv:msg key="label.alternateWINSServer" bundle="restore"/>
						<input type="text" class="ip-text-input" name="destinationAltWinsServer" id="destinationAltWinsServer" placeholder="___.___.___.___" data-ng-pattern="ipPattern"
						data-ng-model="restoreData.vmOptions.settings.ipAddressSettings.destinationAltWinsServer" data-ng-disabled="restoreData.vmOptions.settings.ipAddressSettings.destinationUseDHCP"/>
						<span class="help-block" data-ng-show="cv.addIpAddressSettingsForm.needsAttention(addIpAddressSettingsForm.destinationAltWinsServer)"><cv:msg key="error.ipAddressSettings.altWINSServer" bundle="restore"/></span>
					</label>
					</div>
					<label class="label-only restore-options-label" for="destComputerName" data-ng-hide='restoreData.vmOptions.settings.hideDestComputerName'><cv:msg key="label.hostname" bundle="restore"/>
						<input type="text" class="ip-text-input" name="destComputerName" id="destComputerName" data-ng-pattern="/^((.){1,15})$/"
						data-ng-model="restoreData.vmOptions.settings.ipAddressSettings.destComputerName" />
						<div class="help-block" data-ng-show="addIpAddressSettingsForm.destComputerName.$error.pattern"><cv:msg key="error.Hostname" bundle="restore"></cv:msg>
						</div>
			</div>
			
			<div class="button-container">
				<fmt:bundle basename="localization.messages">
			  		<button id="addIpAddressSettingsModal_button_#5107" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancelAddIpAddressSettings()"><fmt:message key="Cancel" /></button> 
			  		<button id="addIpAddressSettingsModal_button_#7949" type="submit" class="btn btn-primary"><fmt:message key="OK" /></button> 
			  	</fmt:bundle>
			</div>
		</form>
	
	</div>
</fmt:bundle>