<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<fmt:setBundle basename="localization.messages" var="messages" />
<fmt:bundle basename="localization.servers">
<div data-ng-controller="addExistingServerController">
	<div class="setup-title">
		<h1>{{title}}</h1>
	</div>
	<div class="setup-content">
		<div class="{{addServerMessage.type}} serverMessage">{{addServerMessage.message}}</div>
		<form id="addExistingServerForm" name="addExistingServerForm" novalidate data-cv-submit="associateExistingServer()" autocomplete="off"  >
			<div data-ng-if="serversExisted" class="global-options remove-border-padding">
				<label for="servers" > {{selectLabel}}<%-- <fmt:message key="label.selectServer" /> --%>
					<div class="company-multi-select">
						<isteven-multi-select 
						    id="servers"
							input-model="deassociatedExistingServers"
							output-model="$parent.deassociatedSelectedServers"
							button-label="serverName" 
							item-label="serverName"
							class="isteven-multi-select user-group-select" 
							helper-elements="all none filter"
							tick-property="ticked" 
							max-labels="2" 
							translation="localLang">
						</isteven-multi-select>
					</div>
				</label>
				
				<label class="cv-inline-checkbox">
					<input name="enablePlan" id="enablePlan" type="checkbox" data-ng-model="modal.enablePlan"/>
					<label for="enablePlan" class="cv-checkbox-label"><fmt:message key="label.enableSelectPlan" /></label>
				</label>
				
				<label data-ng-show="modal.enablePlan" for="plans"><fmt:message key="label.selectPlan" />
					<div class="company-multi-select">
						<isteven-multi-select input-model="allSnapPlans"
							output-model="$parent.selectedSnapPlans" 
							button-label="planName"
							item-label="planName" 
							tick-property="ticked"
							helper-elements="none filter" 
							class="isteven-multi-select user-group-select"
							selection-mode="single" 
							max-labels="5" 
							translation="localLang"
							id="plans">
						</isteven-multi-select>
					</div>
				</label>
				
				
			</div>
	
	
				<div class="button-container">
					<button id="addExistingServerContent_button_#6042" type="button" 
						class="btn btn-default cvBusyOnAjax setup-btn--hidden"
						data-ng-click="cancel()">
						<fmt:message key="Cancel" bundle="${messages}" />
					</button>
					<button id="addExistingServerContent_button_#3183" data-ng-disabled="!serversExisted" type="submit" class="btn btn-primary cvBusyOnAjax"> 
						<fmt:message key="Save" bundle="${messages}" />
					</button>
				</div>
		</form>
	</div>
	
</div>
</fmt:bundle>
