<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.collections">
	<div  data-ng-controller="addCollectionController">
		<div class="setup-title">
			<h1>{{::localizedTitle}}</h1>
		</div>
		<div class="setup-content">
			<form name="addDiskFilterForm" novalidate cv-submit="addDiskFilter()" autocomplete="off" class="add-collection-form">
				<label class="select-label"><span data-ng-if="vendor && vendor==='AMAZON'"><cv:msg key="label.selectVolumeFilterType" bundle="collectionsJs"/></span>
					<span data-ng-if="!vendor || (vendor && vendor!=='AMAZON')"><cv:msg key="label.selectDiskFilterType" bundle="collectionsJs"/></span>
					<select
						data-ng-options="type as type.name for type in diskFilterTypes | orderBy: 'name' track by type.value" data-ng-model="dfdata.filterType" required>
						 <option class="options-placeholder" value="" disabled selected><cv:msg key="label.optionsPlaceholder" bundle="collectionsJs"/></option>
					</select>
				</label>
				<label data-ng-if="dfdata.filterType.value==='DISK_DATASTORE'" >
					<input type="text" data-ng-disabled="true" name="diskDatastore" data-ng-model="dfdata.diskDatastore" required spellcheck="false"/>{{diskDataStoreLabel}}
				</label>
				<cv-browse-collection-content data-ng-if="dfdata.filterType.value==='DISK_DATASTORE'"
					selected-content='dfdata.selectedDatastore'
					server-id="scId"
					single-selection-mode='true'
					selected-content-updated-function='datastoreSelectionChanged()'
					hide-grouping='true'
					initial-content-browse-view-path="{{diskDatasoreBrowsePath}}"
					selectable-types='DATASTORE'
					data-stop-at="DATASTORE"
					id="cv-browse-collection-content">
				</cv-browse-collection-content>
				<label data-ng-if="dfdata.filterType.value==='DISK_VIRTUAL_DEVICE_NODE' && (vendor !== 'AMAZON' && vendor !== 'ORACLE_VM')" class="select-label">
					{{vdnLabel}}
					<select id="diskVirtualDeviceNode" name="diskVirtualDeviceNode"
							data-ng-options="vdn as vdn.displayName for vdn in virtualDeviceNodeOptions" data-ng-model="dfdata.diskVirtualDeviceNode" data-ng-change="populateLocationOptions()" required>
						<option class="options-placeholder" value="" disabled selected><cv:msg key="label.optionsPlaceholder" bundle="collectionsJs"/></option>
					</select>
					<span class="help-block" data-ng-show="cv.addDiskFilterForm.needsAttention(addDiskFilterForm.diskVirtualDeviceNode)">{{vdnError}}</span>
				</label>
				<label data-ng-if="dfdata.filterType.value==='DISK_VIRTUAL_DEVICE_NODE' && vendor === 'AMAZON'">
						<input type="text" name="diskVirtualDeviceNode" data-ng-model="dfdata.diskVirtualDeviceNode" required spellcheck="false"/><cv:msg key="VMSubclientDiskFilterType.DISK_VIRTUAL_DEVICE_NODE.AMAZON" bundle="collectionsJs"/>
						<span class="help-block" data-ng-show="cv.addDiskFilterForm.needsAttention(addDiskFilterForm.diskVirtualDeviceNode)"><cv:msg key="error.diskVirtualDeviceNode.AMAZON" bundle="collectionsJs"/></span>
				</label>
				<label data-ng-if="dfdata.filterType.value==='DISK_VIRTUAL_DEVICE_NODE' && virtualDeviceNodeLocationOptions.length" class="select-label"><cv:msg key="label.diskVirtualDeviceNodeLocation" bundle="collectionsJs"/>
					<select id="diskVirtualDeviceNodeLocation" name="diskVirtualDeviceNodeLocation"
							data-ng-options="loc for loc in virtualDeviceNodeLocationOptions track by loc" data-ng-model="dfdata.diskVirtualDeviceNodeLocation" required>
						<option class="options-placeholder" value="" disabled selected><cv:msg key="label.optionsPlaceholder" bundle="collectionsJs"/></option>
					</select>
					<span class="help-block" data-ng-show="cv.addDiskFilterForm.needsAttention(addDiskFilterForm.diskVirtualDeviceNodeLocation)"><cv:msg key="error.diskVirtualDeviceNodeLocation" bundle="collectionsJs"/></span>
				</label>
				<label data-ng-if="dfdata.filterType.value==='DISK_PATTERN'" >
						<input type="text" name="diskPattern" data-ng-model="dfdata.diskPattern" required spellcheck="false"/>{{diskPatternLabel}}
						<span class="help-block" data-ng-show="cv.addDiskFilterForm.needsAttention(addDiskFilterForm.diskPattern)">{{diskPatternError}}</span>
				</label>
				<label data-ng-if="dfdata.filterType.value==='DISK_PATH'" >
						<input type="text" name="diskPath" data-ng-model="dfdata.diskPath" required spellcheck="false"/>{{diskPathLabel}}
						<span class="help-block" data-ng-show="cv.addDiskFilterForm.needsAttention(addDiskFilterForm.diskPath)">{{diskPathError}}</span>
				</label>
				<label data-ng-if="diskFilterOptionsVisibilityCheck('DISK_LABEL', dfdata.filterType.value, vendor)" >
						<input type="text" name="diskLabelFromInput" data-ng-model="dfdata.diskLabelFrom" data-ng-blur='diskLabelChanged(true)' data-ng-pattern='diskLabelPattern' required spellcheck="false"/>{{diskLabelFrom}}
						<span class="help-block" data-ng-show="cv.addDiskFilterForm.needsAttention(addDiskFilterForm.diskLabelFromInput)">{{errorDiskLabel}}
				</label>
				<label data-ng-if="diskFilterOptionsVisibilityCheck('DISK_LABEL', dfdata.filterType.value, vendor)" >
						<input type="text" name="diskLabelToInput" data-ng-model="dfdata.diskLabelTo" data-ng-blur='diskLabelChanged(false)' data-ng-pattern='diskLabelPattern'' required spellcheck="false"/>{{diskLabelTo}}
						<span class="help-block" data-ng-show="cv.addDiskFilterForm.needsAttention(addDiskFilterForm.diskLabelToInput)">{{errorDiskLabel}}
				</label>
                 <label data-ng-if="dfdata.filterType.value==='DISK_ADDRESS' &&  diskAddressOptions.length" class="select-label">
					<cv:msg key="label.diskAddress" bundle="collectionsJs"/>
					<select id="diskAddress" name="diskAddress"
							data-ng-options="address as address for address in diskAddressOptions" data-ng-model="dfdata.diskAddress"  required>
						<option class="options-placeholder" value="" disabled selected><cv:msg key="label.optionsPlaceholder" bundle="collectionsJs"/></option>
					</select>
					<!-- <span class="help-block" data-ng-show="cv.addDiskFilterForm.needsAttention(addDiskFilterForm.diskVirtualDeviceNode)">{{vdnError}}</span> -->
				</label>
				<label data-ng-if="dfdata.filterType.value==='DISK_ADDRESS' && diskAddressOptions.length">
					<input type="text" name="diskNumber" data-ng-model="dfdata.diskNumber" data-ng-pattern='diskNumberPattern' required spellcheck="false"/><cv:msg key="label.diskNumber" bundle="collectionsJs"/>
					<span class="help-block" data-ng-show="cv.addDiskFilterForm.needsAttention(addDiskFilterForm.diskNumber)"><cv:msg key="error.diskNumber" bundle="collectionsJs"/></span>
				</label>
				<label data-ng-if="dfdata.filterType.value==='CONTAINER_PATTERN'" >
						<input type="text" name="diskContainer" data-ng-model="dfdata.diskContainer" required spellcheck="false"/><cv:msg key="label.diskContainer" bundle="collectionsJs"/>
						<span class="help-block" data-ng-show="cv.addDiskFilterForm.needsAttention(addDiskFilterForm.diskContainer)"><cv:msg key="error.diskContainer" bundle="collectionsJs"/></span>
				</label>
				<label data-ng-if="dfdata.filterType.value==='DISK_TYPE' && showOperatorForDiskType" class="select-label ">
					<cv:msg key="label.matchesRule" bundle="collectionsJs"/>
					<select data-ng-disabled="dfdata.operatorList.length<=1"
							id="ruleKey"
							data-ng-options="operator as operator.name for operator in dfdata.operatorList | orderBy: 'orderBy' track by operator.value"
							data-ng-model="dfdata.operator" required></select>
				</label>
				<label data-ng-if="dfdata.filterType.value==='DISK_TYPE' && diskTypeOptions.length" class="select-label ">{{diskTypeLabel}}
					<select id="diskType" name="diskType"
							data-ng-options="diskType for diskType in diskTypeOptions" data-ng-model="dfdata.diskType" required>
							<option class="options-placeholder" value="" disabled selected><cv:msg key="label.optionsPlaceholder" bundle="collectionsJs"/></option>
					</select>
				</label>
				<label data-ng-if="diskFilterOptionsVisibilityCheck('DISK_TAG', dfdata.filterType.value, vendor)" >
						<input type="text" name="diskTagName" data-ng-model="dfdata.diskTagName" data-ng-pattern='diskLabelPattern' required spellcheck="false"/>{{diskTagNameLabel}}
						<span class="help-block" data-ng-show="cv.addDiskFilterForm.needsAttention(addDiskFilterForm.diskTagName)">{{errorDiskTagName}}</span>
				</label>
				<label data-ng-if="diskFilterOptionsVisibilityCheck('DISK_TAG', dfdata.filterType.value, vendor)" >
						<input type="text" name="diskTagValue" data-ng-model="dfdata.diskTagValue"  data-ng-pattern='diskLabelPattern' required spellcheck="false"/>{{diskTagValueLabel}}
						<span class="help-block" data-ng-show="cv.addDiskFilterForm.needsAttention(addDiskFilterForm.diskTagValue)">{{errorDiskTagValue}}</span>
				</label>
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
				  		<button id="addDiskFilterContentModal_button_#5429" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancelAddRule()"><fmt:message key="Cancel" /></button>
				  		<button id="addDiskFilterContentModal_button_#5805" type="submit" class="btn btn-primary" ><fmt:message key="OK" /></button>
				  	</fmt:bundle>
				</div>
			</form>
		</div>
	</div>
</fmt:bundle>