<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.vna"></cv:cvMessages>
</script>
<div class="setup-title">
	<h3><cv:msg key="info.vnaconfig" bundle="vna" /></h3>
</div>
<div class="setup-content">
	<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	<section>
		<form name="editVNAConfigurationForm" novalidate data-cv-submit="saveConfiguration()" autocomplete="off" class="add-collection-form">
			<div class="global-options remove-border-padding">
				<label for="aet"><cv:msg key="config.aetitle" bundle="vna" />
					<input type="text" name="aet" id="aet" data-ng-model="aet" required
							data-ng-class="{'has-error': cv.editVNAConfigurationForm.needsAttention(editVNAConfigurationForm.aet)}" />
					<span class="help-block" data-ng-show="editVNAConfigurationForm.aet.$error.required && cv.editVNAConfigurationForm.needsAttention(editVNAConfigurationForm.aet)"><cv:msg key="error.name" bundle="vna"/></span>
				</label>
				<label for="dport"><cv:msg key="config.dport" bundle="vna" />
					<input type="number" name="dport" id="dport" data-ng-model="dport" min="1" max="65535" required
							data-ng-class="{'has-error': cv.editVNAConfigurationForm.needsAttention(editVNAConfigurationForm.dport)}" />
					<span class="help-block" data-ng-show="editVNAConfigurationForm.dport.$error.required && cv.editVNAConfigurationForm.needsAttention(editVNAConfigurationForm.dport)"><cv:msg key="error.dport" bundle="vna"/></span>
					<span class="help-block" data-ng-show="(editVNAConfigurationForm.dport.$error.min || editVNAConfigurationForm.dport.$error.max) && cv.editVNAConfigurationForm.needsAttention(editVNAConfigurationForm.dport)"><cv:msg key="error.portoutofrange" bundle="vna"/></span>
				</label>
				<label for="hl7port"><cv:msg key="config.hl7port" bundle="vna" />
					<input type="number" name="hl7port" id="hl7port" data-ng-model="hl7port" min="1" max="65535" required
							data-ng-class="{'has-error': cv.editVNAConfigurationForm.needsAttention(editVNAConfigurationForm.hl7port)}" />
					<span class="help-block" data-ng-show="editVNAConfigurationForm.hl7port.$error.required && cv.editVNAConfigurationForm.needsAttention(editVNAConfigurationForm.hl7port)"><cv:msg key="error.hl7port" bundle="vna"/></span>
					<span class="help-block" data-ng-show="(editVNAConfigurationForm.hl7port.$error.min || editVNAConfigurationForm.hl7port.$error.max) && cv.editVNAConfigurationForm.needsAttention(editVNAConfigurationForm.hl7port)"><cv:msg key="error.portoutofrange" bundle="vna"/></span>
				</label>
				<label for="edgeurl"><cv:msg key="config.edgeurl" bundle="vna" />
					<input type="url" name="edgeurl" id="edgeurl" data-ng-model="edgeurl" required
							data-ng-class="{'has-error': cv.editVNAConfigurationForm.needsAttention(editVNAConfigurationForm.edgeurl)}" />
					<span class="help-block" data-ng-show="editVNAConfigurationForm.edgeurl.$error.required && cv.editVNAConfigurationForm.needsAttention(editVNAConfigurationForm.edgeurl)"><cv:msg key="error.edgeurl" bundle="vna"/></span>
				</label>
				<!-- fake fields are a workaround for chrome autofill getting the wrong fields-->
				<input style="display:none" type="text" name="fakeusernameremembered"/>
				<input style="display:none" type="password" name="fakepasswordremembered"/>
				<label for="edgeuser"><cv:msg key="config.edgeuser" bundle="vna" />
					<input type="text" name="username" id="edgeuser" data-ng-model="username" required
							data-ng-class="{'has-error': cv.editVNAConfigurationForm.needsAttention(editVNAConfigurationForm.username)}" />
					<span class="help-block" data-ng-show="editVNAConfigurationForm.username.$error.required && cv.editVNAConfigurationForm.needsAttention(editVNAConfigurationForm.username)"><cv:msg key="error.edgeuser" bundle="vna"/></span>
				</label>
				<label for="edgepwd"><cv:msg key="config.edgepwd" bundle="vna" />
					<input type="password" name="password" id="edgepwd" data-ng-model="password" required
							data-ng-class="{'has-error': cv.editVNAConfigurationForm.needsAttention(editVNAConfigurationForm.password)}" />
					<span class="help-block" data-ng-show="editVNAConfigurationForm.password.$error.required && cv.editVNAConfigurationForm.needsAttention(editVNAConfigurationForm.password)"><cv:msg key="error.edgepwd" bundle="vna"/></span>
				</label>
			</div>
			<div class="button-container">
				<fmt:bundle basename="localization.messages">
					<button id="configVNATemplate_button_#3705" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages" /></button> 
					<button id="configVNATemplate_button_#2922" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" bundle="messages" /></button> 
				</fmt:bundle>
			</div>
		</form>
	</section>
</div>