<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.vna"></cv:cvMessages>
</script>
<div class="setup-title">
	<h3><cv:msg key="info.syslogconfig" bundle="vna" /></h3>
</div>
<div class="setup-content">
	<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	<section>
		<form name="editSyslogConfigurationForm" novalidate data-cv-submit="saveConfiguration()" autocomplete="off" class="add-collection-form">
			<div class="global-options remove-border-padding">
				<label for="hostname"><cv:msg key="config.syslogHost" bundle="vna" />
					<input type="text" name="hostname" id="hostname" data-ng-model="hostname" required
							data-ng-class="{'has-error': cv.editSyslogConfigurationForm.needsAttention(editSyslogConfigurationForm.hostname)}" />
					<span class="help-block" data-ng-show="editSyslogConfigurationForm.hostname.$error.required && cv.editSyslogConfigurationForm.needsAttention(editSyslogConfigurationForm.hostname)"><cv:msg key="error.host" bundle="vna"/></span>
				</label>
				<label for="port"><cv:msg key="config.syslogPort" bundle="vna" />
					<input type="number" name="port" id="port" data-ng-model="port" min="1" max="65535" required
							data-ng-class="{'has-error': cv.editSyslogConfigurationForm.needsAttention(editSyslogConfigurationForm.port)}" />
					<span class="help-block" data-ng-show="editSyslogConfigurationForm.port.$error.required && cv.editSyslogConfigurationForm.needsAttention(editSyslogConfigurationForm.port)"><cv:msg key="error.port" bundle="vna"/></span>
					<span class="help-block" data-ng-show="(editSyslogConfigurationForm.port.$error.min || editSyslogConfigurationForm.port.$error.max) && cv.editSyslogConfigurationForm.needsAttention(editSyslogConfigurationForm.port)"><cv:msg key="error.portoutofrange" bundle="vna"/></span>
				</label>
				<label for="protocol" class="select-label"><cv:msg key="config.syslogProtocol" bundle="vna" />
					<select name="protocol" id="protocol" data-ng-model="protocol" data-ng-options="protocol.name for protocol in protocols" required data-ng-class="{'has-error': cv.editSyslogConfigurationForm.needsAttention(editSyslogConfigurationForm.protocol)}">
					</select>
				</label>
			</div>
			<div class="button-container">
				<fmt:bundle basename="localization.messages">
					<button id="configSyslogTemplate_button_#7961" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages" /></button> 
					<button id="configSyslogTemplate_button_#6856" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" bundle="messages" /></button> 
				</fmt:bundle>
			</div>
		</form>
	</section>
</div>