var returnVals = false;
$(document).ready(function() {
	$(".uploadFrm").on("submit", function(event) {
		if (incompatibleBrowser == false) {
			event.preventDefault();
			submitForm($(this));
		} else {
			$(this).find(".uploadInProgress").show();
			$(this).find(".uploadDiv").hide();
			$(this).find(".uploadButton").hide();
			$(".uploadFiles li").remove();
			$(".uploadFiles ul").append("<li>" + $(this).find(".attachment").attr("value") + "</li>");
		}

		return true;
	});

	$("body").on("click", ".attachment", function() {
		$(".attachmentError").hide();
	});

	$("body").on("click",
			".cancelButton",
			function() {
				if ($(this).parents(".uploadFileDiv").find(".uploadDiv").is(":visible"))
					cvUtil.closeModal();
				else {

					console.debug("Cancelling Uploads...");
					$(this).parents(".uploadFileDiv").find(".uploadCancel").show();
					$(this).parents(".uploadFileDiv").find(".uploadCancel .ctext_canceling").show();
					$(this).parents(".uploadFileDiv").find(".uploadCancel .ctext_cancelled").hide();
					$(this).parents(".uploadFileDiv").find(".btns").hide();
					$(this).parents(".uploadFileDiv").find(".uploadInProgress").hide();
					files = $(this).parents(".uploadFileDiv").find('.selectedFiles li');
					console.debug("Cancelling Uploads... " + files.length);

					var count = 0;
					var thisElement = $(this);
					var interval = null;
					interval = window.setInterval(function() {
						for (var i = 0; i < files.length; i++) {
							console.debug("Removing file: " + $(files[i]).text());

							var clientId = thisElement.parents(".uploadFileDiv").find(".clientId").attr("value");
							var destPath = thisElement.parents(".uploadFileDiv").find(".destPath").attr("value");
							var shareFolderId = thisElement.parents(".uploadFileDiv").find(".shareFolderId")
									.attr("value");
							var fileName = $(files[i]).text();
							var contentsFinal = "clientId=" + clientId + "&destPath=" + destPath + "&fileName=" +
									fileName + "&shareFolderId=" + shareFolderId;

							var parentGuid = thisElement.parents(".uploadFileDiv").find(".parentGuid").attr("value");
							if (typeof parentGuid !== "undefined" && parentGuid !== null) {
								contentsFinal += "&parentGuid=" + parentGuid;
								showNotes = false;
							}
							var actualFilePath = thisElement.parents(".uploadFileDiv").find(".actualFilePath")
									.attr("value");
							if (typeof actualFilePath !== "undefined" && actualFilePath !== null) {
								contentsFinal += "&actualFilePath=" + actualFilePath;
								showNotes = false;
							}
							cvUtil.loadSynchronously(cvUtil.getContextPath() + '/cancelFileUpload.do',
									contentsFinal,
									function(data) {
										alert("Cancel Failed: " + data);
									},
									function(data) {
										thisElement.parents(".uploadFileDiv").remove();
									});

						}
						count++;
						if (count == 3)
							window.clearInterval(interval);
					}, 3000);
				}
			});

	$(".closeDiv").live("click", function(e) {
		if ($(this).parents(".uploadProgress").find(".uploadFileDiv").length == 1) {
			$(this).parents(".uploadProgress").hide();
		}
		$(this).parents(".uploadFileDiv").remove();
		console.log($(this).parents(".uploadFileDiv").length);
	});

	$(".attachment").change(function(e) {
		if (!incompatibleBrowser) {
			var f = this.files, len = f.length;
			$(".uploadFiles li").remove();
			if (len > 0) {
				$("#selectedFilesText").removeClass("hidden");
			} else {
				$("#selectedFilesText").addClass("hidden");
			}
			for (var i = 0; i < len; i++) {
				$(".uploadFiles ul").append("<li>" + f[i].name + "</li>");
			}
		}
	});

});

// This method is called by custom-modal to retrieve return value for callback function - do not add to local namespace!
function getData() {
	return returnVals;
}

function submitForm(elem) {
	if ($(".attachment").val() == "") {
		$(".attachmentError").css("display", "block");
		return false;
	}
	submitFormFull(elem, elem.find(".attachment")[0].files);
}

function submitFormFull(elem, elementFiles) {
	elem.find(".headerDiv").show();
	elem.find(".uploadInProgress").show();
	elem.find(".uploadDiv").hide();
	elem.find(".uploadButton").hide();

	var dragAndDrop = true;
	if (elem.parents(".uploadProgress").length < 1)
		dragAndDrop = false;

	if (!dragAndDrop) {
		cvUtil.hideModal();
	}

	var thisElement = elem.parent();

	var destPath = elem.find(".destPath").attr("value");
	var formData = new FormData();
	formData.append("clientId", elem.find(".clientId").attr("value"));
	formData.append("shareFolderId", elem.find(".shareFolderId").attr("value"));
	var parentGuid = elem.find(".parentGuid").attr("value");
	if (typeof parentGuid !== "undefined" && parentGuid !== null) {
		formData.append("parentGuid", parentGuid);
		showNotes = false;
	}
	var actualFilePath = elem.find(".actualFilePath").attr("value");
	if (typeof actualFilePath !== "undefined" && actualFilePath !== null) {
		formData.append("actualFilePath", actualFilePath);
		showNotes = false;
	}
	formData.append("incompatibleBrowser", incompatibleBrowser);

	var filesPopulated = false;
	if (elem.find(".selectedFiles li").length > 0)
		filesPopulated = true;

	var numOfFiles = 0;
	$.each(elementFiles, function(i, file) {
		formData.append("isFile", isFile);
		if (typeof destPath !== "undefined" && destPath !== null) {
			formData.append("destPath", destPath);
		}
		if ((file.type == "" && file.size % 4096 == 0) || file.size == 0) {
			if (dragAndDrop) {
				alert(file.name + " " + folderUploadError);
			} else {
				window.parent.alert(file.name + " " + folderUploadError);
			}
		} else {
			formData.append("fileSize", file.size);
			if (typeof window.FileReader !== 'function' && typeof window.FileReader !== 'object') {
				// The file API isn't supported on this browser yet.
				formData.append("lastModifiedTime", -1);
			} else {
				var dt = new Date(file.lastModifiedDate);
				formData.append("lastModifiedTime", (dt.getTime() / 1000));
			}
			formData.append('file', file);
			numOfFiles++;
			if (!filesPopulated)
				elem.find(".selectedFiles").append("<li>" + file.name + "</li>");
		}
	});

	var isSingleFileUploadNotAllowedForSharedFolder = false;
	var shareFolderIdForUpload = elem.find(".shareFolderId").attr("value");

	/*
	 * Checks for share folder browse in case a single file is shared, and user tries to upload another file
	 * instead. We must block it.
	 */
	if (dragAndDrop) {
		if (typeof (shareFolderIdForUpload) !== "undefined" &&
				shareFolderIdForUpload != null &&
				shareFolderIdForUpload != "" &&
				typeof (browseMain.isDirectoryShareFolderBrowse) !== "undefined" &&
				browseMain.isDirectoryShareFolderBrowse != null &&
				browseMain.isDirectoryShareFolderBrowse == "false" &&
				(numOfFiles > 1 || ($(document).find("#filetablebody tr").length == 1 && $(document)
						.find("#filetablebody tr").first().find(".fileName span").text().toLowerCase() != elem
						.find(".selectedFiles li").first().text().toLowerCase()))) {
			isSingleFileUploadNotAllowedForSharedFolder = true;
		}
	} else {
		if (typeof (shareFolderIdForUpload) !== "undefined" &&
				shareFolderIdForUpload != null &&
				shareFolderIdForUpload != "" &&
				typeof (window.parent.browseMain.isDirectoryShareFolderBrowse) !== "undefined" &&
				window.parent.browseMain.isDirectoryShareFolderBrowse != null &&
				window.parent.browseMain.isDirectoryShareFolderBrowse == "false" &&
				(numOfFiles > 1 || ($(window.parent.document).find("#filetablebody tr").length == 1 && $(window.parent.document)
						.find("#filetablebody tr").first().find(".fileName span").text().toLowerCase() != elem
						.find(".selectedFiles li").first().text().toLowerCase()))) {
			isSingleFileUploadNotAllowedForSharedFolder = true;
		}
	}

	if (numOfFiles == 0) {
		elem.find(".closeDiv").click();
		return;
	} else {
		if (isSingleFileUploadNotAllowedForSharedFolder) {
			elem.find(".closeDiv").click();
			if (dragAndDrop) {
				cvUtil.errorToast("Cannot upload files with a different name.");
			} else {
				window.parent.cvUtil.errorToast("Cannot upload files with a different name.");
			}
			return;
		}
	}

	window.setTimeout(function() {
		var ajaxId = $.ajax({
			url : 'uploadFile.do',
			type : 'POST',
			data : formData,
			async : true,
			success : function(dataResult) {
				/*
				 * !!! NAMESPACE - confirm this still works after namespacing; also, if we use this at the top
				 * of this file to pull the namespaced items to here, we might not need this window.parent
				 * logic:
				 * 
				 * window.top.rescopeBrowseNamespaces(window);
				 */
				var mainElement = null;
				if (dragAndDrop) {
					mainElement = $(".uploadProgress").find(thisElement);
					if (browseMain.isSyncFolderBrowse()) {
						browseMain.clearBrowseSessionIds();
					}
					browseMain.refreshTable(true);
				} else {
					mainElement = $(window.parent.$(".uploadProgress").find(thisElement));
					if (window.parent.browseMain.isSyncFolderBrowse()) {
						window.parent.browseMain.clearBrowseSessionIds();
					}
					window.parent.browseMain.refreshTable(true);
				}

				var returnedItems = JSON.parse(dataResult);
				var returnCode = returnedItems.returnCode;
				if (returnCode == "Cancel") {
					mainElement.find(".uploadCancel").show();
					mainElement.find(".uploadCancel .ctext_canceling").hide();
					mainElement.find(".uploadCancel .ctext_cancelled").show();
					mainElement.find(".btns").hide();
					mainElement.find(".uploadInProgress").hide();
					mainElement.find(".closeDiv").show();
					nh.addNotificationToHistory(nh.NOTIFICATION_INFO, mainElement
							.find(".uploadCancel .ctext_cancelled").text(), false);
					window.setTimeout(function() {
						mainElement.find(".closeDiv").trigger("click");
					}, 10000);
				} else if (returnCode == "Error") {
					mainElement.find(".uploadCancel").hide();
					mainElement.find(".uploadCancel .ctext_canceling").hide();
					mainElement.find(".uploadCancel .ctext_cancelled").hide();
					mainElement.find(".uploadFailed").find(".ctext_Failed").text(returnedItems.returnErrorMessage);
					mainElement.find(".uploadFailed").find(".ctext_Failed").show();
					mainElement.find(".uploadFailed").show();
					mainElement.find(".btns").hide();
					mainElement.find(".uploadInProgress").hide();
					mainElement.find(".closeDiv").show();
					nh.addNotificationToHistory(nh.NOTIFICATION_INFO, returnedItems.returnErrorMessage, false);
				} else if (returnCode == "Success") {
					mainElement.find(".uploadCancel").hide();
					if (!showNotes) {
						mainElement.find(".noteClass").empty();
					}
					mainElement.find(".uploadCancel .ctext_canceling").hide();
					mainElement.find(".uploadCancel .ctext_cancelled").hide();
					mainElement.find(".uploadCompleted").show();
					mainElement.find(".btns").hide();
					mainElement.find(".uploadInProgress").hide();
					mainElement.find(".closeDiv").show();
					var returnedFilesList = returnedItems.returnFilesList;
					mainElement.find(".fNames").text(returnedFilesList.substring(1, returnedFilesList.length - 1));
					var returnDestPath = returnedItems.returnDestPath;
					mainElement.find(".destLocation").text(returnDestPath);
					nh.addNotificationToHistory(nh.NOTIFICATION_INFO, mainElement.find(".uploadCompleted .ctext")
							.text(), false);
					window.setTimeout(function() {
						mainElement.find(".closeDiv").trigger("click");
					}, 10000);

				}

			},
			cache : false,
			contentType : false,
			processData : false
		});
		if (dragAndDrop) {
			window.uploadAjaxRequests[window.uploadAjaxRequests.length] = ajaxId;
		} else {
			window.parent.uploadAjaxRequests[window.parent.uploadAjaxRequests.length] = ajaxId;
		}

	}, 100);

}
