var fileProgress = {};
var listTemplate = '<li class="fileRow {{fileStatus}} {{fileDirection}}" data-file-id="{{fileID}}"><div class="fileProgressBar">';
listTemplate += '<div class="fileProgressLoaded" style="width:{{filePercent}}%"></div></div> <span class="fileDirection {{fileDirection}}"></span>';
listTemplate += '<span class="fileInfo"><span class="fileName">{{fileName}}</span><br><span class="fileProgress"><span class="fileProgressState">{{fileProgress}}</span>';
listTemplate += '<span class="fileError {{error.display}}" title="{{error.message}}"> {{error.message}}</span></span></span><span class="btnCancel"></span>';
listTemplate += '<span class="filePostProcess"></span><span class="iconComplete"></span><span class="fileProgressPercent">{{filePercent}}%</span>';
listTemplate += '<span class="fileSize">{{fileSizeFormatted}}</span><span class="fileWaiting">';
listTemplate += localMsg.fileProgress;
listTemplate += '</span><span class="fileCancelled">';
listTemplate += '<!--<span class="btnResume">';
listTemplate += localMsg.resume;
listTemplate += '</span>-->';
listTemplate += localMsg.cancelled;
listTemplate += '</span></li>';
var isUiInitialized = false;
var ERRORCODE_LOCAL_PROFILE_NOT_ASSIGNED = 2010;

fileProgress.initGlobalVars = function() {
	$progressFilesUl = $(".progressFiles").find("ul");
	$progressHeader = $(".progressHeader");
	$progressStatus = $(".progressStatus");
	$progressOptions = $(".progressOptions");
	$fileProgressContainer = $(".fileProgressContainer");
	singleRowHeight = '';
	headersHeight = '';
	listHeight = '';
	totalHeight = '';
};

fileProgress.updateRow = function(fileItem) {
	var $row = $(".progressListWrapper").find("ul").find("[data-file-id=" + fileItem.fileID + "]");
	if ($row.length > 0) {
		// replace this string with a dynamically generated string based on "FileProgressItem" class in uploader.js
		$row.removeClass("notpicked picked waiting started inProgress paused cancelled postprocess complete error")
				.addClass(fileItem.fileStatus);
		$row.find(".fileProgressState").text(fileItem.fileProgress);
		$row.find(".fileProgressPercent").text(fileItem.filePercent + "%");
		$row.find(".fileProgressLoaded").width(fileItem.filePercent + "%");
		if (fileItem.fileStatus == "error" || fileItem.fileStatus == "cancelled") {
			$(".btnClearAll").show();
			$row.find(".fileError").removeClass("").addClass(fileItem.error.display);
			$row.find(".fileError").text(fileItem.error.message);
			$row.find(".fileError").attr('title', fileItem.error.message);
			if (fileItem.error.errorCode && fileItem.error.errorCode == ERRORCODE_LOCAL_PROFILE_NOT_ASSIGNED) {
				var errElem = $row.find(".fileError");
				//assignProfileLink format is {0}click here{1}to continue.Text between {0} and {1} will be used as href text
				var textBeforeLink = localMsg.assignProfileLink.split("{0}")[0];
				var linkText = localMsg.assignProfileLink.split("{0}")[1];
				var textAfterLink = linkText.split("{1}")[1];
				linkText = linkText.split("{1}")[0];
				var link = fileProgress.getSyncLink(linkText);
				errElem.append('<br>');
				if (textBeforeLink && (textBeforeLink != '')) {
					errElem.append("<span class='errorNote'> " + textBeforeLink + "<span>");
				}
				errElem.append(link);
				if (textAfterLink && (textAfterLink != '')) {
					errElem.append("<span class='errorNote'> " + textAfterLink + "<span>");
				}
			}
		}

		if (fileItem.fileStatus == "complete") {
			$row.delay(5000).hide("slide", {
				direction : "right"
			}, 1000, function() {
				$(this).remove();
			});
		}
	}
};
fileProgress.getSyncLink = function(linkText) {
	var link = $("<a/>");
	link.text(linkText);
	link.click(function() {
		var params = [];
		params.push(cvUtil.createParamString(browseConstants.PARAM_CLIENT_ID, browseMain.clientId));
		params.push(cvUtil.createParamString(browseConstants.PARAM_CLIENT_NAME, browseMain.clientName));
		// manual username entry for linux and solaris
		if (browseMain.clientAppTypeId === "19" || browseMain.clientAppTypeId === "29" ||
				browseMain.clientAppTypeId === "86") {
			params.push(cvUtil.createParamString(browseConstants.PARAM_MANUAL_USERNAME, "true"));
		}

		var target = cvUtil.createUrlWithParams("selectSyncProfile.jsp", params);

		var options = {
			modal : true,
			width : 355,
			height : 120,
			title : localMsg.selectSyncProfileTitle,
			href : target,
			iframe : false

		};

		cvUtil.showModal(options, null, function() {
			if (!!browseMain.userProfileMapping) {
				console.log("user profile set in upload");
			}
		});
	});
	return link;

}

fileProgress.updateHeader = function(uploadProgress) {
	if (typeof uploadProgress !== "undefined" && uploadProgress !== null) {
		if (typeof $progressHeader !== "undefined" && $progressHeader !== null) {
			var progressCompleteCount = $progressHeader.find(".progressCompleteCount");
			var progressPercentage = $progressHeader.find(".progressPercentage");
			// For showing size (x or y) done
			if (false) {
				if (uploadProgress.formattedUploadSize != null && uploadProgress.formattedUploadSize.length > 0) {
					progressCompleteCount.text(uploadProgress.formattedUploadSize);
				} else {
					progressCompleteCount.text("");
				}
			}
			// For showing files (x or y) done
			if (uploadProgress.formattedUploadCount != null && uploadProgress.formattedUploadCount.length > 0) {
				progressCompleteCount.text(uploadProgress.formattedUploadCount);
			} else {
				progressCompleteCount.text("");
			}
			if (uploadProgress.formattedUploadPercentage != null && uploadProgress.formattedUploadPercentage.length > 0) {
				progressPercentage.text(" (" + uploadProgress.formattedUploadPercentage + ")");
			} else {
				progressPercentage.text("");
			}
		}
		$progressStatus.text(uploadProgress.formattedUploadStatus);
		if (uploadProgress.uploadCompleted) {
			if (typeof $progressOptions !== "undefined" && $progressOptions !== null) {
				$(".btnCancelAll").hide();
				$fileProgressContainer.addClass("noCancelBtn");
			}
			if (typeof $fileProgressContainer !== "undefined" && $fileProgressContainer !== null) {
				$fileProgressContainer.find(".btnClose").show();
				$fileProgressContainer.find(".btnClose").off("click");
				$fileProgressContainer.find(".btnClose").on("click", function() {
					fileProgress.removeDialog();
				});
			}
		} else {
			if (typeof $progressOptions !== "undefined" && $progressOptions !== null) {
				$(".btnCancelAll").show();
				$fileProgressContainer.removeClass("noCancelBtn");
			}
			if (typeof $fileProgressContainer !== "undefined" && $fileProgressContainer !== null) {
				$fileProgressContainer.find(".btnClose").hide();
				$fileProgressContainer.find(".btnClose").off("click");
			}
		}
	}
};

fileProgress.updateProgress = function(fileprogressMap) {
	if (!isUiInitialized) {
		return;
	}
	if (typeof fileprogressMap !== "undefined" && fileprogressMap !== null) {
		if (typeof $fileProgressContainer !== "undefined" && $fileProgressContainer !== null) {
			var keys = fileprogressMap.getKeys();
			if (keys.length > 0 && typeof $progressFilesUl !== "undefined" && $progressFilesUl !== null) {
				for (var index = 0; index < keys.length; index++) {
					var fileInfo = fileprogressMap.get(keys[index]);
					$progressFilesUl.append(Mustache.render(listTemplate, fileInfo));
				}
				singleRowHeight = $progressFilesUl.find("li").outerHeight() + 1;
				headersHeight = $progressHeader.outerHeight() + $progressOptions.outerHeight();
			}
		}
	}
};

fileProgress.bindEvents = function() {
	$progressFilesUl.off("click");
	$progressFilesUl.on("click", ".btnCancel", function(e) {
		var $this = $(this);
		var fileId = $this.parent().data("file-id");
		uploadFile.cancel(fileId);
	});
	$progressOptions.off("click");
	$progressOptions.on("click", ".btnCancelAll", function(e) {
		uploadFile.cancelAll();
		$(".notpicked").removeClass("notpicked").addClass("cancelled").find(".fileProgress")
				.css("visibility", "hidden");
		$(".btnCancelAll").hide();
	});
	$progressOptions.on("click", ".btnClearAll", function(e) {
		$(".progressListWrapper .fileRow.up.cancelled").remove();
		$(".progressListWrapper .fileRow.up.error").remove();
		$progressHeader.find(".progressCompleteCount").text("");
		$progressHeader.find(".progressPercentage").text("");
		$(".btnClearAll").hide();
	});

	$(".progressHeader").off("click");
	$(".progressHeader").on("click", function(e) {
		fileProgress.collapseToggle();
		e.stopPropagation();
		e.preventDefault();
	});
};

fileProgress.unbindEvents = function() {
	$progressFilesUl.off("click");
	$progressOptions.off("click");
	$(".btnCollapseToggle").off("click");
};

fileProgress.collapseToggle = function(forceOpen) {
	if (typeof $fileProgressContainer !== "undefined" && $fileProgressContainer !== null) {
		if (!forceOpen) {
			if ($fileProgressContainer.hasClass("collapsed")) {
				fileProgress.bindEvents();
			} else {
				$fileProgressContainer.height(totalHeight);
			}
			setTimeout(function() {
				$fileProgressContainer.toggleClass("collapsed expanded");
			}, 20);
		} else {
			fileProgress.bindEvents();
			setTimeout(function() {
				$fileProgressContainer.height("");
			}, 500);
			setTimeout(function() {
				$fileProgressContainer.removeClass("collapsed");
			}, 20);
		}
	}
};

fileProgress.removeDialog = function() {
	$("#progressContainer").hide().addClass("hidden");
	if (typeof $fileProgressContainer !== "undefined" && $fileProgressContainer !== null) {
		$fileProgressContainer.hide().addClass("hidden");
	}
	uploadFile.cleanUp();
	if (typeof $progressFilesUl !== "undefined" && $progressFilesUl !== null) {
		$progressFilesUl.empty();
	}

	delete $progressFilesUl;
	delete $progressHeader;
	delete $progressStatus;
	delete $progressOptions;
	delete $fileProgressContainer;
	delete singleRowHeight;
	delete headersHeight;
	delete listHeight;
	delete totalHeight;
};

fileProgress.initProgressDialog = function() {
	fileProgress.initGlobalVars();
	$("#progressContainer").show().removeClass("hidden");
	$fileProgressContainer.show().removeClass("hidden");
	if ($(".progressListWrapper .fileRow.up.cancelled").length == 0 &&
			$(".progressListWrapper .fileRow.up.error").length == 0) {
		$(".btnClearAll").hide();
	} else {
		$(".btnClearAll").show();
	}
	fileProgress.bindEvents();
	$fileProgressContainer.removeClass("expanded collapsed").addClass("expanded");
	isUiInitialized = true;
};
