<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="upload.action.fileOf" var="fileOf" />
	<fmt:message key="upload.action.filedone" var="filedone" />
	<fmt:message key="upload.action.Progress" var="fileProgress" />
	<fmt:message key="upload.action.PostProcess" var="filePostProcess" />
	<fmt:message key="upload.action.Complete" var="uploadCompleted" />
	<fmt:message key="upload.action.cancelError" var="cancelError" />
	<fmt:message key="upload.action.pauseError" var="pauseError" />
	<fmt:message key="upload.action.removeError" var="removeError" />
	<fmt:message key="upload.action.resumeError" var="resumeError" />
	<fmt:message key="upload.action.fileDuplicateError" var="fileDuplicateError" />
	<fmt:message key="upload.action.fileLockError" var="fileLockError" />
	<fmt:message key="upload.action.maxFilesError" var="maxFilesError" />
	<fmt:message key="upload.action.minFileSizeError" var="minFileSizeError" />
	<fmt:message key="upload.action.maxFileSizeError" var="maxFileSizeError" />
	<fmt:message key="upload.action.matchFileNameError" var="matchFileNameError" />
	<fmt:message key="upload.action.matchFileExtensionError" var="matchFileExtensionError" />
	<fmt:message key="upload.error.fileshareName" var="fileshareNameError" />
	<fmt:message key="upload.error.fileshareOneFile" var="fileshareOneFileError" />
	<fmt:message key="upload.error.folderUploadError" var="folderUploadError" />
	<fmt:message key="backupBrowse.label.loadMoreFolders" var="showMore" />
	<fmt:message key="upload.error.folderDropUploadError" var="folderDropUploadError" />
	<fmt:message key="upload.label.cancelled" var="cancelled" />
	<fmt:message key="upload.label.resume" var="resume" />
	<fmt:message key="upload.label.postprocess" var="postprocess" />
	<fmt:message key="upload.action.ProgressHeader" var="progressHeader" />
	<fmt:message key="upload.action.CompleteHeader" var="completeHeader" />
	<fmt:message key="upload.action.PartialHeader" var="partialHeader" />
	<fmt:message key="upload.action.ErrorHeader" var="errorHeader" />
	<fmt:message key="upload.action.CancelHeader" var="cancelHeader" />
	

	<c:set var="fileOf" value=" ${fileOf} "/>
</fmt:bundle>

<link rel="stylesheet" href="${pageContext.request.contextPath}/upload/css/fileprogress.css?${applicationScope.BUILD_TS}" />

<script nonce="${sessionScope.cspNonce}" >
localMsg.fileOf = "${fileOf}";
localMsg.filedone = "${filedone}";
localMsg.fileProgress = "${fileProgress}";
localMsg.filePostProcess = "${filePostProcess}";
localMsg.uploadCompleted = "${uploadCompleted}";
localMsg.cancelError = "${cancelError}";
localMsg.pauseError = "${pauseError}";
localMsg.removeError = "${removeError}";
localMsg.resumeError = "${resumeError}";
localMsg.fileDuplicateError = "${fileDuplicateError}";
localMsg.fileLockError = "${fileLockError}";
localMsg.maxFilesError = "${maxFilesError}";
localMsg.minFileSizeError = "${minFileSizeError}";
localMsg.maxFileSizeError = "${maxFileSizeError}";
localMsg.matchFileNameError = "${matchFileNameError}";
localMsg.matchFileExtensionError = "${matchFileExtensionError}";
localMsg.fileshareNameError = "${fileshareNameError}";
localMsg.fileshareOneFileError = "${fileshareOneFileError}";
localMsg.folderUploadError = "${folderUploadError}";
localMsg.showMore = "${showMore}";
localMsg.folderDropUploadError = "${folderDropUploadError}";
localMsg.cancelled = "${cancelled}";
localMsg.resume = "${resume}";
localMsg.postprocess = "${postprocess}";
localMsg.progressHeader = "${progressHeader}";
localMsg.completeHeader = "${completeHeader}";
localMsg.partialHeader = "${partialHeader}";
localMsg.errorHeader = "${errorHeader}";
localMsg.cancelHeader = "${cancelHeader}";
</script>

<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/upload/js/uploader.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/upload/js/fileprogress.js?${applicationScope.BUILD_TS}"></script>
