<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="upload.action.CancelAll" var="cancelAll" />
	<fmt:message key="upload.action.ClearAll" var="clearAll" />
	<c:if test="${param.showNoteText}">
		<c:set var="incHeight" value="withNoteText" />
	</c:if>
	<div id="fileProgressContainer" class="fileProgressContainer ${incHeight} ${fn:escapeXml(param.appType)}">
		<div class="progressHeader">
			<span class="progressStatus"></span>
			<span class="progressUpdate">
				<span class="progressCompleteCount"></span>
				<span class="progressPercentage"></span>
			</span>
			<span class="btnClose"></span>
		</div>
		<c:if test="${param.showNoteText}">
			<div class="progressNoteText">
				<c:choose>
					<c:when test="${fn:escapeXml(param.appType) == 'SYNCFOLDER' }">
						<fmt:message key="upload.label.tryOutUploadTool">
							<fmt:param value="<a href='https://cloud.commvault.com/webconsole/downloadcenter/packageDetails.do?packageId=2938&status=0&type=details' target='_blank'>" />
							<fmt:param value="</a>" />
						</fmt:message>
					</c:when>
					<c:otherwise>
						<fmt:message key="upload.label.restoreScreenNote"/>
					</c:otherwise>
				</c:choose>
			</div>
		</c:if>
		<div class="progressOptions">
			<span class="btnClearAll">${clearAll}</span>
			<span class="btnCancelAll">${cancelAll}</span>
		</div>
		<div class="progressFiles">
			<div class="progressListWrapper">
				<ul></ul>
			</div>
		</div>
	</div>
</fmt:bundle>
