<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>
<!--   For Adding Nodes to existing Scale-out storage pool -->
<div class="setup-title">
	<h1>{{updateScaleoutSP.title}}</h1>
</div>
<div class="setup-content bootstrap-wrapper" >
	<form name="scaleoutOperationsForm" class="form-horizontal" novalidate data-cv-submit="updateScaleoutSP.updateStoragePool()" autocomplete="off" >
		<div class="panel">
			<div class="panel-body">
					<div class="form-group margin-bottom-10" data-ng-if="updateScaleoutSP.action=='ADD'">
							<label for="MediaAgents" class="col-xs-3 col-lg-3"><cv:msg key="label.nodes"
										bundle="storage" />
							</label>
							<div class="text-center {{updateScaleoutSP.generalSetupMessage.type}} serverMessage">
							         {{updateScaleoutSP.generalSetupMessage.message}}</div>
							<div class="col-xs-9 col-lg-9">
									<isteven-multi-select id="MediaAgents" name="MediaAgents"
										input-model="updateScaleoutSP.mediaAgentList"
										output-model="updateScaleoutSP.globalTemplate.agentList"
										button-label="displayName" item-label="displayName" tick-property="ticked"
										class="isteven-multi-select user-group-select"
										title="{{updateScaleoutSP.selectedMediaAgents}}"
										helper-elements = "all none filter"
										min-search-length="1"
										search-property="displayName"
										on-item-click="updateScaleoutSP.mediaAgentSelection()">
									</isteven-multi-select>
									<div class="help-block"
										data-ng-show="updateScaleoutSP.showMediaAgentErrorMessage">
										<i class="ion-alert-circled"></i> <span
											data-ng-bind-html="updateScaleoutSP.showMediaAgentErrorMessage"></span>
									</div>
							</div>
					</div>
			</div>
		</div>
		<div class="button-container">
			<button id="updateScaleoutStoragepool_button_#8329" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="updateScaleoutSP.cancel()"> 
				<cv:msg key="Cancel" bundle="messages"/>
			</button>
			<button id="updateScaleoutStoragepool_button_#9603" class="btn btn-primary cvBusyOnAjax" type="submit"> 
					<cv:msg key="action.add" bundle="storage"/>
			</button>
		</div>
	</form>
</div>
