<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="row">
<div class="col-xs-12 col-lg-12">
<div class="setup-section padding-top-0">
<div class="text-center">
	<p class="{{dedupeInfoMessage.type}} serverMessage">{{dedupeInfoMessage.message}}</p>
</div>
	<div class="bootstrap-wrapper margin-reset form-horizontal">
	<div class="panel panel-default">
	<div class="panel-body">
	<cv-tile-component data-ac-id="label_PartitionSettings-storage" min-height="true">
		<h4><cv:msg key="label.PartitionSettings" bundle="storage" /></h4>
		<form name="dedupeInfoForm" novalidate>
			<div class="form-group" data-ng-if="ddbAgentList.length > 0" >
				<label class="col-xs-12 col-md-4 col-lg-4" for="dedupeMediaAgent"><cv:msg key="label.mediaAgentName" bundle="storage" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<select id="dedupeMediaAgent"
						name="dedupeMediaAgent"
						data-ng-model="globalTemplate.dedupeMediaAgent"
						data-ng-change="setDDBClientType()"
						data-ng-options="agent.displayName for agent in ddbAgentList track by agent.mediaAgentId">
						<option value=""><cv:msg key="placeholder.mediaAgent" bundle="storage" /></option>
					</select>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="partitionPath"><cv:msg key="label.partitionPath"  bundle="storage" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<div class="input-group">
						<input type="text" name="partitionPath" id="partitionPath" data-ng-model="globalTemplate.partitionPath" required data-ng-pattern='ddbPathPattern.pattern' />
						<span class="input-group-btn">
							<button data-ng-disabled="!globalTemplate.dedupeMediaAgent" id="browseDDBInfo" type="button" data-ng-click="browseForPartitionPath()" class="btn btn-default">
								<cv:msg key="Browse" bundle="storage" />
							</button>
						</span>
					</div>
				</div>
				<div class="col-xs-12 col-md-8 col-lg-8 col-lg-offset-4">
					<a data-ng-if="hideEdit" id="addDDBInfo" data-ng-class="{'disabled' : partitionList.length === 4}" data-ng-click="add()" title="<cv:msg key='action.addPartition'  bundle='storage' />">
						<cv:msg key="action.addPartition"  bundle="storage" />
					</a>
				</div>
				<div class="col-xs-12 col-md-8 col-lg-8 col-lg-offset-4">
					<a data-ng-if="hideAdd" id="editDDBInfo" data-ng-click="add()" title="<cv:msg key='action.editPartition'  bundle='storage' />">
						<cv:msg key="action.editPartition"  bundle="storage" />
					</a>
				</div>
			</div>
		</form>
	</cv-tile-component>
	<cv-tile-component data-ng-if="partitionList.length > 0" data-ac-id="label_partitionList-storage" min-height="true">
		<h4><cv:msg key="label.partitionList"  bundle="storage" /></h4>
		<ol class="schedules-list list-style__row group" data-ng-repeat="partition in partitionList track by $index">
			<li class="break-all-text">
				<span><a data-ng-click="editPartition(partition, $index)" title ="{{partition.displayName}}">{{partition.displayName}}</a></span>
				<span class="delete-row">
					<a href="javascript:void(0);"
						data-ng-click="deletePartition($index)"
						title="remove {{partition.displayName}}">
						<span class="glyphicon glyphicon-remove"></span>
					</a>
				</span>
			</li>
		</ol>
	</cv-tile-component>
	</div></div>
	<div class="button-container">
		<button id="dedupeInfoTabStoragePool_button_#2122" type="button" data-ng-click="goPreviousStep()" 
			class="btn btn-primary cvBusyOnAjax"><cv:msg key="label.previous" bundle="storage" /></button>
	 	<button id="submitForCreatePool" type="button" data-ng-click="savededupeInfoTab()"
			class="btn btn-primary cvBusyOnAjax"><cv:msg key="label.finish" bundle="storage" /></button>
	</div>
	</div><!-- //end bootstrap-wrapper // -->
</div><!-- //end setup-section // -->
</div>
</div>