<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-xs-12">
		<div class="setup-title">
			<h1>
				<cv:msg key="action.addStoragePool" bundle="storage" />
			</h1>
		</div>
	</div>
	<div class="setup-section padding-top-0">
		<form class="form-horizontal" data-cv-submit="saveGeneralTab()" name="tapeStoragePoolForm" autocomplete="off"
			novalidate>
			<div class="text-center">
				<div class="{{generalSetupMessage.type}} serverMessage">{{generalSetupMessage.message}}</div>
			</div>
			<div class="bootstrap-wrapper margin-reset">
				<div class="col-xs-12">
					<div class="panel panel-default">
						<div class="panel-body">
							<!-- // name // -->
							<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="storagePoolName">
									<cv:msg key="Name" bundle="storage" /></label>
								<div class="col-xs-12 col-md-8 col-lg-8">
									<input id="storagePoolName" type="text" name="storagePoolName"
										data-ng-model="globalTemplate.name" required autofocus />
								</div>
							</div>
							<!-- // name // -->
							<cv-tile-component data-ac-id="label_configureStorage-storage">
								<div class="component-container">
									<div class="{{generalSetupMessage.type}} serverMessage">
										{{configureStorageInfoMessage.message}}
									</div>
								</div>
								<div class="form-group">
									<label class="col-xs-12 col-md-4 col-lg-4" for="storage">
										<cv:msg key="label.SECONDARYCOPYSP" bundle="storage" /></label>
									<div class="col-xs-12 col-md-8 col-lg-8">
										<select id="tapeStorage" name="tapeStorage"
											data-ng-model="globalTemplate.configureStorage.library"
											data-ng-change="getLibrayDetails()"
											data-ng-options="lib.name for lib in libraries track by lib.id"
											ng-disabled="disableOption">
											<option value="">
												<cv:msg key="label.selectStorage" bundle="storage" />
											</option>
										</select>
									</div>
								</div>
								<div class="form-group">
									<div class="col-xs-12">
										<input type="checkbox" model="options.primary" id="tape-primary">
										<label for="tape-primary">
											<cv:msg key="label.tapePrimaryBackup" bundle="storage" />
										</label>
									</div>
									<div class="col-xs-12">
										<input type="checkbox" model="options.secondary" id="tape-secondary">
										<label for="tape-secondary">
											<cv:msg key="label.tapeSecondaryBackup" bundle="storage" />
										</label>
									</div>
								</div>
							</cv-tile-component>
						</div>
					</div>
				</div>
				<div class="button-container">
					<button id="createTapeStoragePool_button_#4249" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" 
						data-ng-click="closeModal()">
						<cv:msg key="Cancel" bundle="messages" />
					</button>
					<button id="createTapeStoragePool_button_#7500" type="submit" class="btn btn-primary cvBusyOnAjax"> 
						<cv:msg key="action.save" bundle="storage" />
					</button>
				</div>
			</div>
		</form>
	</div>
</div>