<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>
<div data-ng-controller="selectStoragePoolTypeController">
    <!-- For Tenant Admin && Tenant Operator who has their own storage-->
    <div data-ng-if="showStorageSelection">
            <div class="setup-title">
                <h1>
                    <cv:msg key="title.addLibrary" bundle="storage"/>
                    <cv-help-component help-text="<cv:msg key="label.storagePoolHelpText" bundle="storage"/>"></cv-help-component>
                </h1>
            </div>


            <div class="form-group title margin-left-20">
                <div class="storage-radio-tiles" data-ng-class="{ 'col-xs-12': !!repGrp, 'col-xs-8': !repGrp }">
                    <div class="btn col col-md-3 radio-tile radio-tile-left storage-radio-tile" ng-class="{'storage-selected-tile': storageType === 'DISK'}" ng-click="updateStorageSelectionType('DISK')">
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"><path d="M2,16v2.5A3.6,3.6,0,0,0,3.2,21c1.7,1.8,5.3,3,9.3,3s7.6-1.2,9.3-3A3.6,3.6,0,0,0,23,18.5V16c-2,2.1-5.9,3.5-10.5,3.5S4,18.1,2,16Z"></path><ellipse cx="12.5" cy="6.5" rx="10.5" ry="5.5"></ellipse><path d="M12.5,13.5C7.9,13.5,4,12.1,2,10v2.5c0,3,4.7,5.5,10.5,5.5S23,15.5,23,12.5V10C21,12.1,17.1,13.5,12.5,13.5Z"></path></svg>
                        <h4 class="no-margin"><cv:msg key="label.disk" bundle="storage"/></h4>
                    </div>
                    <div class="btn col col-md-3 radio-tile storage-radio-tile" ng-class="{'storage-selected-tile': storageType === 'METALLIC'}" ng-click="updateStorageSelectionType('METALLIC')">
                    	<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
						 viewBox="0 0 238.2 143.1" style="enable-background:new 0 0 238.2 143.1;" xml:space="preserve">
							<style type="text/css">
								.st0{fill:#33058D;}
								.st1{fill:#DDE5ED;}
								.st2{fill:#BABED5;}
								.st3{fill:#794DE8;}
								.st4{fill:#132E53;}
							</style>
							<g>
								<g>
									<g>
										<g>
											<polygon class="st3" points="6.7,7.1 133.7,85.5 111,99.6 6.7,35.1 				"/>
										</g>
										<g>
											<polygon class="st3" points="92.9,110.8 6.7,57.5 6.7,85.5 70.2,124.8 				"/>
										</g>
										<g>
											<polygon class="st3" points="6.7,107.9 52.2,136 6.7,136 				"/>
										</g>
									</g>
									<g>
										<polygon class="st0" points="88.4,136 215.4,57.5 215.4,85.5 133.8,136 			"/>
									</g>
									<g>
										<polygon class="st0" points="215.4,107.9 169.9,136 215.4,136 			"/>
									</g>
									<g>
										<polygon class="st0" points="215.4,7.1 6.7,136 52.1,136 215.4,35.1 			"/>
									</g>
								</g>
								<g>
									<g>
										<path class="st4" d="M225.7,131.7H224v4.3h-0.6v-4.3h-1.7v-0.6h4V131.7z"/>
										<path class="st4" d="M231.4,136h-0.6v-3.1l0.1-1.3h0l-1.6,4.4h-0.5l-1.6-4.4h0l0.1,1.3v3.1h-0.6v-4.9h0.9l1.1,3l0.4,1.2h0
											l0.4-1.2l1.1-3h0.9V136z"/>
									</g>
								</g>
							</g>
						</svg>
                        <h4 class="no-margin"><cv:msg key="label.Metallic" bundle="storage"/></h4>
                    </div>
                    <div class="btn col col-md-3 radio-tile storage-radio-tile" ng-class="{'storage-selected-tile': storageType === 'CLOUD'}" ng-click="updateStorageSelectionType('CLOUD')">
                        <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 500"><path d="M381.2 416.7H131.9C59.2 416.7 0 359 0 288.2s59.2-128.5 131.9-128.5a132.2 132.2 0 0 1 35.2 4.8 132 132 0 0 1 122.2-81.2c65.6 0 119.7 45.9 129.7 108.2 48.2 15.7 81 59.5 81 109.4 0 63.9-53.3 115.8-118.8 115.8zM131.9 188.3c-57.4 0-104.2 45.2-104.2 100.7s46.7 100.7 104.2 100.7h249.2c50.2 0 91.1-39.4 91.1-88a88.4 88.4 0 0 0-69.1-85.1l-9.8-2.3-.8-10a101.8 101.8 0 0 0-103.2-92.4c-46.7 0-87.9 30.7-100.1 74.6l-4.1 14.8-14.3-5.6a107.4 107.4 0 0 0-38.9-7.4z"/></svg>
                        <h4 class="no-margin"><cv:msg key="label.cloud" bundle="storage"/></h4>
                    </div>
                    <div class="btn col col-md-3 radio-tile radio-tile-right storage-radio-tile" ng-class="{'storage-selected-tile': storageType === 'HYPERSCALE'}" ng-click="updateStorageSelectionType('HYPERSCALE')">
                        <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path d="M1,15a2.2,2.2,0,0,0,.3,1c0.7,1.3,2.7,2.4,5.2,2.8V15.3A10.5,10.5,0,0,1,1,13v2Z"/><path d="M1.6,8.5L1,8v2c0,1.8,2.3,3.3,5.5,3.8V10.3A11.3,11.3,0,0,1,1.6,8.5Z"/><path d="M8,18v2a2.2,2.2,0,0,0,.3,1c0.9,1.7,4,3,7.7,3s6.8-1.3,7.7-3a2.2,2.2,0,0,0,.3-1V18c-1.7,1.5-4.6,2.5-8,2.5S9.7,19.5,8,18Z"/><path d="M23.4,13.5a13,13,0,0,1-7.4,2,13,13,0,0,1-7.4-2L8,13v2c0,2.2,3.6,4,8,4s8-1.8,8-4V13Z"/><ellipse cx="16" cy="10" rx="8" ry="4"/><path d="M16,4.5h0.9C16.5,2.5,13.1,1,9,1S1,2.8,1,5,3.4,8.3,6.7,8.8C7.6,6.3,11.3,4.5,16,4.5Z"/></svg>
                        <h4 class="no-margin"><cv:msg key="label.scaleout" bundle="storage"/></h4>
                    </div>
                </div>
            </div>
            <div data-ng-if="storageType ==='DISK'" class="storage-disk">
                <data-ng-include data-ng-controller="createStoragePoolController" src="storagePoolGeneralTemplate"></data-ng-include>
            </div>
            <div data-ng-if="storageType === 'METALLIC'" class="storage-cloud">
                <data-ng-include data-ng-controller="addMetallicCloudController" src="appUtil.appRoot + 'modules/storage/partials/addCloudMetallicCoreSetup.jsp'" > </data-ng-include>
            </div>
            <div data-ng-if="storageType === 'CLOUD'" class="storage-cloud">
                <data-ng-include data-ng-controller="addStorageController" src="appUtil.appRoot + 'adminConsole/partials/addCloudStorage.jsp'" > </data-ng-include>
            </div>
            <div data-ng-if="storageType === 'HYPERSCALE'" class="storage-cloud">
                <div class="bootstrap-wrapper medium-width setup-content" data-ng-controller="createScaleoutStoragePoolController">
                    <div data-ng-hide="formStorage.hide">
                        <data-ng-include src="appUtil.appRoot + 'webScale/partials/createScaleoutStoragePool.jsp'"></data-ng-include>
                    </div>
                    <div data-ng-if="formStorage.hide">
                        <p class="text-center padding-top-20" data-ng-show="!mspModeOn"><a data-ng-click="changeStorage()"><cv:msg key="label.addAnotherStorage" bundle="storage" /></a></p>
                        <div class="button-container no-margin centered">
                            <button id="storagePoolGeneralTemplate_button_#3367" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()"><cv:msg key="Continue" /></button>
                        </div>
                    </div>
                </div>
            </div>
    </div>
    <!--
        For MSP Admin || Tenant in rented mode
    -->
    <div data-ng-if= "!showStorageSelection">
        <div data-ng-if="!showCloudStorage" class="storage-disk">
                <data-ng-include data-ng-controller="createStoragePoolController" src="storagePoolGeneralTemplate"></data-ng-include>
        </div>
        <div data-ng-if="showCloudStorage">
                <data-ng-include src="appUtil.appRoot + 'adminConsole/partials/addCloudStorage.jsp'" > </data-ng-include>
        </div>
    </div>

</div>
