<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
		<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<h1 class="page-title">
	<span class="name"> {{clientName}} </span>
</h1>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="nfsStoreDetails-title_general-storage"
			data-title='<cv:msg key="title.general" bundle="storage" />'>
		<div class="page-details-box-links">
			<a href=""
				data-ng-click="openConfigureNfsStorePropertiesModal('general')"><cv:msg
					key="action.edit" bundle="storage" /></a>
		</div>
		<ul class="list-style-secondary">
			<li class="group"><span class="pageDetailColumn"><cv:msg key="label.networkStore.mountPath" bundle="storage"/></span>
			<div class="pageDetailColumn">/<span  data-ng-bind="subClientEntity.subclientName"></span></div></li>
			<li data-ng-if="!isReady" class="group"><span class="pageDetailColumn"><cv:msg key="label.networkStore.status" bundle="storage"/></span> <span
				class="pageDetailColumn" data-ng-bind="status"></span></li>
			<li class="group"><span class="pageDetailColumn"><cv:msg key="label.networkStore.nfsServer" bundle="storage"/></span>
				<span class="pageDetailColumn"
				data-ng-bind="serverInfo.nfsServer.mediaAgentName"></span></li>
			<li class="group" data-ng-if="serverInfo.plan.planName"><span class="pageDetailColumn"><cv:msg key="title.plan" bundle="storage"/></span> <span class="pageDetailColumn" data-ng-bind="serverInfo.plan.planName"></span>
			</li>
			<li class="group"><span class="pageDetailColumn"><cv:msg key="label.networkStore.nfsClients" bundle="storage"/></span> <span class="pageDetailColumn"
				data-ng-bind="serverInfo.nfsClients.toString()"></span></li>
			<li class="group"><span class="pageDetailColumn"><cv:msg key="label.networkStore.accessType" bundle="storage"/></span> <span class="pageDetailColumn" data-ng-bind="accessType"></span>
			</li>
			<!--  <li class="group"><span class="pageDetailColumn"><cv:msg key="label.networkStore.useVersions" bundle="storage"/></span> <toggle-control class={{useVersions}} status="useVersions"
					bundle='storage' data-ng-click="updateUseVersions()"></toggle-control>
			</li>-->
			<li class="group" data-ng-if="protocolTypes != 'SMB'"><span class="pageDetailColumn"><cv:msg key="label.networkStore.squashType" bundle="storage"/></span> <span class="pageDetailColumn" data-ng-bind="squashType"></span>
			</li>
			<li data-ng-if="squashType !== 'No Root Squash'" class="group"><span class="pageDetailColumn"><cv:msg key="label.networkStore.anonUID" bundle="storage"/></span>
				<span class="pageDetailColumn"
				data-ng-bind="serverInfo.anonUID.toString()"></span></li>
			<li data-ng-if="squashType !== 'No Root Squash'" class="group"><span class="pageDetailColumn"><cv:msg key="label.networkStore.anonGID" bundle="storage"/></span>
				<span class="pageDetailColumn"
				data-ng-bind="serverInfo.anonGID.toString()"></span></li>
			<li class="group"><span class="pageDetailColumn"><cv:msg key="label.networkStore.supportedProtocols" bundle="storage"/></span> <span class="pageDetailColumn"
				data-ng-bind="protocolTypes.toString()"></span></li>

			<!-- li class="group">
                    <span class="pageDetailColumn">Enable ACLs</span>
                    <span class="pageDetailColumn" data-ng-bind="serverInfo.enableAcls.toString()"></span>
                </li-->
			<!--  <li class="group" ><span class="pageDetailColumn"><cv:msg key="label.networkStore.fileTypeFilter" bundle="storage"/></span>
				<span class="pageDetailColumn"
				data-ng-bind="serverInfo.nfsObjBackupFilter"></span></li>  -->


		</ul>
		</cv-tile-component>
	</div>

	<div class="col-md-6">
		<cv-tile-component data-ac-id="nfsStoreDetails-title_retention"
			data-title='<cv:msg key="title.retention" bundle="storage" />'>
			<div class="page-details-box-links">
				<a data-ng-click="openConfigureNfsStorePropertiesModal('retention')"><cv:msg
						key="action.edit" bundle="storage" /></a>
			</div>

			<ul class="list-style-secondary">
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.retentionPeriodForDeletedFiles" bundle="storage"/></span>
					<div data-ng-if="!edgeSubclientPolicyProp.isIndefiniteRetention" class="pageDetailColumn"><span data-ng-bind="edgeSubclientPolicyProp.retentionInDays.label"></span></div>
					<span class="pageDetailColumn" data-ng-if="edgeSubclientPolicyProp.isIndefiniteRetention"><cv:msg key="label.infinite" bundle="storage"/></span>
				</li>

				<li class="group" data-ng-if="!serverInfo.useVersions"><span class="pageDetailColumn"><cv:msg key="label.networkStore.versions" bundle="storage"/></span>
					<span class="pageDetailColumn"><cv:msg key="label.disabled" bundle="storage"/></span>
				</li>

				<div data-ng-if="serverInfo.useVersions">
					<li class="group"><span class="pageDetailColumn"><cv:msg key="label.retentionPeriodForVersions" bundle="storage"/></span>
						<div class="pageDetailColumn" data-ng-if="edgeSubclientPolicyProp.enableRetentionRulesForVersions">
							<span data-ng-bind="edgeSubclientPolicyProp.versionsRetentionInDays.label"></span>
						</div>
						<span class="pageDetailColumn" data-ng-if="!edgeSubclientPolicyProp.enableRetentionRulesForVersions"><cv:msg key="label.infinite" bundle="storage"/></span>
					</li>

					<li class="group"><span class="pageDetailColumn"><cv:msg key="label.retention.minNoOfVersions" bundle="storage"/></span>
						<span data-ng-if="edgeSubclientPolicyProp.enableRetentionRulesForVersions" class="pageDetailColumn" data-ng-bind="edgeSubclientPolicyProp.minNoOfVersions"></span>
						<span class="pageDetailColumn" data-ng-if="!edgeSubclientPolicyProp.enableRetentionRulesForVersions"><cv:msg key="label.infinite" bundle="storage"/></span>
					</li>

					<li class="group"><span class="pageDetailColumn"><cv:msg key="label.retention.versionInterval" bundle="storage"/></span>
						<span data-ng-if="serverInfo.versionInterval" class="pageDetailColumn" >{{serverInfo.versionInterval}} <cv:msg key="label.networkStore.minutes" bundle="storage"/></span>
						<span class="pageDetailColumn" data-ng-if="!serverInfo.versionInterval"><cv:msg key="label.infinite" bundle="storage"/></span>
					</li>
				</div>

			</ul>
		</cv-tile-component>
	</div>
</div>
<cv-grid cv-grid-options="nfsStoresPITListGridOptions"> </cv-grid>
