<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<h1 class="page-title">
    <span class="name">
		 {{mediaAgentInfo.mediaAgent.displayName}}
    </span>
</h1>
<div class="row">
    <div class="col-md-6">
	    <cv-tile-component data-ac-id="mediaAgentDetails-title_general-storage" data-title='<cv:msg key="title.general" bundle="storage" />'>
			<ul class="list-style-secondary">
				<li class="group">
				    <span class="pageDetailColumn"><cv:msg key="label.mediaAgent" bundle="storage" /></span>
				    <span class="pageDetailColumn" data-ng-bind="mediaAgentInfo.mediaAgent.mediaAgentName"></span>
				</li>
				<li class="group">
				    <span class="pageDetailColumn"><cv:msg key="label.os" bundle="storage" /></span>
				    <span class="pageDetailColumn" data-ng-bind="mediaAgentInfo.osInfo.OsDisplayInfo.OSName"></span>
				</li>
				<li class="group">
				    <span class="pageDetailColumn"><cv:msg key="header.Version" bundle="clients" /></span>
				    <span class="pageDetailColumn" data-ng-bind="mediaAgentInfo.versionInfo.GalaxyRelease.ReleaseString | getVersionString"></span>
				</li>
				<li class="group">
				    <span class="pageDetailColumn"><cv:msg key="label.status" bundle="storage" /></span>
				    <span class="pageDetailColumn" data-ng-bind="statusUpdater.statusString"></span>
				</li>
				<li class="group" data-ng-if="statusUpdater.statusString == 'Offline'">
				    <span class="pageDetailColumn"><cv:msg key="label.offlineReason" bundle="storage" /></span>
				    <span class="pageDetailColumn" data-ng-bind="mediaAgentInfo.statusDescription"></span>
				</li>
				<li class="group">
				    <span class="pageDetailColumn"><cv:msg key="label.description" bundle="archiving" /></span>
					<!-- perform edit in line in description field -->
					<div class="pageDetailColumn">
						<span data-ng-if="!isEditingDescription">
							{{mediaAgentInfo.description}}
							<a class="horizontal-link-button" data-ng-click="turnOnEditDescription()">
								<i class="glyphicon glyphicon-pencil"></i>
							</a>
						</span>
						<div data-ng-if="isEditingDescription">
							<div class="inline-block width-50-percentage">
								<textarea name="description" 
									id="edit-description-textarea" 
									data-ng-model="model.description" 
									class="ng-pristine ng-valid ng-empty ng-touched"></textarea>
							</div>
							<a class="inline-editor-button" data-ng-click="updateDescrption()"><i class="k-icon k-i-check"></i></a>
							<a class="inline-editor-button" data-ng-click="cancelInlineEditAction('description')"><i class="k-icon k-i-close"></i></a>
						</div>
					</div>
					<!--// perform edit in line in description field -->

				</li>
			</ul>
		</cv-tile-component>
		<cv-tile-component data-ac-id="mediaAgentDetails-label_catalog-storage" data-title='<cv:msg key="label.catalog" bundle="storage"/>'>
			<div class="page-details-box-links">
				<a href="" data-ng-click="openConfigureMAPropertiesModal('index')"><cv:msg key="action.edit" bundle="storage" /></a>
			</div>
			<ul class="group list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.indexDirectory" bundle="profiles" /></span>
					<span class="pageDetailColumn" data-ng-bind="mediaAgentInfo.mediaAgentProps.indexDirectory.path"></span>
				</li>
<!-- 			Hide this element until backend is able to support retention period	
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.retentionperiod" bundle="archiving" /></span>
					<span class="pageDetailColumn" data-ng-bind="mediaAgentInfo.mediaAgentProps.indexRetentionDays"></span>
				</li> -->
			</ul>
			<ul class="margin-top-10 group list-style-secondary">
				<li class="group">
					<span class="col-sm-5 col-xs-12 text-align-left padding-left-0 pageDetailColumn">
						<cv:msg key="label.cacheSlider" bundle="profiles"/>
					</span>
					<toggle-control
						class="margin-right-5 logs-cache-toggle"
						status="showTileLogsCache ? 'enabled-activity' : 'disabled-activity'"
						data-ng-click="onToggleTileCache()">
					</toggle-control>
				</li>
			</ul>
			<ul data-ng-if="showTileLogsCache" class="group list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.cacheDirectory" bundle="profiles" /></span>
					<span class="pageDetailColumn" data-ng-bind="mediaAgentInfo.mediaAgentProps.indexLogsCacheInfo.logsCachePath.path"></span>
				</li>
			</ul>
		</cv-tile-component>
	</div>
	<div class="col-md-6">
		<cv-tile-component data-ac-id="mediaAgentDetails-heading_clientActivityControl-clients" data-title='<cv:msg key="heading.control" bundle="storage" />'>
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.enable" bundle="storage" /></span>
					<span class="pageDetailColumn">
						<toggle-control class={{enableMA}} status="enableMA" bundle='storage' data-ng-click = 'updateMAStatus()'></toggle-control>
					</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.optimizeForLANBackups" bundle="storage" /></span>
					<span class="pageDetailColumn">
						<toggle-control class={{optimizeForLANBackups}} status="optimizeForLANBackups" bundle='storage' data-ng-click = 'updateMADataTransferMode()'></toggle-control>
					</span>
				</li>
				<cv-activity-control 
				label='<cv:msg key="label.maintenanceMode" bundle="storage" />' 
				help-text='<cv:msg key="info.maMaintenanceMode" bundle="storage"/>' 
				ac-params="mediaAgentInfo.mediaAgent" 
				enable-delay ="mediaAgentInfo.mediaAgentProps.enableMAAfterDelay" 
				delay-time="mediaAgentInfo.mediaAgentProps.enableMAAtDateTime" 
				activity-controller="toggleMediaAgentMaintenanceMode" 
				flip="true" enable-backup="mediaAgentInfo.mediaAgentProps.markMAOfflineForMaintenance" 
				activate-delay-string="label.willBeDisabled" enabled-delay-string="label.disableAfterDelay"> </cv-activity-control>
				<li class="group" data-ng-if="!isUnixMA">
					<span class="pageDetailColumn"><cv:msg key="label.ransomWareProtection" bundle="storage" /></span>
					<span class="pageDetailColumn">
						<toggle-control status="ransomwareStatus" bundle='storage' data-ng-click='updateMARansomWareStatus()'></toggle-control>
					</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn padding-top-10 "><cv:msg key="label.noOfDataTransferOps" bundle="storage" /></span>
					<!-- perform edit in line in Parallel data transfer operations field -->
					<div class="pageDetailColumn">
						<div class="padding-top-10 margin-bottom-10" data-ng-if="!isEditingParallelDataTransferOperations">
							{{mediaAgentInfo.mediaAgentProps.maxNumOfParallelDataTransferOperations}}
							<a class="horizontal-link-button" data-ng-click="turnOnEditnoOfDataTransferOps()">
								<i class="glyphicon glyphicon-pencil"></i>
							</a>
						</div>
						<div data-ng-if="isEditingParallelDataTransferOperations">
							<div class="inline-block width-50-percentage">
								<input type="number" 
								name="noOfDataTransferOps" 
								id="noOfDataTransferOps" 
								data-ng-model="model.noOfDataTransferOps" 
								max="800" min="1">
							</div>
							<a class="inline-editor-button" data-ng-click="updateNoOfDataTransferOps()"><i class="k-icon k-i-check"></i></a>
							<a class="inline-editor-button" data-ng-click="cancelInlineEditAction('noOfDataTransferOps')"><i class="k-icon k-i-close"></i></a>
						</div>
					</div>
					<!--// perform edit in line in Parallel data transfer operations field -->

				</li>
			</ul>
		</cv-tile-component>
		<cv-tile-component
			data-ac-id="mediaAgentDetails-label_catalog-storage"
			data-title='<cv:msg key="label.networkStore.details" bundle="storage" />'
			data-ng-show="nfsCache.display">
			<div class="page-details-box-links">
				<a href="" data-ng-click="openConfigureMAPropertiesModal('hybridFileStoreDetails')"><cv:msg key="action.edit" bundle="storage" /></a>
			</div>
			<ul class="group list-style-secondary">
				<li class="group"><span class="pageDetailColumn"><cv:msg
							key="label.networkStore.cacheDirectory" bundle="storage" /></span>
					<span class="pageDetailColumn"
					data-ng-bind="nfsCache.cacheDirectory"></span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg
							key="label.networkStore.pruneHighWaterMarkPercentage"
							bundle="storage" /></span> <span class="pageDetailColumn"
					data-ng-bind="nfsCache.pruneHighWaterMark"></span></li>
			</ul>
		</cv-tile-component>
		<cv-security-component show-edit='showEdit' entity-type='entityType' generic-entity='genericEntity' associations='formattedSecurityAssociations'
		associations-loaded='associationsLoaded'>
		</cv-security-component>
	</div>
</div>
<div class="row">
	<div class="col-md-6" data-ng-show="mediaAgentInfo.powerManagementInfo.isPowerMgmtSupported">
		<cv-tile-component data-ac-id="mediaAgentDetails-label_Power_Mgnt" data-title='<cv:msg key="title.powerManagement" bundle="storage"/>'>
			<div class="page-details-box-links">
				<a href="" data-ng-click="openConfigureMAPropertiesModal('powerManagement')"><cv:msg key="action.edit" bundle="storage" />
				</a>
			</div>
			<ul class="list-style-secondary">                 
				<li class="group" data-ng-show="!mediaAgentInfo.powerManagementInfo.isPowerManagementEnabled">                    
					<span class="pageDetailColumn" ><cv:msg key="label.powerManagementDisabledMediaAgent" bundle="storage" /> </span>
				</li>   
				<div  data-ng-show="mediaAgentInfo.powerManagementInfo.isPowerManagementEnabled">                      
					<li class="group" >
						<span class="pageDetailColumn"><cv:msg key="label.cloudController" bundle="storage" /></span>
						<span class="pageDetailColumn" data-ng-bind="mediaAgentInfo.powerManagementInfo.selectedCloudController.clientName"></span>
					</li>
					<li class="group"  >
						<span class="pageDetailColumn"><cv:msg key="label.power" bundle="storage" /></span>
						<span class="pageDetailColumn" data-ng-disabled= 
						"mediaAgentInfo.powerManagementInfo.powerButtonDisabled">
							<toggle-control status="mediaAgentInfo.powerManagementInfo.powerButtonName" bundle='storage'  data-ng-click = 'sendPowerRequest()'></toggle-control>
						</span>
					</li>  
					<li class="group">     	            		
						<span class="pageDetailColumn">						
							<cv:msg key="label.status" bundle="storage"/>
						</span>
						<span  class="pageDetailColumn"> 
							{{mediaAgentInfo.powerManagementInfo.powerStatusValue}}
						</span>	       		
					</li>
					<li class="group" data-ng-if="mediaAgentInfo.powerManagementInfo.FailureReason" >     	   
						<span  class="pageDetailColumn"> 
							<cv:msg key="label.failureReason" bundle="storage"/>
						</span>			
						<span class="pageDetailColumn">
							{{mediaAgentInfo.powerManagementInfo.FailureReason}}
						</span>
					</li>
				</div>
				<li class="group" data-ng-show="!mediaAgentInfo.powerManagementInfo.isPowerMgmtAllowed">
					<span  class="pageDetailColumn"> 
						<cv:msg key="label.powerManagementNotAllowed" bundle="storage" /> 
					</span>
				</li>
			</ul>
	    </cv-tile-component>
	</div>
</div>
