<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-if="general">
		<cv:msg key="label.configureProperties" bundle="storage" />
	</h1>
	<h1 data-ng-if="pit"><cv:msg key="title.editPITViews" bundle="storage" /></h1>
	<h1 data-ng-if="addsnap"><cv:msg key="title.createPITViews" bundle="storage" /></h1>
	<h1 data-ng-if="retention"><cv:msg key="title.retention.properties" bundle="storage" /></h1>
</div>
<div class="setup-content ng-scope"
	data-ng-controller="configureNfsStorePropertiesController">
	<form name="configureNfsStorePropertiesForm" novalidate data-cv-submit="configureNfsStoreProperties()"
		autocomplete="off" id="configureNfsStorePropertiesForm" data-ng-hide="goToCollection || formAddServer.hide" class="bootstrap-wrapper form-horizontal padding-bottom-0 ng-pristine ng-invalid ng-invalid-required ng-valid-pattern">

		<div class="panel panel-default">
		<div class="panel-body">

		<div data-ng-if="general" class="form-group ng-scope">
			<label class="col-xs-12 col-md-4 col-lg-4 ng-binding" for="nfsServer"><cv:msg key="label.networkStore.nfsServer" bundle="storage"/></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<%-- <select name="nfsServer" id="nfsServer" data-ng-required="true"
					data-ng-options="nfsServer.mediaAgent.mediaAgentName for nfsServer in nfsServers"
					data-ng-model="editNode.nfsServer" data-ng-change="changeNFSServer()">
					<option value=""><cv:msg key="hint.select.nfs.server" bundle="storage"/></option>
				</select>
				 <span class="help-block"
					data-ng-show="cv.configureNfsStorePropertiesForm.needsAttention(configureNfsStorePropertiesForm.nfsServer)"><cv:msg key="label.networkStore.nfsServerNeeded" bundle="storage"/></span> --%>
			
				<isteven-multi-select id="nfsServer"
					 data-input-model="nfsServers"
					 on-item-click="fileServerChanged(data)"
					 data-tick-property="selected" data-item-label="nfsServerName"
					 class="isteven-multi-select user-group-select"
					 data-button-label="nfsServerName" data-helper-elements="filter"
					 data-selection-mode="single" translation="localLang">
				</isteven-multi-select>
			</div>
		</div>
		<div data-ng-if="general && editNode.nfsServer && editNode.showPath && !editNode.isNFSCachePathSet.length" class="form-group ng-scope">
			<label class="col-xs-12 col-md-4 col-lg-4 ng-binding" for="nfsCachePath"><cv:msg key="label.networkStore.nfsCachePath" bundle="storage"/></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<div class="input-group">
					<input
						class="data-cache-path"
						type="text" 
						data-ng-model="editNode.nfsCachePath"
						data-ng-required="true" 
						id="path" 
						name="nfsCachePath"
						data-ng-pattern="nfsCachePathPattern"
					/>
					<span class="input-group-btn">
						   <cv-machine-browse
								id="dataFilePathBrowse"
								button-label='<cv:msg key="label.browse" bundle="restore"/>'
								client-id='{{editNode.nfsServer.mediaAgent.mediaAgentId}}'
								result-function="setNFSCachePath">
							</cv-machine-browse>
					</span>
				</div>
				<span class="help-block"
					data-ng-show="cv.configureNfsStorePropertiesForm.needsAttention(configureNfsStorePropertiesForm.nfsCachePath) && !configureNfsStorePropertiesForm.nfsCachePath.$error.pattern">
					<cv:msg key="label.networkStore.nfsCachePathNeeded" bundle="storage"/>
				</span>
				<span 
					class="help-block"
					data-ng-show="configureNfsStorePropertiesForm.nfsCachePath.$error.pattern && cv.configureNfsStorePropertiesForm.needsAttention(configureNfsStorePropertiesForm.nfsCachePath)">
					<cv:msg key="error.networkStoreCache.required" bundle="storage"/>
				</span>
			</div>
		</div>
		<div data-ng-if="general && editNode.nfsServer && editNode.showPath && !editNode.isSolrIndexCachePathSet.length" class="form-group ng-scope">
			<label class="col-xs-12 col-md-4 col-lg-4 ng-binding" for="solrIndexCachePath"><cv:msg key="label.networkStore.indexDirectory" bundle="storage"/></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<div class="input-group">
					<input class="index-cache-path-folder" type="text" data-ng-model="editNode.solrIndexCachePath"
					data-ng-required="true" id="path" name="solrIndexCachePath" data-ng-pattern='indexCachePathPattern'/>

					<span class="input-group-btn">
						<cv-machine-browse
							id="dataFilePathBrowse"
							button-label='<cv:msg key="label.browse" bundle="restore"/>'
							client-id='{{editNode.nfsServer.mediaAgent.mediaAgentId}}'
							result-function="setSolrIndexCachePath">
						</cv-machine-browse>
					</span>
				</div>
				<span 
					class="help-block"
					data-ng-show="cv.configureNfsStorePropertiesForm.needsAttention(configureNfsStorePropertiesForm.solrIndexCachePath) && !configureNfsStorePropertiesForm.solrIndexCachePath.$error.pattern">
					<cv:msg key="label.networkStore.indexCachePathNeeded" bundle="storage"/>
				</span>
				<span 
					class="help-block"
					data-ng-show="configureNfsStorePropertiesForm.solrIndexCachePath.$error.pattern && cv.configureNfsStorePropertiesForm.needsAttention(configureNfsStorePropertiesForm.solrIndexCachePath)">
					<cv:msg key="error.networkStore.required" bundle="storage"/>
				</span>	
			</div>
		</div>
		<div data-ng-if="general" class="form-group ng-scope">
			<label class="col-xs-12 col-md-4 col-lg-4 ng-binding" for="nfsclients"><cv:msg key="label.networkStore.nfsClients" bundle="storage"/></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="text" name="NFS Clients" id="nfsclients" data-ng-model="editNode.nfsClients" required />
				</div>
		</div>
		<div data-ng-if="general" class="form-group ng-scope">
			<label class="col-xs-12 col-md-4 col-lg-4 ng-binding" for="accesstype"><cv:msg key="label.networkStore.accessType" bundle="storage"/></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<select name="squashtype"
					id="accesstype" data-ng-required="true"
					data-ng-options="accesstype.text for accesstype in accesstypes"
					data-ng-model="editNode.accessType">
					</select>
				</div>
		</div>
		<div data-ng-if="general && protocolTypes != 'SMB'" class="form-group ng-scope">
			<label class="col-xs-12 col-md-4 col-lg-4 ng-binding" for="squashtype"><cv:msg key="label.networkStore.squashType" bundle="storage"/></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<select name="squashtype"
					id="squashtype" data-ng-required="true"
					data-ng-options="squashtype.text for squashtype in squashtypes"
					data-ng-model="editNode.squashType">
					</select>
				</div>
		</div>
		<div data-ng-if="general && protocolTypes != 'SMB' && editNode.squashType.id !== 4" class="form-group ng-scope">
			<label class="col-xs-12 col-md-4 col-lg-4 ng-binding" for="anonGID"><cv:msg key="label.networkStore.anonGID" bundle="storage"/></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input min="-2" max="65536"
					type="number" data-ng-model="editNode.anonGID"
					data-ng-required="true" id="anonGID" name="anonGID" />
				</div>
		</div>
		<div data-ng-if="general && protocolTypes != 'SMB' && editNode.squashType.id !== 4" class="form-group ng-scope">
			<label class="col-xs-12 col-md-4 col-lg-4 ng-binding" for="anonUID"><cv:msg key="label.networkStore.anonUID" bundle="storage"/></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input min="-2" max="65536"
					type="number" data-ng-model="editNode.anonUID"
					data-ng-required="true" id="anonUID" name="anonUID" />
				</div>
		</div>
		<div data-ng-if="pit" class="form-group ng-scope">
			<label class="col-xs-12 col-md-4 col-lg-4 ng-binding" for="NFSClient"><cv:msg key="label.networkStore.nfsClients" bundle="storage"/></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="text"
					name="NFS Clients" data-ng-model="editsnap.NFSClient" required
					id="NFSClient" />
				</div>
		</div>

		<div class="modal-footer">
			<button id="configureNetworkStoreProperties_button_#9173" type="button" 
				class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				data-ng-click="dismissModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="configureNetworkStoreProperties_button_#7685" type="submit" class="btn btn-primary cvBusyOnAjax" 
				data-ng-click="configureNfsStoreProperties()">
				<cv:msg key="Save" bundle="messages" />
			</button>
		</div>
		<!-- <div data-ng-if="general">
			<label for="fileTypeFilter"><cv:msg key="label.networkStore.fileTypeFilter" bundle="storage"/><input
				type="text" data-ng-model="editNode.fileTypeFilter"
				data-ng-required="false" id="fileTypeFilter" name="fileTypeFilter" />
			</label>
		</div>  -->
	</div>
	</div>

	</form>

	<form data-ng-if="addsnap" name="addSnapView" novalidate data-cv-submit="configureNfsStoreProperties()" autocomplete="off" class="bootstrap-wrapper">
		<div class="form-horizontal">
			<div class="panel panel-default">
				<div class="panel-body">
					<div class="form-group" >
						<div class="col-xs-12 col-sm-4">
							<label for="SnapName"><cv:msg key="label.networkStore.snapName" bundle="storage"/>
						</label>
						</div>
						<div class="col-xs-12 col-sm-8">
							<input type="text"
							name="Snap Name" data-ng-model="newsnap.SnapName" required
							id="SnapName" />
						</div>
					</div>

					<div class="form-group" >
						<div class="col-xs-12 col-sm-4">
							<label for="ToTime"><cv:msg key="label.networkStore.toTime" bundle="storage"/>
						</label>
						</div>
						<div class="col-sm-6 col-xs-10">
			                <input type="text" data-ng-model="newsnap.ToTime" data-ng-readonly="true" data-ng-change="updateTime()"/>
						</div>
						<div class="col-xs-2 col-sm-2">
							<button id="networStoreProperties_button_#8961" type="button" class="btn btn-primary" data-ng-click="openTimePicker()">
			                    <i class="glyphicon glyphicon-calendar"></i>
			                </button>
						</div>
					</div>

					<div class="form-group">
						<div class="date-box" data-datetime-picker="MM/dd/yyyy HH:mm"
			                         data-is-open="newsnap.ToTimeOptions.open" data-ng-model="newsnap.ToTimeOptions.value"
			                        data-datepicker-options="newsnap.ToTimeOptions.dateOptions" data-timepicker-options="newsnap.ToTimeOptions.timeOptions"></div>
					</div>

					<div class="form-group" >
						<div class="col-xs-12 col-sm-4">
							<label for="NFSClient"><cv:msg key="label.networkStore.nfsClients" bundle="storage"/>
						</label>
						</div>
						<div class="col-xs-12 col-sm-8">
							<input type="text"
							name="NFS Clients" data-ng-model="newsnap.NFSClient" required
							id="NFSClient" />
						</div>
					</div>

				</div>
			</div>
		</div>

		<div class="modal-footer">
			<button id="configureNetworkStoreProperties_button_#2617" type="button"
				class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				data-ng-click="dismissModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="configureNetworkStoreProperties_button_#6703" type="submit" class="btn btn-primary cvBusyOnAjax"
				data-ng-click="configureNfsStoreProperties()">
				<cv:msg key="Save" bundle="messages" />
			</button>
		</div>

	</form>

	<form data-ng-show="retention" name="configureNfsStoreRetentionPropertiesForm" novalidate data-cv-submit="configureNfsStoreProperties()" autocomplete="off" class="bootstrap-wrapper">
		<div class="form-horizontal">
			<div  class="panel panel-default">
				<div class="panel-body">
					<!--<div class="form-group">
						<div class="col-xs-12 col-lg-7">
						<label><cv:msg key="label.retentionPeriodForDeletedFiles" bundle="storage"/></label>
						</div>
					</div>

					 <div class="form-group padding-left-15">
						<div class="col-xs-12 col-lg-5">
						 <input name="indefiniteRetention" type="radio" id="indefiniteRetention" value="1" data-ng-model="editNode.retention.isIndefiniteRetention" />
	                            <cv:msg key="label.inDefiniteRetention" bundle="storage"/>

	                     </div>
					</div>  -->

					<div class="form-group padding-left-15">
						<div class="col-xs-12 col-sm-7">
						<label><cv:msg key="label.retentionPeriodForDeletedFiles" bundle="storage"/></label>
						</div>
						<div class="col-sm-2 col-xs-12">
							<input name="retentionInDays" type="number" min="0"
								id="retentionInDays"
								data-ng-model="editNode.retention.retentionInDaysPreview" data-ng-if="editNode.retention.retentionPeriodValue !== '-1'" />
						</div>
						<div data-ng-class="{'col-sm-3 col-xs-12': editNode.retention.retentionPeriodValue !== '-1', 'col-sm-5 col-xs-12': editNode.retention.retentionPeriodValue === '-1'}">
							<select
								data-ng-model="editNode.retention.retentionPeriodValue">
								<option data-ng-repeat="freq in retentionPeriodFreq"
									value="{{freq.valueInDays}}" data-ng-selected="freq.valueInDays === editNode.retention.retentionPeriodValue">{{freq.name}}</option>
							</select>
						</div>
					</div>

					<!--  <div class="form-group">
						<div class="col-xs-12 col-sm-1">
							<toggle-control
								status="editNode.retention.enableRetentionRulesForVersions"
								data-ng-click="setRetentionRuleForFileVersions()"></toggle-control>

						</div>
						<div class="col-xs-12 col-sm-7">
							<label for="enableRentionForFileVersions"><cv:msg
									key="label.enableRentionForFileVersions"
									bundle="storage" /> </label>
						</div>
					</div>-->

					<div class="form-group padding-left-15">
						<div class="col-xs-12 col-sm-7">
							<span class="pageDetailColumn"><cv:msg key="label.networkStore.enableVersions" bundle="storage"/></span>
							<toggle-control status="useVersions" bundle='storage' data-ng-click="toggleUseVersion()"></toggle-control>
						</div>
					</div>

					<div class="form-group padding-left-15"  data-ng-if="useVersions == 'enabled-activity'">
						<div class="col-xs-12 col-sm-7">
							<label for="retentionPeriodForVersions"><cv:msg
									key="label.retentionPeriodForVersions" bundle="storage" />
							</label>
						</div>
						<div class="col-xs-12 col-sm-2">
							<input type="number"
								data-ng-model="editNode.retention.versionsRetentionInDaysPreview"
								id="versionsRetentionInDays" min="0"
								name="versionsRetentionInDays" data-ng-if="editNode.retention.olderVersionRetentionPeriodValue !== '-1'"/>
						</div>
						<div data-ng-class="{'col-sm-3 col-xs-12': editNode.retention.olderVersionRetentionPeriodValue !== '-1', 'col-sm-5 col-xs-12': editNode.retention.olderVersionRetentionPeriodValue === '-1'}">
							<select data-ng-model="editNode.retention.olderVersionRetentionPeriodValue">
								<option data-ng-repeat="freq in versionRetentionFreq"
									value="{{freq.valueInDays}}" data-ng-selected="freq.valueInDays === editNode.retention.olderVersionRetentionPeriodValue">{{freq.name}}</option>
							</select>
						</div>

					</div>

					<div class="form-group padding-left-15" data-ng-if="useVersions == 'enabled-activity' && editNode.retention.olderVersionRetentionPeriodValue !== '-1'">
						<div class="col-xs-12 col-sm-7">
							<label for="minNoOfVersions"><cv:msg
									key="label.retention.minNoOfVersions" bundle="storage" /> </label>
						</div>
						<div class="col-xs-12 col-sm-5">
							<input type="number"
								data-ng-model="editNode.retention.minNoOfVersionsPreview"
								id="minNoOfVersions" min="0" name="minNoOfVersions" />
						</div>
					</div>

					<div class="form-group padding-left-15" data-ng-if="useVersions == 'enabled-activity'">
						<div class="col-xs-12 col-sm-7">
							<label for="versionIntervalOfRetention"><cv:msg key="label.retention.versionInterval" bundle="storage" /> </label>
						</div>
						<div class="col-xs-12 col-sm-5">
							<input type="number" data-ng-model="editNode.versionIntervalOfRetention" id="versionInterval" min="0" name="versionInterval" /><cv:msg key="label.networkStore.minutes" bundle="storage"/>
						</div>
					</div>

				</div>
			</div>
		</div>

		<div class="modal-footer">
			<button id="configureNetworkStoreProperties_button_#2618"
				type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				data-ng-click="dismissModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="configureNetworkStoreProperties_button_#6704"
				type="submit" class="btn btn-primary cvBusyOnAjax"
				data-ng-click="configureNfsStoreProperties()">
				<cv:msg key="Save" bundle="messages" />
			</button>
		</div>
	</form>

</div>


