<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
</script>
<style type="text/css">
#edit-description-textarea {
  height: 150px;
  width: 400px;
  overflow-y: auto;
  border: 1px solid #757575;
  border-width: 1px;
  border-radius: 0; }
</style>
<div class="setup-title">
	<h1>
		<div data-ng-if="detailed">
			<!--  In case we add more properties in this section, the heading and help will have to be changed to label.configureProperties and label.configureMAProperties -->
			<cv:msg key="label.editParallelDataTransferOps" bundle="storage"/>
			<cv-help-component help-text="<cv:msg key="label.configureMAProperties" bundle="storage"/>"></cv-help-component>
		</div>
		<div data-ng-if="general">
			<cv:msg key="label.editDescription" bundle="storage"/>
			<cv-help-component help-text="<cv:msg key="label.editMADescriptionHelp" bundle="storage"/>"></cv-help-component>
		</div>
		<div data-ng-if="index">
			<cv:msg key="label.editIndexProperties" bundle="storage"/>
			<cv-help-component help-text="<cv:msg key="label.editIndexPropertiesHelp" bundle="storage"/>"></cv-help-component>
		</div>
		<div data-ng-if="powerManagement">
			<cv:msg key="title.editPowerManagement" bundle="storage"/>
			<cv-help-component help-text="<cv:msg key="label.editPowerManagementHelp" bundle="storage"/>"></cv-help-component>
		</div>
		<div data-ng-if="hybridFileStoreDetails">
			<cv:msg key="title.hybridFileStoreDetails" bundle="storage"/>
			<cv-help-component help-text="<cv:msg key="label.hybridFileStoreDetails" bundle="storage"/>"></cv-help-component>
		</div>
	</h1>
</div>
<div class="bootstrap-wrapper medium-width setup-content form-horizontal modal-margin">
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>	         
	<form name="configureMAPropertiesForm" novalidate
		data-cv-submit="configureMAProperties()" autocomplete="off"
		data-ng-hide="formConfig.hide">
		<div data-ng-if="detailed">
			<label for="noOfDataTransferOps"><cv:msg key="label.noOfDataTransferOps" bundle="storage" />
				<input type="number" name="noOfDataTransferOps" id="noOfDataTransferOps" data-ng-model="model.noOfDataTransferOps" max={{model.noOfDataTransferOpsMax}} min={{model.noOfDataTransferOpsMin}} required />
				<div data-ng-if="model.optimizeOn">
					<span class="help-block" data-ng-show="cv.configureMAPropertiesForm.needsAttention(configureMAPropertiesForm.noOfDataTransferOps)"><cv:msg key="error.noOfDataTransferOpsOptimizeOn" bundle="storage"/></span>
				</div>
				<div data-ng-if="!model.optimizeOn">
					<span class="help-block" data-ng-show="cv.configureMAPropertiesForm.needsAttention(configureMAPropertiesForm.noOfDataTransferOps)"><cv:msg key="error.noOfDataTransferOpsOptimizeOff" bundle="storage"/></span>
				</div>				
			</label>
		</div>
		<div data-ng-if="general">
			<label for="edit-description-textarea"><cv:msg key="label.description" bundle="storage" />				
				<textarea name="description" id="edit-description-textarea" data-ng-model="model.description"></textarea>
			</label>
		</div>
		<div data-ng-if="hybridFileStoreDetails">
			<div class="form-group">
				<label class="col-sm-5 col-xs-12 text-align-left" for="hybridFileStore">
					<cv:msg key="label.networkStore.cacheDirectory" bundle="storage"/>
				</label>
				<div class="col-xs-12 col-sm-7">
					<div class="input-group">
						<input type="text" 
							class="hybrid-store-input" 
							name="hybridFileStore" 
							id="hybridFileStore" 
							data-ng-class="{'has-error': cv.configureMAPropertiesForm.needsAttention(configureMAPropertiesForm.hybridFileStore)}" 
							data-ng-model="model.hybridStorePath" required data-ng-pattern='pathPattern.pattern' />
					</div>
					<span 
						class="help-block padding-top-10" 
						data-ng-value="form-error" 
						data-ng-show="configureMAPropertiesForm.hybridFileStore.$error.required 
						&& cv.configureMAPropertiesForm.needsAttention(configureMAPropertiesForm.hybridFileStore)"
					>
						<cv:msg key="error.hybridFileStoreDetails" bundle="storage"/>
					</span>
					<span class="help-block padding-top-10" data-ng-show="configureMAPropertiesForm.hybridFileStore.$error.pattern">
						<cv:msg key="error.hybridFileStoreDetails" bundle="storage"/>
					</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-sm-5 col-xs-12 text-align-left" for="pruneHighWaterMarkPercentage">
					<cv:msg key="label.networkStore.pruneHighWaterMarkPercentage" bundle="storage"/>
				</label>
				<div class="col-xs-12 col-sm-7">
					<div class="input-group">
						<input type="number"
							class="hybrid-store-input" 
							name="pruneHighWaterMarkPercentage" 
							id="pruneHighWaterMarkPercentage" 
							data-ng-class="{'has-error': cv.configureMAPropertiesForm.needsAttention(configureMAPropertiesForm.pruneHighWaterMarkPercentage)}" 
							data-ng-model="model.pruneHighWaterMark"
							min="0"
							max="100"
							required
							style="max-width: 50px;"
						/>
					</div>
					<span 
						class="help-block padding-top-10" 
						data-ng-value="form-error" 
						data-ng-show="configureMAPropertiesForm.pruneHighWaterMarkPercentage.$error.required 
						&& cv.configureMAPropertiesForm.needsAttention(configureMAPropertiesForm.pruneHighWaterMarkPercentage)"
					>
						<cv:msg key="error.pruneHighWaterMark" bundle="storage"/>
					</span>
					<span 
						class="help-block padding-top-10" 
						data-ng-value="form-error" 
						data-ng-show="configureMAPropertiesForm.pruneHighWaterMarkPercentage.$error.max ||
						configureMAPropertiesForm.pruneHighWaterMarkPercentage.$error.min
						&& cv.configureMAPropertiesForm.needsAttention(configureMAPropertiesForm.pruneHighWaterMarkPercentage)"
					>
						<cv:msg key="error.pruneHighWaterMark" bundle="storage"/>
					</span>	
				</div>
			</div>
		</div>
		<div data-ng-if="index">
<!-- 		Hide this field until backend is able to support update retention days
			<div class="form-group padding-top-10">
				<div class="col-sm-5 col-xs-12 text-align-left">
					<label for="description">
						<cv:msg key="label.retentionperiod" bundle="archiving" />
					</label>
				</div>
				<div class="col-xs-12 col-sm-7">
					<input id="indexRetentionDays" class="full-width" type="number" name="indexRetentionDays" data-ng-model="model.indexRetentionDays" max="999" min="1" required />
					<span class="help-block padding-top-10" 
					data-ng-show="cv.configureMAPropertiesForm.needsAttention(configureMAPropertiesForm.indexRetentionDays)">
						<cv:msg key="error.noRetention" bundle="storage" />
					</span>
				</div>
			</div> -->
			<div class="form-group padding-top-10"> 
				<label class="col-sm-5 col-xs-12 text-align-left" for="indexPath">
					<cv:msg key="label.indexDirectory" bundle="profiles"/>
				</label>
				<div class="col-xs-12 col-sm-7">
					<div class="input-group">
						<input type="text" 
							class="indexServerPath" 
							name="indexPath" 
							id="indexPath" 
							data-ng-class="{'has-error': cv.configureMAPropertiesForm.needsAttention(configureMAPropertiesForm.indexPath)}" 
							data-ng-model="model.indexDirectoryPath" required data-ng-pattern='pathPattern.pattern' />
						<span class="input-group-btn">
							<button id="configureMediaAgentProperties_button_#0883" type="button" data-ng-click="browse(false)"
								class="icon-style cv-material-button browse"> 
								<div class="cv-material-button-icon cursor-pointer">
									<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
								</div><div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
							</button>
						</span>
					</div>
					<span class="help-block padding-top-10" data-ng-value="form-error" 
					data-ng-show="configureMAPropertiesForm.indexPath.$error.required 
					&& cv.configureMAPropertiesForm.needsAttention(configureMAPropertiesForm.indexPath)">
						<cv:msg key="error.indexDirectoryRequired" bundle="storage"/>
					</span>					
					<span class="help-block padding-top-10" 
						data-ng-show="configureMAPropertiesForm.indexPath.$error.pattern 
						&& cv.configureMAPropertiesForm.needsAttention(configureMAPropertiesForm.indexPath)">
						<cv:msg key="error.invalidIndexDirectory" bundle="storage"/>
					</span>
				</div>
			</div>
			<div class="form-group"> 
				<div class="col-xs-12 col-md-12 col-lg-12 margin-top-30">
					<label class="col-sm-5 col-xs-12 text-align-left padding-left-0" for="cachePath">
						<cv:msg key="label.cacheSlider" bundle="profiles"/>
					</label>
					<toggle-control
						class="margin-right-5 margin-left-20 logs-cache-toggle"
						status="showLogsCache ? 'enabled-activity' : 'disabled-activity'"
						data-ng-click="onToggleLogsCache()">
					</toggle-control>
				</div>
			</div>
			<div class="form-group margin-top-20" data-ng-if="showLogsCache">
				<label class="col-sm-5 col-xs-12 text-align-left" for="cachePath">
					<cv:msg key="label.cacheDirectory" bundle="profiles"/>
				</label>
				<div class="col-xs-12 col-sm-7">
					<div class="input-group">
						<input type="text" 
							class="indexServerPathCache" 
							name="cachePath" 
							id="cachePath" 
							data-ng-class="{'has-error': cv.configureMAPropertiesForm.needsAttention(configureMAPropertiesForm.cachePath)}" 
							data-ng-model="model.cachePath" required data-ng-pattern='pathPattern.pattern' />
						<span class="input-group-btn">
							<button id="configureMediaAgentProperties_button_#0884" type="button" data-ng-click="browse(true)"
								class="icon-style cv-material-button browse"> 
								<div class="cv-material-button-icon cursor-pointer">
									<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
								</div><div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
							</button>
						</span>
					</div>
					<span class="help-block padding-top-10" data-ng-value="form-error" 
					data-ng-show="configureMAPropertiesForm.cachePath.$error.required 
					&& cv.configureMAPropertiesForm.needsAttention(configureMAPropertiesForm.cachePath)">
						<cv:msg key="error.cacheDirectoryRequired" bundle="storage"/>
					</span>					
					<span class="help-block padding-top-10" 
						data-ng-show="configureMAPropertiesForm.cachePath.$error.pattern 
						&& cv.configureMAPropertiesForm.needsAttention(configureMAPropertiesForm.cachePath)">
						<cv:msg key="error.invalidCacheDirectory" bundle="storage"/>
					</span>
				</div>
			</div>
		</div>
		<div class= " bootstrap-wrapper" data-ng-if="powerManagement" data-ng-disabled="!powerManagementOptions.powerManagementInfo.isPowerMgmtAllowed">
			<div class = "modal-margin">
				<label for="useClientGroupSettingId">
					<input type="radio" id = "useClientGroupSettingId" data-ng-model= "powerManagementOptions.useMediaAgent"  ng-value="false" name="useClientGroupSettingName">				
					<cv:msg key="label.useClientGrouSettings" bundle="storage" />
				</label>		
				<div class="panel-body">
					<div class="form-group"  data-ng-disabled= "powerManagementOptions.useMediaAgent">	
						<div data-ng-if="!powerManagementOptions.powerManagementInfo.clientGroup.clientGroupName">
							<div class="col-sm-10 col-lg-5">
								<label for="clientGroup"><cv:msg key="label.serverGroup" bundle="storage"/></label>
							</div>	
							<div class="col-sm-10 col-lg-7">	
								<label  for="cloudControllerVal"><cv:msg key="label.notAssociated" bundle="storage"/></label>
							</div>	
							<div class="col-sm-10 col-lg-5">
								<label for="powerManagement"><cv:msg key="label.powerManagement" bundle="storage"/></label>
							</div>
							<div class="col-sm-10 col-lg-7">	
								<label  for="cloudControllerVal"><cv:msg key="label.notApplicable" bundle="storage"/></label>
							</div>
							<div class="col-sm-10 col-lg-5">
								<label for="cloudController"><cv:msg key="label.cloudController" bundle="storage"/></label>
							</div>										
							<div class="col-sm-10 col-lg-7">	
								<label  for="cloudControllerVal"><cv:msg key="label.notApplicable" bundle="storage"/></label>
							</div>	
						</div>
						<div data-ng-if="powerManagementOptions.powerManagementInfo.clientGroup.clientGroupName">
							<div class="col-sm-10 col-lg-5">
								<label for="clientGroup"><cv:msg key="label.serverGroup" bundle="storage"/></label>
							</div>	
							<div class="col-sm-10 col-lg-7" data-ng-if="powerManagementOptions.powerManagementInfo.clientGroup.clientGroupName">	
								<label  for="clientGroupVal">{{powerManagementOptions.powerManagementInfo.clientGroup.clientGroupName}}</label>
							</div>
							<div class="col-sm-10 col-lg-5">
								<label for="powerManagement"><cv:msg key="label.powerManagement" bundle="storage"/></label>
							</div>		
							<div class="col-sm-10 col-lg-7">	
								<label  for="powerManagementVal"><cv:msg key="label.yes" bundle="storage"/></label>
							</div>
							<div class="col-sm-10 col-lg-5">
								<label for="cloudController"><cv:msg key="label.cloudController" bundle="storage"/></label>
							</div>		
							<div class="col-sm-10 col-lg-7">	
								<label  for="cloudControllerVal">{{powerManagementOptions.powerManagementInfo.selectedCloudController.clientName}}</label>
							</div>
						</div>
					</div>				
				</div>
				<label for="useMediaAgentSettingId">
					<input type="radio" id = "useMediaAgentSettingId" data-ng-model= "powerManagementOptions.useMediaAgent" ng-value="true" name="useClientGroupSettingName">				
					<cv:msg key="label.useMediaAgentSettings" bundle="storage" /> 
				</label>
				<div class="panel-body">	
					<div class="form-group"  data-ng-disabled= "!powerManagementOptions.useMediaAgent">	
						<div class="col-sm-10 col-lg-12">				
							<input type="checkbox" id="powerManagementChk" data-ng-model="powerManagementOptions.powerManagementInfo.isPowerManagementEnabled"> 
							<label for ="powerManagementChk">					
								<cv:msg key="label.enablePowerManagement" bundle="storage"/>
							</label>
						</div>
					</div>					
					<div class="form-group" data-ng-disabled= "!powerManagementOptions.useMediaAgent ||  !powerManagementOptions.powerManagementInfo.isPowerManagementEnabled">						
						<div class="col-sm-10 col-lg-5">		
							<label  for="cloudControllerId">
								<cv:msg key="label.cloudController" bundle="storage" />						
							</label>
						</div>				
						<div class="col-sm-10 col-lg-7">
							<select name="powermgntName"  id="cloudControllerId"
								data-ng-options=" clientEntity.clientName for clientEntity in powerManagementOptions.CloudControllerList track by clientEntity.clientId"  
								data-ng-model=powerManagementOptions.powerManagementInfo.selectedCloudController>
							</select>
						</div>	
					</div>				
				</div>
			</div>	
		</div>
	
			
		<div class="button-container">
			<button id="configureMediaAgentProperties_button_#9159" type="button" data-ng-if="isCurrentStepCompleted()" 
				class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()">
				<cv:msg key="Skip" bundle="messages" />
			</button>
			<button id="configureMediaAgentProperties_button_#3698" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" 
				data-ng-click="dismissModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="configureMediaAgentProperties_button_#3959" type="submit" class="btn btn-primary cvBusyOnAjax"> 
				<cv:msg key="Save" bundle="messages" />
			</button>
		</div>
	</form>
	<div class="button-container centered"
		data-ng-show="formConfig.hide">
		<button id="configureMediaAgentProperties_button_#6370" type="button" 
			class="btn btn-default cvBusyOnAjax skip-btn--hidden"
			data-ng-click="skip()">
			<cv:msg key="Continue" bundle="messages" />
		</button>
	</div>
</div>
